# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class SILBuilder(Object):
    """
    SILBuilder - helper class to build a SIL i.e.
    
    Superclass: Object
    
    a directed graph used by reader producing composite datasets to
    describes the relationships among the blocks.
    
    SILBuilder is a helper class to build a SIL i.e. a directed graph
    used by reader producing composite datasets to describes the
    relationships among the blocks. Refer to
    http://www.paraview.org/Wiki/Block_Hierarchy_Meta_Data for details.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSILBuilder, obj, update, **traits)
    
    def _get_sil(self):
        return wrap_vtk(self._vtk_obj.GetSIL())
    def _set_sil(self, arg):
        old_val = self._get_sil()
        self._wrap_call(self._vtk_obj.SetSIL,
                        deref_vtk(arg))
        self.trait_property_changed('sil', old_val, arg)
    sil = traits.Property(_get_sil, _set_sil, desc=\
        """
        Get/Set the graph to populate.
        """
    )

    def _get_root_vertex(self):
        return self._vtk_obj.GetRootVertex()
    root_vertex = traits.Property(_get_root_vertex, desc=\
        """
        Returns the vertex id for the root vertex.
        """
    )

    def add_child_edge(self, *args):
        """
        V.add_child_edge(int, int) -> int
        C++: IdType AddChildEdge(IdType parent, IdType child)
        Add vertex, child-edge or cross-edge to the graph.
        """
        ret = self._wrap_call(self._vtk_obj.AddChildEdge, *args)
        return ret

    def add_cross_edge(self, *args):
        """
        V.add_cross_edge(int, int) -> int
        C++: IdType AddCrossEdge(IdType src, IdType dst)
        Add vertex, child-edge or cross-edge to the graph.
        """
        ret = self._wrap_call(self._vtk_obj.AddCrossEdge, *args)
        return ret

    def add_vertex(self, *args):
        """
        V.add_vertex(string) -> int
        C++: IdType AddVertex(const char *name)
        Add vertex, child-edge or cross-edge to the graph.
        """
        ret = self._wrap_call(self._vtk_obj.AddVertex, *args)
        return ret

    def initialize(self):
        """
        V.initialize()
        C++: void Initialize()
        Initializes the data-structures.
        """
        ret = self._vtk_obj.Initialize()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SILBuilder, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SILBuilder properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit SILBuilder properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SILBuilder properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

