/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.PropertyStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundleFileStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertiesUpdateManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.structureView.PropertiesPrefixGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NewPropertyAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(NewPropertyAction.class);
    private static final String ADD_NEW_PROPERTY_AFTER_SELECTED_PROP = "add.property.after.selected";
    private final boolean myEnabledForce;

    NewPropertyAction() {
        this(false);
    }

    NewPropertyAction(boolean enabledForce) {
        super("New Property", null, AllIcons.General.Add);
        this.myEnabledForce = enabledForce;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        IProperty anchor;
        String keyToInsert;
        String separator;
        String prefix;
        ResourceBundleEditor resourceBundleEditor;
        Project project;
        if (e == null) {
            NewPropertyAction.$$$reportNull$$$0(0);
        }
        if ((project = NewPropertyAction.getEventProject((AnActionEvent)e)) == null) {
            return;
        }
        DataContext context = e.getDataContext();
        FileEditor fileEditor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context);
        if (fileEditor instanceof ResourceBundleEditor) {
            resourceBundleEditor = (ResourceBundleEditor)fileEditor;
        } else {
            FileEditor[] editor = (FileEditor[])CommonDataKeys.EDITOR.getData(context);
            ResourceBundleEditor resourceBundleEditor2 = resourceBundleEditor = editor != null ? (ResourceBundleEditor)((Object)editor.getUserData(ResourceBundleEditor.RESOURCE_BUNDLE_EDITOR_KEY)) : null;
        }
        if (resourceBundleEditor == null) {
            for (FileEditor editor : FileEditorManager.getInstance((Project)project).getSelectedEditors()) {
                if (!(editor instanceof ResourceBundleEditor)) continue;
                resourceBundleEditor = (ResourceBundleEditor)editor;
            }
            if (resourceBundleEditor == null) {
                return;
            }
        }
        ResourceBundle bundle = resourceBundleEditor.getResourceBundle();
        VirtualFile file = bundle.getDefaultPropertiesFile().getVirtualFile();
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(file));
        if (status.hasReadonlyFiles()) {
            Messages.showErrorDialog((Project)bundle.getProject(), (String)String.format("Resource bundle '%s' has read-only default properties file", bundle.getBaseName()), (String)"Can't Create New Property");
            return;
        }
        String place = e.getPlace();
        if ("StructureViewToolbar".equals(place)) {
            prefix = null;
            separator = null;
        } else {
            ResourceBundleEditorViewElement selectedElement = resourceBundleEditor.getSelectedElementIfOnlyOne();
            if (selectedElement == null) {
                return;
            }
            if (selectedElement instanceof PropertiesPrefixGroup) {
                PropertiesPrefixGroup group = (PropertiesPrefixGroup)selectedElement;
                prefix = group.getPrefix();
                separator = group.getSeparator();
            } else if (selectedElement instanceof PropertyStructureViewElement || selectedElement instanceof ResourceBundleFileStructureViewElement) {
                prefix = null;
                separator = null;
            } else {
                throw new IllegalStateException("unsupported type: " + selectedElement.getClass());
            }
        }
        ResourceBundlePropertiesUpdateManager propertiesUpdateManager = resourceBundleEditor.getPropertiesInsertDeleteManager();
        NewPropertyNameValidator nameValidator = new NewPropertyNameValidator(resourceBundleEditor, prefix, separator);
        IProperty selectedProperty = resourceBundleEditor.getSelectedProperty();
        if (propertiesUpdateManager.isAlphaSorted() || !propertiesUpdateManager.isSorted() || selectedProperty == null) {
            keyToInsert = Messages.showInputDialog((Project)project, (String)PropertiesBundle.message("new.property.dialog.name.prompt.text", new Object[0]), (String)PropertiesBundle.message("new.property.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)(selectedProperty == null ? NewPropertyAction.getSelectedPrefixText(resourceBundleEditor) : null), (InputValidator)nameValidator);
            anchor = null;
        } else {
            Pair keyNameAndInsertPlaceModification = Messages.showInputDialogWithCheckBox((String)PropertiesBundle.message("new.property.dialog.name.prompt.text", new Object[0]), (String)PropertiesBundle.message("new.property.dialog.title", new Object[0]), (String)PropertiesBundle.message("new.property.dialog.checkbox.text", new Object[0]), (boolean)PropertiesComponent.getInstance().getBoolean(ADD_NEW_PROPERTY_AFTER_SELECTED_PROP, false), (boolean)true, (Icon)Messages.getQuestionIcon(), null, (InputValidator)nameValidator);
            keyToInsert = (String)keyNameAndInsertPlaceModification.getFirst();
            Boolean insertAfterSelectedProperty = (Boolean)keyNameAndInsertPlaceModification.getSecond();
            PropertiesComponent.getInstance().setValue(ADD_NEW_PROPERTY_AFTER_SELECTED_PROP, insertAfterSelectedProperty.booleanValue(), false);
            IProperty iProperty = anchor = insertAfterSelectedProperty != false ? selectedProperty : null;
        }
        if (keyToInsert != null) {
            ResourceBundlePropertiesUpdateManager updateManager = resourceBundleEditor.getPropertiesInsertDeleteManager();
            Runnable insertionAction = () -> {
                if (anchor == null) {
                    updateManager.insertNewProperty(keyToInsert, "");
                } else {
                    String anchorKey = anchor.getKey();
                    LOG.assertTrue(anchorKey != null);
                    updateManager.insertAfter(keyToInsert, "", anchorKey);
                }
            };
            ResourceBundleEditor finalResourceBundleEditor = resourceBundleEditor;
            ApplicationManager.getApplication().runWriteAction(() -> {
                WriteCommandAction.runWriteCommandAction((Project)bundle.getProject(), (Runnable)insertionAction);
                finalResourceBundleEditor.flush();
            });
            resourceBundleEditor.updateTreeRoot();
            resourceBundleEditor.getStructureViewComponent().select((Object)keyToInsert, false).onProcessed(p -> finalResourceBundleEditor.selectProperty(keyToInsert));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            NewPropertyAction.$$$reportNull$$$0(1);
        }
        if (!this.myEnabledForce) {
            FileEditor editor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
            e.getPresentation().setEnabledAndVisible(editor instanceof ResourceBundleEditor);
        }
    }

    @Nullable
    private static String getSelectedPrefixText(@NotNull ResourceBundleEditor resourceBundleEditor) {
        ResourceBundleEditorViewElement item;
        Collection<ResourceBundleEditorViewElement> elements;
        if (resourceBundleEditor == null) {
            NewPropertyAction.$$$reportNull$$$0(2);
        }
        if ((elements = resourceBundleEditor.getSelectedElements()).size() == 1 && (item = (ResourceBundleEditorViewElement)ContainerUtil.getFirstItem(elements)) instanceof PropertiesPrefixGroup) {
            PropertiesPrefixGroup prefixGroup = (PropertiesPrefixGroup)item;
            return prefixGroup.getPrefix() + prefixGroup.getSeparator();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundleEditor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/properties/editor/NewPropertyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedPrefixText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NewPropertyNameValidator
    implements InputValidator {
        @NotNull
        private final ResourceBundleEditor myResourceBundleEditor;
        @Nullable
        private final String myPrefix;
        @Nullable
        private final String mySeparator;

        NewPropertyNameValidator(@NotNull ResourceBundleEditor resourceBundleEditor, @Nullable String prefix, @Nullable String separator) {
            if (resourceBundleEditor == null) {
                NewPropertyNameValidator.$$$reportNull$$$0(0);
            }
            this.myResourceBundleEditor = resourceBundleEditor;
            this.myPrefix = prefix;
            this.mySeparator = separator;
        }

        public boolean checkInput(String inputString) {
            return !inputString.isEmpty();
        }

        public boolean canClose(String inputString) {
            String newPropertyName = this.myPrefix == null ? inputString : this.myPrefix + this.mySeparator + inputString;
            ResourceBundle resourceBundle = this.myResourceBundleEditor.getResourceBundle();
            for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
                IProperty key = propertiesFile.findPropertyByKey(newPropertyName);
                if (key == null) continue;
                Messages.showErrorDialog((String)("Can't add new property. Property with key '" + newPropertyName + "' already exists."), (String)"New Property");
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundleEditor", "com/intellij/lang/properties/editor/NewPropertyAction$NewPropertyNameValidator", "<init>"));
        }
    }
}

