/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;

public class CodeCleanupCheckinHandlerFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
        if (panel2 == null) {
            CodeCleanupCheckinHandlerFactory.$$$reportNull$$$0(0);
        }
        if (commitContext == null) {
            CodeCleanupCheckinHandlerFactory.$$$reportNull$$$0(1);
        }
        CleanupCodeCheckinHandler cleanupCodeCheckinHandler = new CleanupCodeCheckinHandler(panel2);
        if (cleanupCodeCheckinHandler == null) {
            CodeCleanupCheckinHandlerFactory.$$$reportNull$$$0(2);
        }
        return cleanupCodeCheckinHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/checkin/CodeCleanupCheckinHandlerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/checkin/CodeCleanupCheckinHandlerFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CleanupCodeCheckinHandler
    extends CheckinHandler
    implements CheckinMetaHandler {
        private final CheckinProjectPanel myPanel;
        private final Project myProject;

        CleanupCodeCheckinHandler(CheckinProjectPanel panel2) {
            this.myProject = panel2.getProject();
            this.myPanel = panel2;
        }

        public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
            return new BooleanCommitOption(this.myPanel, VcsBundle.message((String)"before.checkin.cleanup.code", (Object[])new Object[0]), true, (Function0<Boolean>)((Function0)() -> this.getSettings().CHECK_CODE_CLEANUP_BEFORE_PROJECT_COMMIT), value -> {
                this.getSettings().CHECK_CODE_CLEANUP_BEFORE_PROJECT_COMMIT = value;
            });
        }

        public void runCheckinHandlers(@NotNull Runnable runnable) {
            if (runnable == null) {
                CleanupCodeCheckinHandler.$$$reportNull$$$0(0);
            }
            if (this.getSettings().CHECK_CODE_CLEANUP_BEFORE_PROJECT_COMMIT && !DumbService.isDumb((Project)this.myProject)) {
                List<VirtualFile> filesToProcess = CheckinHandlerUtil.filterOutGeneratedAndExcludedFiles(this.myPanel.getVirtualFiles(), this.myProject);
                GlobalInspectionContextBase.modalCodeCleanup((Project)this.myProject, (AnalysisScope)new AnalysisScope(this.myProject, filesToProcess), (Runnable)runnable);
            } else {
                runnable.run();
            }
        }

        @NotNull
        private VcsConfiguration getSettings() {
            VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
            if (vcsConfiguration == null) {
                CleanupCodeCheckinHandler.$$$reportNull$$$0(1);
            }
            return vcsConfiguration;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/checkin/CodeCleanupCheckinHandlerFactory$CleanupCodeCheckinHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/checkin/CodeCleanupCheckinHandlerFactory$CleanupCodeCheckinHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "runCheckinHandlers";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

