/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.util;

import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegexUtil {
    public static boolean match(@Nullable Pattern pattern, @Nullable String path) {
        if (pattern == null || path == null) {
            return false;
        }
        String[] parts = RegexUtil.getParts(pattern);
        boolean result2 = false;
        if (parts.length == 0 || RegexUtil.matchAllParts(parts, path)) {
            try {
                result2 = pattern.matcher(path).find();
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return result2;
    }

    public static boolean matchAllParts(@Nullable String[] parts, @Nullable String path) {
        if (parts == null || path == null) {
            return false;
        }
        int index = -1;
        for (String part : parts) {
            if ((index = path.indexOf(part, index)) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean matchAnyPart(@Nullable String[] parts, @Nullable String path) {
        if (parts == null || path == null) {
            return false;
        }
        for (String part : parts) {
            if (!path.contains(part)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String[] getParts(@Nullable Pattern pattern) {
        if (pattern == null) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                RegexUtil.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> parts = new ArrayList<String>();
        String sPattern = pattern.toString();
        StringBuilder part = new StringBuilder();
        boolean inSquare = false;
        for (int i = 0; i < sPattern.length(); ++i) {
            char ch = sPattern.charAt(i);
            if (!inSquare && Character.isLetterOrDigit(ch)) {
                part.append(sPattern.charAt(i));
            } else if (part.length() > 0) {
                parts.add(part.toString());
                part = new StringBuilder();
            }
            inSquare = ch != ']' && (ch == '[' || inSquare);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(parts);
        if (stringArray == null) {
            RegexUtil.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ignore/util/RegexUtil", "getParts"));
    }
}

