/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AnonymousGroupInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Anonymous capturing group or numeric back reference" == null) {
            AnonymousGroupInspection.$$$reportNull$$$0(0);
        }
        return "Anonymous capturing group or numeric back reference";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AnonymousGroupInspection.$$$reportNull$$$0(1);
        }
        AnonymousGroupVisitor anonymousGroupVisitor = new AnonymousGroupVisitor(holder);
        if (anonymousGroupVisitor == null) {
            AnonymousGroupInspection.$$$reportNull$$$0(2);
        }
        return anonymousGroupVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/inspection/AnonymousGroupInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/inspection/AnonymousGroupInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AnonymousGroupVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        AnonymousGroupVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpGroup(RegExpGroup group) {
            if (group.getType() != RegExpGroup.Type.CAPTURING_GROUP) {
                return;
            }
            Collection<RegExpGroup.Type> types = RegExpLanguageHosts.getInstance().getSupportedNamedGroupTypes(group);
            if (types.isEmpty()) {
                return;
            }
            this.myHolder.registerProblem(group.getFirstChild(), "Anonymous capturing group", new LocalQuickFix[0]);
        }

        @Override
        public void visitRegExpBackref(RegExpBackref backref) {
            Collection<RegExpGroup.Type> types = RegExpLanguageHosts.getInstance().getSupportedNamedGroupTypes(backref);
            if (types.isEmpty()) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)backref, "Numeric back reference", new LocalQuickFix[0]);
        }
    }
}

