/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.util.DocumentUtil;

public class JoinLinesAction
extends TextComponentEditorAction {
    public JoinLinesAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        Handler() {
            super(true);
        }

        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            Document doc = editor.getDocument();
            LogicalPosition caretPosition = caret.getLogicalPosition();
            int startLine = caretPosition.line;
            int endLine = startLine + 1;
            if (caret.hasSelection()) {
                startLine = doc.getLineNumber(caret.getSelectionStart());
                endLine = doc.getLineNumber(caret.getSelectionEnd());
                if (doc.getLineStartOffset(endLine) == caret.getSelectionEnd()) {
                    --endLine;
                }
            }
            int[] caretRestoreOffset = new int[]{-1};
            int lineCount = endLine - startLine;
            int line2 = startLine;
            DocumentUtil.executeInBulk(doc, lineCount > 1000, () -> {
                for (int i = 0; i < lineCount && line2 < doc.getLineCount() - 1; ++i) {
                    int start2;
                    CharSequence text2 = doc.getCharsSequence();
                    int end = doc.getLineEndOffset(line2) + doc.getLineSeparatorLength(line2);
                    for (start2 = end - doc.getLineSeparatorLength(line2); start2 > 0 && (text2.charAt(start2) == ' ' || text2.charAt(start2) == '\t'); --start2) {
                    }
                    if (caretRestoreOffset[0] == -1) {
                        caretRestoreOffset[0] = start2 + 1;
                    }
                    while (end < doc.getTextLength() && (text2.charAt(end) == ' ' || text2.charAt(end) == '\t')) {
                        ++end;
                    }
                    doc.replaceString(start2, end, (CharSequence)" ");
                }
            });
            if (caret.hasSelection()) {
                caret.moveToOffset(caret.getSelectionEnd());
            } else if (caretRestoreOffset[0] != -1) {
                caret.moveToOffset(caretRestoreOffset[0]);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                caret.removeSelection();
            }
        }
    }
}

