/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaRadioButtonBorder;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.UIUtilities;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import javax.swing.text.View;

public class DarculaRadioButtonUI
extends MetalRadioButtonUI {
    private static final Icon DEFAULT_ICON = ((EmptyIcon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)19))).asUIResource();
    private final PropertyChangeListener textChangedListener = e -> DarculaRadioButtonUI.updateTextPosition((AbstractButton)e.getSource());

    public static ComponentUI createUI(JComponent c2) {
        return new DarculaRadioButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setIconTextGap(this.textIconGap());
        DarculaRadioButtonUI.updateTextPosition(b);
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener("text", this.textChangedListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton button2) {
        super.uninstallListeners(button2);
        button2.removePropertyChangeListener("text", this.textChangedListener);
    }

    protected int textIconGap() {
        return JBUIScale.scale((int)4);
    }

    private static void updateTextPosition(AbstractButton b) {
        b.setVerticalTextPosition(DarculaUIUtil.isMultiLineHTML(b.getText()) ? 1 : 0);
    }

    @Override
    public void paint(Graphics g2d, JComponent c2) {
        Graphics2D g = (Graphics2D)g2d;
        Dimension size = c2.getSize();
        AbstractButton b = (AbstractButton)c2;
        Rectangle viewRect = this.updateViewRect(b, new Rectangle(size));
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Font f = c2.getFont();
        g.setFont(f);
        FontMetrics fm = UIUtilities.getFontMetrics((JComponent)c2, (Graphics)g, (Font)f);
        String text2 = SwingUtilities.layoutCompoundLabel(c2, fm, b.getText(), this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (c2.isOpaque()) {
            g.setColor(c2.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        this.paintIcon(c2, g, viewRect, iconRect);
        this.drawText(b, g, text2, textRect, fm);
    }

    protected Rectangle updateViewRect(AbstractButton b, Rectangle viewRect) {
        if (!(b.getBorder() instanceof DarculaRadioButtonBorder)) {
            JBInsets.removeFrom((Rectangle)viewRect, (Insets)b.getInsets());
        }
        return viewRect;
    }

    protected void paintIcon(JComponent c2, Graphics2D g, Rectangle viewRect, Rectangle iconRect) {
        Icon icon = LafIconLookup.getIcon((String)"radio", (boolean)((AbstractButton)c2).isSelected(), (boolean)c2.hasFocus(), (boolean)c2.isEnabled());
        icon.paintIcon(c2, g, iconRect.x, iconRect.y);
    }

    protected void drawText(AbstractButton b, Graphics2D g, String text2, Rectangle textRect, FontMetrics fm) {
        if (text2 != null) {
            View v = (View)b.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                g.setColor(b.isEnabled() ? b.getForeground() : this.getDisabledTextColor());
                int mnemonicIndex = DarculaLaf.isAltPressed() ? b.getDisplayedMnemonicIndex() : -1;
                UIUtilities.drawStringUnderlineCharAt((JComponent)b, (Graphics)g, (String)text2, (int)mnemonicIndex, (int)textRect.x, (int)(textRect.y + fm.getAscent()));
            }
        }
        if (b.hasFocus() && b.isFocusPainted() && textRect.width > 0 && textRect.height > 0) {
            this.paintFocus(g, textRect, b.getSize());
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        return this.updatePreferredSize(c2, super.getPreferredSize(c2));
    }

    @Override
    public Dimension getMaximumSize(JComponent c2) {
        return this.getPreferredSize(c2);
    }

    protected Dimension updatePreferredSize(JComponent c2, Dimension size) {
        if (c2.getBorder() instanceof DarculaRadioButtonBorder) {
            JBInsets.removeFrom((Dimension)size, (Insets)c2.getInsets());
        }
        return size;
    }

    @Override
    protected void paintFocus(Graphics g, Rectangle t, Dimension d) {
    }

    @Override
    public Icon getDefaultIcon() {
        return DEFAULT_ICON;
    }
}

