/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.impl.ProjectNewWindowDoNotAskOption;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.ui.AppIcon;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.SystemIndependent;

public class ProjectUtil {
    private static final Logger LOG = Logger.getInstance(ProjectUtil.class);
    public static final String MODE_PROPERTY = "OpenOrAttachDialog.OpenMode";
    public static final String MODE_ATTACH = "attach";
    public static final String MODE_REPLACE = "replace";
    public static final String MODE_NEW = "new";

    private ProjectUtil() {
    }

    public static void updateLastProjectLocation(String projectFilePath) {
        File lastProjectLocation = new File(projectFilePath);
        if (lastProjectLocation.isFile()) {
            lastProjectLocation = lastProjectLocation.getParentFile();
        }
        if (lastProjectLocation == null) {
            return;
        }
        if ((lastProjectLocation = lastProjectLocation.getParentFile()) == null) {
            return;
        }
        String path = lastProjectLocation.getPath();
        try {
            path = FileUtil.resolveShortWindowsName((String)path);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return;
        }
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(PathUtil.toSystemIndependentName((String)path));
    }

    public static boolean closeAndDispose(@NotNull Project project) {
        if (project == null) {
            ProjectUtil.$$$reportNull$$$0(0);
        }
        return ProjectManagerEx.getInstanceEx().closeAndDispose(project);
    }

    @Nullable
    public static Project openOrImport(@NotNull @SystemIndependent String path, Project projectToClose, boolean forceOpenInNewFrame) {
        ProjectOpenProcessor provider;
        Project existing;
        if (path == null) {
            ProjectUtil.$$$reportNull$$$0(1);
        }
        if ((existing = ProjectUtil.findAndFocusExistingProjectForPath(path)) != null) {
            return existing;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        if (virtualFile == null) {
            return null;
        }
        virtualFile.refresh(false, false);
        ProjectOpenProcessor strong = ProjectOpenProcessor.getStrongImportProvider((VirtualFile)virtualFile);
        if (strong != null) {
            return strong.doOpenProject(virtualFile, projectToClose, forceOpenInNewFrame);
        }
        if (ProjectUtil.isValidProjectPath(virtualFile)) {
            return ProjectUtil.openProject(path, projectToClose, forceOpenInNewFrame);
        }
        if (virtualFile.isDirectory()) {
            for (VirtualFile child2 : virtualFile.getChildren()) {
                String childPath = child2.getPath();
                if (!childPath.endsWith(".ipr")) continue;
                return ProjectUtil.openProject(childPath, projectToClose, forceOpenInNewFrame);
            }
        }
        if ((provider = ProjectOpenProcessor.getImportProvider((VirtualFile)virtualFile)) != null) {
            Project project = provider.doOpenProject(virtualFile, projectToClose, forceOpenInNewFrame);
            if (project != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    ToolWindow toolWindow;
                    if (!project.isDisposed() && (toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.PROJECT_VIEW)) != null) {
                        toolWindow.activate(null);
                    }
                }, ModalityState.NON_MODAL);
            }
            return project;
        }
        return null;
    }

    @Nullable
    public static Project openProject(@NotNull String path, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        File dir;
        File file2;
        if (path == null) {
            ProjectUtil.$$$reportNull$$$0(2);
        }
        if (!(file2 = new File(path)).exists()) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{path}), (String)CommonBundle.getErrorTitle());
            return null;
        }
        if (file2.isDirectory() && !(dir = new File(file2, ".idea")).exists()) {
            String message = IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{dir.getPath()});
            Messages.showErrorDialog((String)message, (String)CommonBundle.getErrorTitle());
            return null;
        }
        Project existing = ProjectUtil.findAndFocusExistingProjectForPath(path);
        if (existing != null) {
            return existing;
        }
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (!forceOpenInNewFrame && openProjects.length > 0) {
            int exitCode = ProjectUtil.confirmOpenNewProject(false);
            if (exitCode == 1) {
                Project toClose;
                Project project = toClose = projectToClose != null ? projectToClose : openProjects[openProjects.length - 1];
                if (!ProjectManagerEx.getInstanceEx().closeAndDispose(toClose)) {
                    return null;
                }
            } else if (exitCode != 0) {
                return null;
            }
        }
        if (ProjectUtil.isRemotePath(path) && !RecentProjectsManager.getInstance().hasPath(PathUtil.toSystemIndependentName((String)path)) && !ProjectUtil.confirmLoadingFromRemotePath(path, "warning.load.project.from.share", "title.load.project.from.share")) {
            return null;
        }
        Ref result2 = new Ref();
        TransactionGuard.getInstance().submitTransactionAndWait(() -> {
            try {
                result2.set((Object)ProjectManager.getInstance().loadAndOpenProject(path));
            }
            catch (Exception e) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.load.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            }
        });
        return (Project)result2.get();
    }

    public static boolean confirmLoadingFromRemotePath(@NotNull String path, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String msgKey, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        if (path == null) {
            ProjectUtil.$$$reportNull$$$0(3);
        }
        if (msgKey == null) {
            ProjectUtil.$$$reportNull$$$0(4);
        }
        if (titleKey == null) {
            ProjectUtil.$$$reportNull$$$0(5);
        }
        return ProjectUtil.showYesNoDialog(IdeBundle.message((String)msgKey, (Object[])new Object[]{path}), titleKey);
    }

    public static boolean showYesNoDialog(@NotNull String message, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        if (message == null) {
            ProjectUtil.$$$reportNull$$$0(6);
        }
        if (titleKey == null) {
            ProjectUtil.$$$reportNull$$$0(7);
        }
        Window window = ProjectUtil.getActiveFrameOrWelcomeScreen();
        Icon icon = Messages.getWarningIcon();
        String title = IdeBundle.message((String)titleKey, (Object[])new Object[0]);
        int answer = window == null ? Messages.showYesNoDialog((String)message, (String)title, (Icon)icon) : Messages.showYesNoDialog((Component)window, (String)message, (String)title, (Icon)icon);
        return answer == 0;
    }

    public static Window getActiveFrameOrWelcomeScreen() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window != null) {
            return window;
        }
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof IdeFrame) || !frame.isVisible()) continue;
            return frame;
        }
        return null;
    }

    public static boolean isRemotePath(@NotNull String path) {
        if (path == null) {
            ProjectUtil.$$$reportNull$$$0(8);
        }
        return path.contains("://") || path.contains("\\\\");
    }

    @Nullable
    public static Project findAndFocusExistingProjectForPath(@NotNull String path) {
        Project[] openProjects;
        if (path == null) {
            ProjectUtil.$$$reportNull$$$0(9);
        }
        for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            if (project.isDefault() || !ProjectUtil.isSameProject(path, project)) continue;
            ProjectUtil.focusProjectWindow(project, false);
            return project;
        }
        return null;
    }

    public static int confirmOpenNewProject(boolean isNewProject) {
        int confirmOpenNewProject;
        GeneralSettings settings = GeneralSettings.getInstance();
        int n = confirmOpenNewProject = ApplicationManager.getApplication().isUnitTestMode() ? 0 : settings.getConfirmOpenNewProject();
        if (confirmOpenNewProject == -1) {
            if (isNewProject) {
                int exitCode = Messages.showYesNoDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.existing.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.new.frame", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption());
                return exitCode == 0 ? 1 : 0;
            }
            int exitCode = Messages.showYesNoCancelDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.existing.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.new.frame", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption());
            return exitCode == 0 ? 1 : (exitCode == 1 ? 0 : 2);
        }
        return confirmOpenNewProject;
    }

    public static int confirmOpenOrAttachProject() {
        String mode = PropertiesComponent.getInstance().getValue(MODE_PROPERTY);
        int exitCode = Messages.showDialog((String)IdeBundle.message((String)"prompt.open.project.or.attach", (Object[])new Object[0]), (String)"Open Project", (String[])new String[]{"&This Window", "New &Window", "&Attach", CommonBundle.getCancelButtonText()}, (int)(MODE_NEW.equals(mode) ? 1 : (MODE_REPLACE.equals(mode) ? 0 : (MODE_ATTACH.equals(mode) ? 2 : 0))), (Icon)Messages.getQuestionIcon());
        return exitCode == 0 ? 1 : (exitCode == 1 ? 0 : (exitCode == 2 ? 2 : -1));
    }

    public static boolean isSameProject(@Nullable String projectFilePath, @NotNull Project project) {
        if (project == null) {
            ProjectUtil.$$$reportNull$$$0(10);
        }
        if (projectFilePath == null) {
            return false;
        }
        IProjectStore projectStore = ProjectKt.getStateStore(project);
        String existingBaseDirPath = projectStore.getProjectBasePath();
        File projectFile = new File(projectFilePath);
        if (projectFile.isDirectory()) {
            return FileUtil.pathsEqual((String)projectFilePath, (String)existingBaseDirPath);
        }
        if (projectStore.getStorageScheme() == StorageScheme.DEFAULT) {
            return FileUtil.pathsEqual((String)projectFilePath, (String)projectStore.getProjectFilePath());
        }
        File parent = projectFile.getParentFile();
        if (parent.getName().equals(".idea")) {
            return (parent = parent.getParentFile()) != null && FileUtil.pathsEqual((String)parent.getPath(), (String)existingBaseDirPath);
        }
        return FileUtil.pathsEqual((String)parent.getPath(), (String)existingBaseDirPath) && "ipr".equals(FileUtilRt.getExtension((String)projectFile.getName()));
    }

    public static void focusProjectWindow(Project p, boolean executeIfAppInactive) {
        JFrame f = WindowManager.getInstance().getFrame(p);
        if (f != null) {
            if (executeIfAppInactive) {
                AppIcon.getInstance().requestFocus((IdeFrame)WindowManager.getInstance().getFrame(p));
                f.toFront();
            } else {
                IdeFocusManager.getInstance((Project)p).requestFocus((Component)f, true);
            }
        }
    }

    public static String getBaseDir() {
        String defaultDirectory = GeneralSettings.getInstance().getDefaultProjectDirectory();
        if (StringUtil.isNotEmpty((String)defaultDirectory)) {
            return defaultDirectory.replace('/', File.separatorChar);
        }
        String lastProjectLocation = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (lastProjectLocation != null) {
            return lastProjectLocation.replace('/', File.separatorChar);
        }
        String userHome = SystemProperties.getUserHome();
        String productName = ApplicationNamesInfo.getInstance().getLowercaseProductName();
        if (PlatformUtils.isCLion() || PlatformUtils.isAppCode()) {
            productName = ApplicationNamesInfo.getInstance().getProductName();
        }
        return userHome.replace('/', File.separatorChar) + File.separator + productName + "Projects";
    }

    @Nullable
    public static Project tryOpenFileList(@Nullable Project project, @NotNull List<? extends File> list2, String location) {
        if (list2 == null) {
            ProjectUtil.$$$reportNull$$$0(11);
        }
        Project result2 = null;
        for (File file2 : list2) {
            result2 = ProjectUtil.openOrImport(file2.getAbsolutePath(), project, true);
            if (result2 == null) continue;
            LOG.debug(location + ": load project from ", new Object[]{file2});
            return result2;
        }
        for (File file3 : list2) {
            Project opened;
            VirtualFile virtualFile;
            if (!file3.exists()) continue;
            LOG.debug(location + ": open file ", new Object[]{file3});
            String path = file3.getAbsolutePath();
            if (project != null) {
                OpenFileAction.openFile(path, project);
                result2 = project;
                continue;
            }
            CommandLineProjectOpenProcessor processor2 = CommandLineProjectOpenProcessor.getInstanceIfExists();
            if (processor2 == null || (virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path)) == null || !virtualFile.isValid() || (opened = processor2.openProjectAndFile(virtualFile, -1, false)) == null || result2 != null) continue;
            result2 = opened;
        }
        return result2;
    }

    public static boolean isValidProjectPath(VirtualFile file2) {
        if (file2.isDirectory()) {
            VirtualFile child2 = file2.findChild(".idea");
            return child2 != null && child2.isValid();
        }
        return StringUtil.endsWith((CharSequence)file2.getNameSequence(), (CharSequence)".ipr");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msgKey";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleKey";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/impl/ProjectUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "closeAndDispose";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "openOrImport";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "openProject";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "confirmLoadingFromRemotePath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showYesNoDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isRemotePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndFocusExistingProjectForPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isSameProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "tryOpenFileList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

