/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable;
import com.intellij.ide.fileTemplates.impl.FileTemplateTab;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBList;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

abstract class FileTemplateTabAsList
extends FileTemplateTab {
    private final JList<FileTemplate> myList = new JBList();
    private MyListModel myModel;

    FileTemplateTabAsList(String title) {
        super(title);
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer((ListCellRenderer<FileTemplate>)SimpleListCellRenderer.create((label2, value, index) -> {
            boolean internalTemplate = AllFileTemplatesConfigurable.isInternalTemplate(value.getName(), this.getTitle());
            label2.setIcon(FileTemplateUtil.getIcon(value));
            label2.setText(value.getName());
            label2.setFont(label2.getFont().deriveFont(internalTemplate ? 1 : 0));
            if (!value.isDefault() && this.myList.getSelectedIndex() != index) {
                label2.setForeground(MODIFIED_FOREGROUND);
            }
        }));
        this.myList.addListSelectionListener(__ -> this.onTemplateSelected());
        new ListSpeedSearch<FileTemplate>(this.myList, FileTemplate::getName);
    }

    @Override
    public void removeSelected() {
        FileTemplate selectedTemplate = this.getSelectedTemplate();
        if (selectedTemplate == null) {
            return;
        }
        DefaultListModel model2 = (DefaultListModel)this.myList.getModel();
        int selectedIndex = this.myList.getSelectedIndex();
        model2.remove(selectedIndex);
        if (!model2.isEmpty()) {
            this.myList.setSelectedIndex(Math.min(selectedIndex, model2.size() - 1));
        }
        this.onTemplateSelected();
    }

    @Override
    protected void initSelection(FileTemplate selection) {
        this.myModel = new MyListModel();
        this.myList.setModel(this.myModel);
        for (FileTemplate template : this.myTemplates) {
            this.myModel.addElement(template);
        }
        if (selection != null) {
            this.selectTemplate(selection);
        } else if (this.myList.getModel().getSize() > 0) {
            this.myList.setSelectedIndex(0);
        }
    }

    @Override
    public void fireDataChanged() {
        this.myModel.fireListDataChanged();
    }

    @Override
    @NotNull
    public FileTemplate[] getTemplates() {
        int size = this.myModel.getSize();
        ArrayList templates = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            templates.add(this.myModel.getElementAt(i));
        }
        FileTemplate[] fileTemplateArray = templates.toArray(FileTemplate.EMPTY_ARRAY);
        if (fileTemplateArray == null) {
            FileTemplateTabAsList.$$$reportNull$$$0(0);
        }
        return fileTemplateArray;
    }

    @Override
    public void addTemplate(FileTemplate newTemplate) {
        this.myModel.addElement(newTemplate);
    }

    @Override
    public void selectTemplate(FileTemplate template) {
        this.myList.setSelectedValue(template, true);
    }

    @Override
    public FileTemplate getSelectedTemplate() {
        return this.myList.getSelectedValue();
    }

    @Override
    public JComponent getComponent() {
        return this.myList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateTabAsList", "getTemplates"));
    }

    private static class MyListModel
    extends DefaultListModel<FileTemplate> {
        private MyListModel() {
        }

        void fireListDataChanged() {
            int size = this.getSize();
            if (size > 0) {
                this.fireContentsChanged(this, 0, size - 1);
            }
        }
    }
}

