/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Block;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.ProbablyIncreasingLowerboundAlgorithm;
import com.intellij.formatting.WhiteSpace;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeBlockWrapper
extends AbstractBlockWrapper {
    private List<AbstractBlockWrapper> myChildren;
    private ProbablyIncreasingLowerboundAlgorithm<AbstractBlockWrapper> myPrevBlockCalculator;

    public CompositeBlockWrapper(Block block, @NotNull WhiteSpace whiteSpaceBefore, @Nullable CompositeBlockWrapper parent) {
        if (whiteSpaceBefore == null) {
            CompositeBlockWrapper.$$$reportNull$$$0(0);
        }
        super(block, whiteSpaceBefore, parent, block.getTextRange());
        this.myPrevBlockCalculator = null;
    }

    public List<AbstractBlockWrapper> getChildren() {
        return this.myChildren;
    }

    public void setChildren(List<AbstractBlockWrapper> children2) {
        this.myChildren = children2;
        if (this.myPrevBlockCalculator != null) {
            this.myPrevBlockCalculator.setBlocksList(this.myChildren);
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.myChildren != null) {
            for (AbstractBlockWrapper wrapper2 : this.myChildren) {
                assert (wrapper2 != this);
                wrapper2.reset();
            }
        }
    }

    @Override
    protected boolean indentAlreadyUsedBefore(AbstractBlockWrapper child2) {
        for (AbstractBlockWrapper childBefore : this.myChildren) {
            if (childBefore == child2) {
                return false;
            }
            if (!childBefore.getWhiteSpace().containsLineFeeds()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IndentData getNumberOfSymbolsBeforeBlock() {
        if (this.myChildren == null || this.myChildren.isEmpty()) {
            return new IndentData(0, 0);
        }
        return this.myChildren.get(0).getNumberOfSymbolsBeforeBlock();
    }

    @Override
    protected LeafBlockWrapper getPreviousBlock() {
        if (this.myChildren == null || this.myChildren.isEmpty()) {
            return null;
        }
        return this.myChildren.get(0).getPreviousBlock();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myChildren = null;
        this.myPrevBlockCalculator = null;
    }

    @Nullable
    public AbstractBlockWrapper getPrevIndentedSibling(@NotNull AbstractBlockWrapper current) {
        if (current == null) {
            CompositeBlockWrapper.$$$reportNull$$$0(1);
        }
        if (this.myChildren.size() > 10) {
            return this.getPrevIndentedSiblingFast(current);
        }
        AbstractBlockWrapper candidate = null;
        for (AbstractBlockWrapper child2 : this.myChildren) {
            if (child2.getStartOffset() >= current.getStartOffset()) {
                return candidate;
            }
            if (!child2.getWhiteSpace().containsLineFeeds()) continue;
            candidate = child2;
        }
        return candidate;
    }

    @Nullable
    private AbstractBlockWrapper getPrevIndentedSiblingFast(@NotNull AbstractBlockWrapper current) {
        if (current == null) {
            CompositeBlockWrapper.$$$reportNull$$$0(2);
        }
        if (this.myPrevBlockCalculator == null) {
            this.myPrevBlockCalculator = new ProbablyIncreasingLowerboundAlgorithm<AbstractBlockWrapper>(this.myChildren);
        }
        List<AbstractBlockWrapper> leftBlocks = this.myPrevBlockCalculator.getLeftSubList(current);
        for (int i = leftBlocks.size() - 1; i >= 0; --i) {
            AbstractBlockWrapper child2 = leftBlocks.get(i);
            if (!child2.getWhiteSpace().containsLineFeeds()) continue;
            return child2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceBefore";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/CompositeBlockWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrevIndentedSibling";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrevIndentedSiblingFast";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

