/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.navigator;

import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.classstore.InstanceField;
import com.intellij.diagnostic.hprof.classstore.StaticField;
import com.intellij.diagnostic.hprof.navigator.ObjectNavigator;
import com.intellij.diagnostic.hprof.navigator.RootReason;
import com.intellij.diagnostic.hprof.parser.Type;
import gnu.trove.TLongArrayList;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TLongObjectIterator;
import java.nio.ByteBuffer;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 .2\u00020\u0001:\u0001.B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u001e\u001a\u00020\u000eH\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0018\u0010!\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010+\u001a\u00020\u0018H\u0002J\f\u0010,\u001a\u00020\u000e*\u00020\u0006H\u0002J\f\u0010-\u001a\u00020\u000e*\u00020\u0006H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigatorOnAuxFiles;", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;", "roots", "Lgnu/trove/TLongObjectHashMap;", "Lcom/intellij/diagnostic/hprof/navigator/RootReason;", "auxOffsets", "Ljava/nio/ByteBuffer;", "aux", "classStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "instanceCount", "", "(Lgnu/trove/TLongObjectHashMap;Ljava/nio/ByteBuffer;Ljava/nio/ByteBuffer;Lcom/intellij/diagnostic/hprof/classstore/ClassStore;J)V", "arraySize", "", "currentClass", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "currentObjectId", "id", "getId", "()J", "references", "Lgnu/trove/TLongArrayList;", "copyReferencesTo", "", "outReferences", "createRootsIterator", "", "getClass", "getClassForObjectId", "getObjectSize", "getReferencesCopy", "getRootReasonForObjectId", "goTo", "referenceResolution", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator$ReferenceResolution;", "isNull", "", "preloadClass", "classId", "preloadInstance", "classDefinition", "preloadObjectArray", "preloadPrimitiveArray", "readId", "readNonNegativeLEB128Int", "Companion", "intellij.platform.ide.impl"})
public final class ObjectNavigatorOnAuxFiles
extends ObjectNavigator {
    private long currentObjectId;
    private int arraySize;
    private ClassDefinition currentClass;
    private final TLongArrayList references;
    private final TLongObjectHashMap<RootReason> roots;
    private final ByteBuffer auxOffsets;
    private final ByteBuffer aux;
    private static final int REFERENCE_SIZE = 4;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ClassDefinition getClass() {
        ClassDefinition classDefinition = this.currentClass;
        if (classDefinition == null) {
            Intrinsics.throwNpe();
        }
        return classDefinition;
    }

    @Override
    @NotNull
    public ClassDefinition getClassForObjectId(long id) {
        this.auxOffsets.position((int)(id * (long)4));
        this.aux.position(this.auxOffsets.getInt());
        int classId = this.readId(this.aux);
        return classId == 0 ? this.getClassStore().getClassClass() : this.getClassStore().get(classId);
    }

    @Override
    public long getId() {
        return this.currentObjectId;
    }

    @Override
    @NotNull
    public Iterator<Long> createRootsIterator() {
        return new Iterator<Long>(this){
            private final TLongObjectIterator<RootReason> internalIterator;
            final /* synthetic */ ObjectNavigatorOnAuxFiles this$0;

            public final TLongObjectIterator<RootReason> getInternalIterator() {
                return this.internalIterator;
            }

            public boolean hasNext() {
                return this.internalIterator.hasNext();
            }

            @NotNull
            public Long next() {
                this.internalIterator.advance();
                return this.internalIterator.key();
            }
            {
                this.this$0 = $outer;
                this.internalIterator = ObjectNavigatorOnAuxFiles.access$getRoots$p($outer).iterator();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TLongArrayList getReferencesCopy() {
        TLongArrayList result2 = new TLongArrayList();
        int n = 0;
        int n2 = this.references.size();
        while (n < n2) {
            void i;
            result2.add(this.references.get((int)i));
            ++i;
        }
        return result2;
    }

    @Override
    public boolean isNull() {
        return this.getId() == 0L;
    }

    @Override
    public void goTo(long id, @NotNull ObjectNavigator.ReferenceResolution referenceResolution) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)referenceResolution), (String)"referenceResolution");
        this.auxOffsets.position((int)(id * (long)4));
        this.aux.position(this.auxOffsets.getInt());
        this.currentObjectId = id;
        this.references.resetQuick();
        if (id == 0L) {
            this.currentClass = null;
            return;
        }
        int classId = this.readId(this.aux);
        ClassDefinition classDefinition = null;
        classDefinition = classId == 0 ? this.getClassStore().getClassClass() : this.getClassStore().get(classId);
        this.currentClass = classDefinition;
        if (classId == 0) {
            this.preloadClass((int)id, referenceResolution);
            return;
        }
        if (classDefinition.isPrimitiveArray()) {
            this.preloadPrimitiveArray();
            return;
        }
        if (classDefinition.isArray()) {
            this.preloadObjectArray(referenceResolution);
            return;
        }
        this.preloadInstance(classDefinition, referenceResolution);
    }

    private final void preloadPrimitiveArray() {
        this.arraySize = this.readNonNegativeLEB128Int(this.aux);
    }

    /*
     * WARNING - void declaration
     */
    private final void preloadClass(int classId, ObjectNavigator.ReferenceResolution referenceResolution) {
        this.arraySize = 0;
        if (referenceResolution != ObjectNavigator.ReferenceResolution.NO_REFERENCES) {
            StaticField[] $this$forEach$iv;
            ClassDefinition classDefinition = this.getClassStore().get(classId);
            long[] lArray = classDefinition.getConstantFields();
            TLongArrayList tLongArrayList = this.references;
            boolean $i$f$forEach = false;
            void var7_9 = $this$forEach$iv;
            int n = ((void)var7_9).length;
            for (int i = 0; i < n; ++i) {
                void element$iv;
                void p1 = element$iv = var7_9[i];
                boolean bl = false;
                tLongArrayList.add((long)p1);
            }
            $this$forEach$iv = classDefinition.getStaticFields();
            boolean $i$f$forEach2 = false;
            StaticField[] staticFieldArray = $this$forEach$iv;
            int n2 = staticFieldArray.length;
            for (n = 0; n < n2; ++n) {
                StaticField element$iv;
                StaticField it = element$iv = staticFieldArray[n];
                boolean bl = false;
                this.references.add(it.getObjectId());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void preloadObjectArray(ObjectNavigator.ReferenceResolution referenceResolution) {
        int nullElementsCount = this.readNonNegativeLEB128Int(this.aux);
        int nonNullElementsCount = this.readNonNegativeLEB128Int(this.aux);
        this.arraySize = nullElementsCount + nonNullElementsCount;
        if (referenceResolution != ObjectNavigator.ReferenceResolution.NO_REFERENCES) {
            int n = 0;
            int n2 = nonNullElementsCount;
            while (n < n2) {
                void i;
                this.references.add((long)this.readId(this.aux));
                ++i;
            }
        }
    }

    private final void preloadInstance(ClassDefinition classDefinition, ObjectNavigator.ReferenceResolution referenceResolution) {
        this.arraySize = 0;
        if (referenceResolution == ObjectNavigator.ReferenceResolution.NO_REFERENCES) {
            return;
        }
        ClassDefinition c2 = classDefinition;
        boolean isSoftOrWeakReference = false;
        boolean includeSoftWeakReferences = referenceResolution == ObjectNavigator.ReferenceResolution.ALL_REFERENCES;
        while (true) {
            InstanceField[] fields;
            isSoftOrWeakReference = isSoftOrWeakReference || this.getClassStore().isSoftOrWeakReferenceClass(c2);
            InstanceField[] $this$forEach$iv = fields = c2.getRefInstanceFields();
            boolean $i$f$forEach = false;
            InstanceField[] instanceFieldArray = $this$forEach$iv;
            int n = instanceFieldArray.length;
            for (int i = 0; i < n; ++i) {
                InstanceField element$iv;
                InstanceField it = element$iv = instanceFieldArray[i];
                boolean bl = false;
                int reference2 = this.readId(this.aux);
                if (!isSoftOrWeakReference || Intrinsics.areEqual((Object)it.getName(), (Object)"referent") ^ true || includeSoftWeakReferences) {
                    this.references.add((long)reference2);
                    continue;
                }
                this.references.add(0L);
            }
            long superClassId = c2.getSuperClassId();
            if (superClassId == 0L) break;
            c2 = this.getClassStore().get(superClassId);
        }
    }

    @Override
    public int getObjectSize() {
        ClassDefinition classDefinition = this.currentClass;
        if (classDefinition == null) {
            return 4;
        }
        ClassDefinition localClass = classDefinition;
        return localClass.isPrimitiveArray() ? localClass.getInstanceSize() + Type.Companion.getType(localClass.getName()).getSize() * this.arraySize : (localClass.isArray() ? localClass.getInstanceSize() + 4 * this.arraySize : localClass.getInstanceSize());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void copyReferencesTo(@NotNull TLongArrayList outReferences) {
        Intrinsics.checkParameterIsNotNull((Object)outReferences, (String)"outReferences");
        outReferences.resetQuick();
        outReferences.ensureCapacity(this.references.size());
        int n = 0;
        int n2 = this.references.size();
        while (n < n2) {
            void i;
            outReferences.add(this.references.get((int)i));
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public RootReason getRootReasonForObjectId(long id) {
        void rootReason;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = (RootReason)this.roots.get(id);
        if ((RootReason)rootReason.element != null) {
            return (RootReason)rootReason.element;
        }
        this.getClassStore().forEachClass((Function1<? super ClassDefinition, Unit>)((Function1)new Function1<ClassDefinition, Unit>(id, (Ref.ObjectRef)rootReason){
            final /* synthetic */ long $id;
            final /* synthetic */ Ref.ObjectRef $rootReason;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ClassDefinition classDefinition) {
                int index;
                block7: {
                    int n;
                    StaticField staticField;
                    int n2;
                    boolean $i$f$firstOrNull;
                    StaticField[] $this$firstOrNull$iv;
                    block6: {
                        Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
                        if (classDefinition.getId() == this.$id) {
                            this.$rootReason.element = RootReason.Companion.createClassDefinitionReason(classDefinition);
                        }
                        $this$firstOrNull$iv = classDefinition.getStaticFields();
                        $i$f$firstOrNull = false;
                        StaticField[] staticFieldArray = $this$firstOrNull$iv;
                        int n3 = staticFieldArray.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            StaticField element$iv;
                            StaticField it = element$iv = staticFieldArray[n2];
                            boolean bl = false;
                            if (!(it.getObjectId() == this.$id)) continue;
                            staticField = element$iv;
                            break block6;
                        }
                        staticField = null;
                    }
                    if (staticField != null) {
                        $this$firstOrNull$iv = staticField;
                        $i$f$firstOrNull = false;
                        boolean bl = false;
                        StaticField[] it = $this$firstOrNull$iv;
                        boolean bl2 = false;
                        this.$rootReason.element = RootReason.Companion.createStaticFieldReferenceReason(classDefinition, it.getName());
                    }
                    long[] $this$indexOfFirst$iv = classDefinition.getConstantFields();
                    boolean $i$f$indexOfFirst = false;
                    int it = 0;
                    n2 = $this$indexOfFirst$iv.length;
                    while (it < n2) {
                        void index$iv;
                        long it2 = $this$indexOfFirst$iv[index$iv];
                        boolean bl = false;
                        if (it2 == this.$id) {
                            n = index$iv;
                            break block7;
                        }
                        ++index$iv;
                    }
                    n = index = -1;
                }
                if (index != -1) {
                    this.$rootReason.element = RootReason.Companion.createConstantReferenceReason(classDefinition, index);
                }
            }
            {
                this.$id = l;
                this.$rootReason = objectRef;
                super(1);
            }
        }));
        return (RootReason)rootReason.element;
    }

    private final int readId(@NotNull ByteBuffer $this$readId) {
        return this.readNonNegativeLEB128Int($this$readId);
    }

    private final int readNonNegativeLEB128Int(@NotNull ByteBuffer $this$readNonNegativeLEB128Int) {
        int v = 0;
        int shift = 0;
        while (true) {
            byte b;
            byte by = b = $this$readNonNegativeLEB128Int.get();
            int n = 127;
            int n2 = v;
            boolean bl = false;
            byte by2 = (byte)(by & n);
            v = n2 | by2 << shift;
            if (b >= 0) break;
            shift += 7;
        }
        return v;
    }

    public ObjectNavigatorOnAuxFiles(@NotNull TLongObjectHashMap<RootReason> roots, @NotNull ByteBuffer auxOffsets, @NotNull ByteBuffer aux, @NotNull ClassStore classStore, long instanceCount) {
        Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
        Intrinsics.checkParameterIsNotNull((Object)auxOffsets, (String)"auxOffsets");
        Intrinsics.checkParameterIsNotNull((Object)aux, (String)"aux");
        Intrinsics.checkParameterIsNotNull((Object)classStore, (String)"classStore");
        super(classStore, instanceCount);
        this.roots = roots;
        this.auxOffsets = auxOffsets;
        this.aux = aux;
        this.references = new TLongArrayList();
    }

    public static final /* synthetic */ TLongObjectHashMap access$getRoots$p(ObjectNavigatorOnAuxFiles $this) {
        return $this.roots;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigatorOnAuxFiles$Companion;", "", "()V", "REFERENCE_SIZE", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

