/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionElementsMergerBase
extends InspectionElementsMerger {
    protected Element writeOldSettings(@NotNull String sourceToolName) throws WriteExternalException {
        if (sourceToolName == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(0);
        }
        Element sourceElement = new Element("inspection_tool");
        sourceElement.setAttribute("class", sourceToolName);
        sourceElement.setAttribute("enabled", String.valueOf(this.isEnabledByDefault(sourceToolName)));
        sourceElement.setAttribute("level", this.getDefaultSeverityLevel(sourceToolName));
        sourceElement.setAttribute("enabled_by_default", String.valueOf(this.isEnabledByDefault(sourceToolName)));
        return sourceElement;
    }

    private String getDefaultSeverityLevel(@NotNull String sourceToolName) {
        if (sourceToolName == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(1);
        }
        return HighlightSeverity.WARNING.getName();
    }

    protected boolean isEnabledByDefault(@NotNull String sourceToolName) {
        if (sourceToolName == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(2);
        }
        return true;
    }

    @NotNull
    static String getMergedMarkerName(@NotNull String toolName) {
        if (toolName == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(3);
        }
        String string = toolName + "Merged";
        if (string == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    boolean markSettingsMerged(@NotNull Map<String, Element> inspectionsSettings) {
        Element merge;
        if (inspectionsSettings == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(5);
        }
        if ((merge = this.merge(inspectionsSettings, true)) != null) {
            Element defaultElement = this.merge(Collections.emptyMap(), true);
            return !JDOMUtil.areElementsEqual((Element)merge, (Element)defaultElement);
        }
        return false;
    }

    protected boolean areSettingsMerged(@NotNull Map<String, Element> inspectionsSettings, @NotNull Element inspectionElement) {
        Element merge;
        if (inspectionsSettings == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(6);
        }
        if (inspectionElement == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(7);
        }
        return (merge = this.merge(inspectionsSettings, true)) != null && JDOMUtil.areElementsEqual((Element)merge, (Element)inspectionElement);
    }

    protected Element merge(@NotNull Map<String, Element> inspectionElements) {
        if (inspectionElements == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(8);
        }
        return this.merge(inspectionElements, false);
    }

    protected Element merge(@NotNull Map<String, Element> inspectionElements, boolean includeDefaults) {
        if (inspectionElements == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(9);
        }
        LinkedHashMap<String, Element> scopes = new LinkedHashMap<String, Element>();
        LinkedHashMap<String, Set<String>> mentionedTools = new LinkedHashMap<String, Set<String>>();
        boolean enabled = false;
        String level = null;
        Element toolElement = new Element("inspection_tool");
        for (String sourceToolName : this.getSourceToolNames()) {
            Element sourceElement = this.getSourceElement(inspectionElements, sourceToolName);
            if (sourceElement == null) {
                if (includeDefaults) {
                    try {
                        sourceElement = this.writeOldSettings(sourceToolName);
                    }
                    catch (WriteExternalException writeExternalException) {}
                } else {
                    enabled |= this.isEnabledByDefault(sourceToolName);
                    if (level == null) {
                        level = this.getDefaultSeverityLevel(sourceToolName);
                    }
                }
            }
            if (sourceElement == null) continue;
            this.collectContent(sourceToolName, sourceElement, toolElement, scopes, mentionedTools);
            enabled |= Boolean.parseBoolean(sourceElement.getAttributeValue("enabled"));
            if (level != null) continue;
            level = InspectionElementsMergerBase.getLevel(sourceElement);
        }
        if (this.writeMergedContent(toolElement)) {
            toolElement.setAttribute("class", this.getMergedToolName());
            toolElement.setAttribute("enabled", String.valueOf(enabled));
            if (level != null) {
                toolElement.setAttribute("level", level);
            }
            toolElement.setAttribute("enabled_by_default", String.valueOf(enabled));
            for (String scopeName : scopes.keySet()) {
                Element scopeEl = scopes.get(scopeName);
                Set<String> toolsWithScope = mentionedTools.get(scopeName);
                for (String sourceToolName : this.getSourceToolNames()) {
                    if (toolsWithScope.contains(sourceToolName)) continue;
                    this.copyDefaultSettings(scopeEl, inspectionElements, sourceToolName);
                }
                toolElement.addContent(scopeEl);
            }
            return toolElement;
        }
        return null;
    }

    protected boolean writeMergedContent(@NotNull Element toolElement) {
        if (toolElement == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(10);
        }
        return !toolElement.getChildren().isEmpty();
    }

    protected Element getSourceElement(@NotNull Map<String, Element> inspectionElements, @NotNull String sourceToolName) {
        if (inspectionElements == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(11);
        }
        if (sourceToolName == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(12);
        }
        return inspectionElements.get(sourceToolName);
    }

    private void copyDefaultSettings(@NotNull Element targetElement, @NotNull Map<String, Element> inspectionElements, @NotNull String sourceToolName) {
        Element oldElement;
        if (targetElement == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(13);
        }
        if (inspectionElements == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(14);
        }
        if (sourceToolName == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(15);
        }
        if ((oldElement = this.getSourceElement(inspectionElements, sourceToolName)) != null) {
            Element defaultElement = this.transformElement(sourceToolName, oldElement, targetElement);
            oldElement.getChildren().stream().filter(child2 -> !"scope".equals(child2.getName())).forEach(child2 -> defaultElement.addContent(child2.clone()));
        }
    }

    private static String getLevel(Element element) {
        return element != null ? element.getAttributeValue("level") : HighlightSeverity.WARNING.getName();
    }

    private void collectContent(@NotNull String sourceToolName, @NotNull Element sourceElement, @NotNull Element toolElement, @NotNull Map<String, Element> scopes, @NotNull Map<String, Set<String>> mentionedTools) {
        if (sourceToolName == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(16);
        }
        if (sourceElement == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(17);
        }
        if (toolElement == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(18);
        }
        if (scopes == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(19);
        }
        if (mentionedTools == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(20);
        }
        Element wrapElement = this.transformElement(sourceToolName, sourceElement, toolElement);
        for (Element element : sourceElement.getChildren()) {
            if ("scope".equals(element.getName())) {
                String scopeName = element.getAttributeValue("name");
                if (scopeName == null) continue;
                mentionedTools.computeIfAbsent(scopeName, s -> new HashSet()).add(sourceToolName);
                this.copyScopeContent(sourceToolName, element, scopes.computeIfAbsent(scopeName, key -> {
                    Element scopeElement = element.clone();
                    scopeElement.removeContent();
                    return scopeElement;
                }));
                continue;
            }
            wrapElement.addContent(element.clone());
        }
    }

    private void copyScopeContent(@NotNull String sourceToolName, @NotNull Element element, @NotNull Element scopeElement) {
        if (sourceToolName == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(21);
        }
        if (element == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(22);
        }
        if (scopeElement == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(23);
        }
        Element wrappedScope = this.transformElement(sourceToolName, element, scopeElement);
        for (Element scopeEl : element.getChildren()) {
            wrappedScope.addContent(scopeEl.clone());
        }
    }

    protected Element transformElement(@NotNull String sourceToolName, @NotNull Element sourceElement, @NotNull Element toolElement) {
        if (sourceToolName == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(24);
        }
        if (sourceElement == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(25);
        }
        if (toolElement == null) {
            InspectionElementsMergerBase.$$$reportNull$$$0(26);
        }
        return toolElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceToolName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionElementsMergerBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionElement";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionElements";
                break;
            }
            case 10: 
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mentionedTools";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionElementsMergerBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedMarkerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeOldSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSeverityLevel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledByDefault";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMergedMarkerName";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markSettingsMerged";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "areSettingsMerged";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeMergedContent";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSourceElement";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyDefaultSettings";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectContent";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "copyScopeContent";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "transformElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

