/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.google.common.collect.Iterables;
import com.intellij.dvcs.actions.DvcsCompareWithBranchAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCompareWithBranchAction
extends DvcsCompareWithBranchAction<HgRepository> {
    protected boolean noBranchesToCompare(@NotNull HgRepository repository) {
        Map<String, LinkedHashSet<Hash>> branches;
        if (repository == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(0);
        }
        if ((branches = repository.getBranches()).size() > 1) {
            return false;
        }
        Hash currentRevisionHash = HgCompareWithBranchAction.getCurrentHash(repository);
        List<HgNameWithHashInfo> other_bookmarks = HgCompareWithBranchAction.getOtherBookmarks(repository, currentRevisionHash);
        if (!other_bookmarks.isEmpty()) {
            return false;
        }
        return currentRevisionHash.equals(HgCompareWithBranchAction.getHeavyBranchMainHash(repository, repository.getCurrentBranch()));
    }

    @NotNull
    private static Hash getCurrentHash(@NotNull HgRepository repository) {
        if (repository == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(1);
        }
        String currentRevision = repository.getCurrentRevision();
        assert (currentRevision != null) : "Compare With Branch couldn't be performed for newly created repository";
        Hash hash = HashImpl.build((String)repository.getCurrentRevision());
        if (hash == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(2);
        }
        return hash;
    }

    @NotNull
    private static List<HgNameWithHashInfo> getOtherBookmarks(@NotNull HgRepository repository, @NotNull Hash currentRevisionHash) {
        if (repository == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(3);
        }
        if (currentRevisionHash == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(4);
        }
        List list = ContainerUtil.filter(repository.getBookmarks(), info -> !info.getHash().equals(currentRevisionHash));
        if (list == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    private static Hash findBookmarkHashByName(@NotNull HgRepository repository, @NotNull String bookmarkName) {
        HgNameWithHashInfo bookmarkInfo;
        if (repository == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(6);
        }
        if (bookmarkName == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(7);
        }
        return (bookmarkInfo = (HgNameWithHashInfo)ContainerUtil.find(repository.getBookmarks(), info -> info.getName().equals(bookmarkName))) != null ? bookmarkInfo.getHash() : null;
    }

    @Nullable
    private static Hash getHeavyBranchMainHash(@NotNull HgRepository repository, @NotNull String branchName) {
        LinkedHashSet<Hash> branchHashes;
        if (repository == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(8);
        }
        if (branchName == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(9);
        }
        return (branchHashes = repository.getBranches().get(branchName)) != null ? (Hash)ObjectUtils.assertNotNull((Object)Iterables.getLast(branchHashes)) : null;
    }

    @Nullable
    private static Hash detectActiveHashByName(@NotNull HgRepository repository, @NotNull String branchToCompare) {
        Hash refHashToCompare;
        if (repository == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(10);
        }
        if (branchToCompare == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(11);
        }
        return (refHashToCompare = HgCompareWithBranchAction.getHeavyBranchMainHash(repository, branchToCompare)) != null ? refHashToCompare : HgCompareWithBranchAction.findBookmarkHashByName(repository, branchToCompare);
    }

    @NotNull
    protected List<String> getBranchNamesExceptCurrent(@NotNull HgRepository repository) {
        if (repository == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(12);
        }
        ArrayList<String> namesToCompare = new ArrayList<String>(repository.getBranches().keySet());
        String currentBranchName = repository.getCurrentBranchName();
        assert (currentBranchName != null);
        Hash currentHash = HgCompareWithBranchAction.getCurrentHash(repository);
        if (currentHash.equals(HgCompareWithBranchAction.getHeavyBranchMainHash(repository, currentBranchName))) {
            namesToCompare.remove(currentBranchName);
        }
        namesToCompare.addAll(HgUtil.getNamesWithoutHashes(HgCompareWithBranchAction.getOtherBookmarks(repository, currentHash)));
        ArrayList<String> arrayList = namesToCompare;
        if (arrayList == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    protected HgRepositoryManager getRepositoryManager(@NotNull Project project) {
        if (project == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(14);
        }
        HgRepositoryManager hgRepositoryManager = HgUtil.getRepositoryManager(project);
        if (hgRepositoryManager == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(15);
        }
        return hgRepositoryManager;
    }

    @NotNull
    protected Collection<Change> getDiffChanges(@NotNull Project project, @NotNull VirtualFile file, @NotNull String branchToCompare) throws VcsException {
        HgRepository repository;
        if (project == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(16);
        }
        if (file == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(17);
        }
        if (branchToCompare == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(18);
        }
        if ((repository = (HgRepository)this.getRepositoryManager(project).getRepositoryForFile(file)) == null) {
            throw new VcsException("Couldn't find repository for " + file.getName());
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        VirtualFile repositoryRoot = repository.getRoot();
        HgFile hgFile = new HgFile(repositoryRoot, filePath);
        HgRevisionNumber compareWithRevisionNumber = HgCompareWithBranchAction.getBranchRevisionNumber(repository, branchToCompare);
        List changes = HgUtil.getDiff(project, repositoryRoot, filePath, compareWithRevisionNumber, null);
        if (changes.isEmpty() && !HgCompareWithBranchAction.existInBranch(repository, filePath, compareWithRevisionNumber)) {
            throw new VcsException(HgCompareWithBranchAction.fileDoesntExistInBranchError((VirtualFile)file, (String)branchToCompare));
        }
        List list = changes.isEmpty() && !filePath.isDirectory() ? VcsDiffUtil.createChangesWithCurrentContentForFile((FilePath)filePath, (ContentRevision)HgContentRevision.create(project, hgFile, compareWithRevisionNumber)) : changes;
        if (list == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public static HgRevisionNumber getBranchRevisionNumber(@NotNull HgRepository repository, @NotNull String branchName) throws VcsException {
        Hash refHashToCompare;
        if (repository == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(20);
        }
        if (branchName == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(21);
        }
        if ((refHashToCompare = HgCompareWithBranchAction.detectActiveHashByName(repository, branchName)) == null) {
            throw new VcsException(String.format("Couldn't detect commit related to %s name for %s.", branchName, repository.getRoot()));
        }
        HgRevisionNumber hgRevisionNumber = HgRevisionNumber.getInstance(branchName, refHashToCompare.toString());
        if (hgRevisionNumber == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(22);
        }
        return hgRevisionNumber;
    }

    private static boolean existInBranch(@NotNull HgRepository repository, @NotNull FilePath path, @NotNull HgRevisionNumber compareWithRevisionNumber) {
        if (repository == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(23);
        }
        if (path == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(24);
        }
        if (compareWithRevisionNumber == null) {
            HgCompareWithBranchAction.$$$reportNull$$$0(25);
        }
        HgStatusCommand statusCommand = new HgStatusCommand.Builder(true).ignored(false).unknown(false).copySource(!path.isDirectory()).baseRevision(compareWithRevisionNumber).targetRevision(null).build(repository.getProject());
        statusCommand.cleanFilesOption(true);
        return !statusCommand.executeInCurrentThread(repository.getRoot(), Collections.singleton(path)).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 15: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 15: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 15: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/action/HgCompareWithBranchAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRevisionHash";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bookmarkName";
                break;
            }
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchToCompare";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compareWithRevisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/action/HgCompareWithBranchAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentHash";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherBookmarks";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNamesExceptCurrent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryManager";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffChanges";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchRevisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "noBranchesToCompare";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentHash";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 15: 
            case 19: 
            case 22: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOtherBookmarks";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findBookmarkHashByName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHeavyBranchMainHash";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "detectActiveHashByName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBranchNamesExceptCurrent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryManager";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDiffChanges";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBranchRevisionNumber";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "existInBranch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 15: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

