/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileVisitor<T> {
    public static final Option NO_FOLLOW_SYMLINKS = new Option();
    public static final Option SKIP_ROOT = new Option();
    public static final Option ONE_LEVEL_DEEP = VirtualFileVisitor.limit(1);
    public static final Result CONTINUE = new Result(false, null);
    public static final Result SKIP_CHILDREN = new Result(true, null);
    private boolean myFollowSymLinks;
    private boolean mySkipRoot;
    private int myDepthLimit;
    private int myLevel;
    private Stack<T> myValueStack;
    private T myValue;

    @NotNull
    public static Option limit(int maxDepth) {
        Option.LimitOption limitOption = new Option.LimitOption(maxDepth);
        if (limitOption == null) {
            VirtualFileVisitor.$$$reportNull$$$0(0);
        }
        return limitOption;
    }

    public static Result skipTo(@NotNull VirtualFile parentToSkipTo) {
        if (parentToSkipTo == null) {
            VirtualFileVisitor.$$$reportNull$$$0(1);
        }
        return new Result(true, parentToSkipTo);
    }

    protected VirtualFileVisitor(Option ... options) {
        if (options == null) {
            VirtualFileVisitor.$$$reportNull$$$0(2);
        }
        this.myFollowSymLinks = true;
        this.myDepthLimit = -1;
        for (Option option : options) {
            if (option == NO_FOLLOW_SYMLINKS) {
                this.myFollowSymLinks = false;
                continue;
            }
            if (option == SKIP_ROOT) {
                this.mySkipRoot = true;
                continue;
            }
            if (!(option instanceof Option.LimitOption)) continue;
            this.myDepthLimit = ((Option.LimitOption)option).limit;
        }
    }

    public boolean visitFile(@NotNull VirtualFile file) {
        if (file == null) {
            VirtualFileVisitor.$$$reportNull$$$0(3);
        }
        return true;
    }

    @NotNull
    public Result visitFileEx(@NotNull VirtualFile file) {
        if (file == null) {
            VirtualFileVisitor.$$$reportNull$$$0(4);
        }
        Result result = this.visitFile(file) ? CONTINUE : SKIP_CHILDREN;
        if (result == null) {
            VirtualFileVisitor.$$$reportNull$$$0(5);
        }
        return result;
    }

    public void afterChildrenVisited(@NotNull VirtualFile file) {
        if (file == null) {
            VirtualFileVisitor.$$$reportNull$$$0(6);
        }
    }

    @Nullable
    public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
        if (file == null) {
            VirtualFileVisitor.$$$reportNull$$$0(7);
        }
        return null;
    }

    public final void setValueForChildren(@Nullable T value) {
        this.myValue = value;
        if (this.myValueStack == null) {
            this.myValueStack = new Stack();
        }
    }

    public final T getCurrentValue() {
        return this.myValue;
    }

    final boolean allowVisitFile(@NotNull VirtualFile file) {
        if (file == null) {
            VirtualFileVisitor.$$$reportNull$$$0(8);
        }
        return this.myLevel > 0 || !this.mySkipRoot;
    }

    final boolean allowVisitChildren(@NotNull VirtualFile file) {
        if (file == null) {
            VirtualFileVisitor.$$$reportNull$$$0(9);
        }
        if (!file.is(VFileProperty.SYMLINK)) {
            return true;
        }
        if (!this.myFollowSymLinks) {
            return false;
        }
        return !file.isRecursiveOrCircularSymLink();
    }

    final boolean depthLimitReached() {
        return this.myDepthLimit >= 0 && this.myLevel >= this.myDepthLimit;
    }

    final void saveValue() {
        ++this.myLevel;
        if (this.myValueStack != null) {
            this.myValueStack.push(this.myValue);
        }
    }

    final void restoreValue(boolean pushed) {
        if (pushed) {
            --this.myLevel;
            if (this.myValueStack != null && !this.myValueStack.isEmpty()) {
                this.myValueStack.pop();
            }
        }
        if (this.myValueStack != null) {
            this.myValue = this.myValueStack.isEmpty() ? null : this.myValueStack.peek();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/VirtualFileVisitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentToSkipTo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "limit";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/VirtualFileVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "visitFileEx";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "skipTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitFileEx";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "afterChildrenVisited";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenIterable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "allowVisitFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "allowVisitChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class VisitorException
    extends RuntimeException {
        public VisitorException(@NotNull Throwable cause) {
            if (cause == null) {
                VisitorException.$$$reportNull$$$0(0);
            }
            super(cause);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/intellij/openapi/vfs/VirtualFileVisitor$VisitorException", "<init>"));
        }
    }

    public static class Result {
        public final boolean skipChildren;
        public final VirtualFile skipToParent;

        private Result(boolean skipChildren, @Nullable VirtualFile skipToParent) {
            this.skipChildren = skipChildren;
            this.skipToParent = skipToParent;
        }

        @NonNls
        public String toString() {
            return "(" + (this.skipChildren ? "skip," + this.skipToParent : "continue") + ")";
        }
    }

    public static class Option {
        private Option() {
        }

        private static class LimitOption
        extends Option {
            private final int limit;

            private LimitOption(int limit) {
                this.limit = limit;
            }
        }
    }
}

