/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;
import sun.security.util.ArrayUtil;

final class OutputFeedback
extends FeedbackCipher {
    private byte[] k = null;
    private byte[] register = null;
    private int numBytes;
    private byte[] registerSave = null;

    OutputFeedback(SymmetricCipher embeddedCipher, int numBytes) {
        super(embeddedCipher);
        if (numBytes > this.blockSize) {
            numBytes = this.blockSize;
        }
        this.numBytes = numBytes;
        this.k = new byte[this.blockSize];
        this.register = new byte[this.blockSize];
    }

    @Override
    String getFeedback() {
        return "OFB";
    }

    @Override
    void init(boolean decrypting, String algorithm, byte[] key, byte[] iv) throws InvalidKeyException {
        if (key == null || iv == null || iv.length != this.blockSize) {
            throw new InvalidKeyException("Internal error");
        }
        this.iv = iv;
        this.reset();
        this.embeddedCipher.init(false, algorithm, key);
    }

    @Override
    void reset() {
        System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
    }

    @Override
    void save() {
        if (this.registerSave == null) {
            this.registerSave = new byte[this.blockSize];
        }
        System.arraycopy(this.register, 0, this.registerSave, 0, this.blockSize);
    }

    @Override
    void restore() {
        System.arraycopy(this.registerSave, 0, this.register, 0, this.blockSize);
    }

    @Override
    int encrypt(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) {
        ArrayUtil.blockSizeCheck(plainLen, this.numBytes);
        ArrayUtil.nullAndBoundsCheck(plain, plainOffset, plainLen);
        ArrayUtil.nullAndBoundsCheck(cipher, cipherOffset, plainLen);
        int nShift = this.blockSize - this.numBytes;
        for (int loopCount = plainLen / this.numBytes; loopCount > 0; --loopCount) {
            this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
            for (int i = 0; i < this.numBytes; ++i) {
                cipher[i + cipherOffset] = (byte)(this.k[i] ^ plain[i + plainOffset]);
                if (nShift != 0) {
                    System.arraycopy(this.register, this.numBytes, this.register, 0, nShift);
                }
                System.arraycopy(this.k, 0, this.register, nShift, this.numBytes);
            }
            plainOffset += this.numBytes;
            cipherOffset += this.numBytes;
        }
        return plainLen;
    }

    @Override
    int encryptFinal(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) {
        ArrayUtil.nullAndBoundsCheck(plain, plainOffset, plainLen);
        ArrayUtil.nullAndBoundsCheck(cipher, cipherOffset, plainLen);
        int oddBytes = plainLen % this.numBytes;
        int len = this.encrypt(plain, plainOffset, plainLen - oddBytes, cipher, cipherOffset);
        plainOffset += len;
        cipherOffset += len;
        if (oddBytes != 0) {
            this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
            for (int i = 0; i < oddBytes; ++i) {
                cipher[i + cipherOffset] = (byte)(this.k[i] ^ plain[i + plainOffset]);
            }
        }
        return plainLen;
    }

    @Override
    int decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) {
        return this.encrypt(cipher, cipherOffset, cipherLen, plain, plainOffset);
    }

    @Override
    int decryptFinal(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) {
        return this.encryptFinal(cipher, cipherOffset, cipherLen, plain, plainOffset);
    }
}

