/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.LangCodeStyleExtractor;
import com.intellij.psi.codeStyle.extractor.processor.CodeStyleDeriveProcessor;
import com.intellij.psi.codeStyle.extractor.processor.GenProcessor;
import com.intellij.psi.codeStyle.extractor.ui.CodeStyleSettingsNameProvider;
import com.intellij.psi.codeStyle.extractor.ui.ExtractedSettingsDialog;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResult;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class ExtractCodeStyleAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext;
        Project project;
        if (e == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext = e.getDataContext())) == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        PsiFile file2 = null;
        if (editor == null && files2 != null && files2.length == 1 && !files2[0].isDirectory()) {
            file2 = PsiManager.getInstance((Project)project).findFile(files2[0]);
        } else if (editor != null) {
            file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        if (file2 == null) {
            return;
        }
        Language language = file2.getLanguage();
        LangCodeStyleExtractor extractor = (LangCodeStyleExtractor)LangCodeStyleExtractor.EXTENSION.forLanguage(language);
        if (extractor == null) {
            return;
        }
        final CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)file2);
        GenProcessor genProcessor = new GenProcessor(extractor);
        PsiFile finalFile = file2;
        Task.Backgroundable task2 = new Task.Backgroundable(project, "Code Style Extractor", true, (CodeStyleDeriveProcessor)genProcessor, language, project, finalFile){
            final /* synthetic */ CodeStyleDeriveProcessor val$genProcessor;
            final /* synthetic */ Language val$language;
            final /* synthetic */ Project val$project;
            final /* synthetic */ PsiFile val$finalFile;
            {
                this.val$genProcessor = codeStyleDeriveProcessor;
                this.val$language = language;
                this.val$project = project;
                this.val$finalFile = psiFile;
                super(arg0, arg1, arg2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    CodeStyleSettings cloneSettings = settings.clone();
                    Map backup = this.val$genProcessor.backupValues(cloneSettings, this.val$language);
                    ValuesExtractionResult res2 = this.val$genProcessor.runWithProgress(this.val$project, cloneSettings, this.val$finalFile, indicator);
                    ExtractCodeStyleAction.this.reportResult(this.val$genProcessor.getHTMLReport(), res2, this.val$project, cloneSettings, this.val$finalFile, backup);
                }
                catch (ProcessCanceledException e) {
                    Utils.logError((String)"Code extraction was canceled");
                }
                catch (Throwable t) {
                    Utils.logError((String)("Unexpected exception: " + t));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/codeStyle/extractor/ExtractCodeStyleAction$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    public void reportResult(@NotNull String htmlReport, final @NotNull ValuesExtractionResult calculatedValues, final @NotNull Project project, final @NotNull CodeStyleSettings cloneSettings, final @NotNull PsiFile file2, @NotNull Map<Value, Object> backup) {
        if (htmlReport == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(1);
        }
        if (calculatedValues == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(3);
        }
        if (cloneSettings == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(5);
        }
        if (backup == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(6);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            BalloonLayout layout;
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("<html>Formatting Options were extracted for " + file2.getName() + (!htmlReport.isEmpty() ? "<br/>" + htmlReport : "") + "<br/><a href=\"apply\">Apply</a> <a href=\"details\">Details...</a></html>", MessageType.INFO, new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        boolean apply2 = "apply".equals(e.getDescription());
                        ExtractedSettingsDialog myDialog = null;
                        if (!apply2) {
                            List values = calculatedValues.getValues();
                            Language language = file2.getLanguage();
                            CodeStyleSettingsNameProvider nameProvider = new CodeStyleSettingsNameProvider();
                            for (LanguageCodeStyleSettingsProvider provider : LanguageCodeStyleSettingsProvider.EP_NAME.getExtensionList()) {
                                Language target2 = provider.getLanguage();
                                if (!target2.equals(language)) continue;
                                nameProvider.addSettings(provider);
                                myDialog = new ExtractedSettingsDialog(project, nameProvider, values);
                                apply2 = myDialog.showAndGet();
                                break;
                            }
                        }
                        if (apply2) {
                            calculatedValues.applySelected();
                            CodeStyleScheme derivedScheme = CodeStyleSchemes.getInstance().createNewScheme("Derived from " + file2.getName(), null);
                            derivedScheme.getCodeStyleSettings().copyFrom(cloneSettings);
                            CodeStyleSchemes.getInstance().addScheme(derivedScheme);
                            CodeStyleSchemesImpl.getSchemeManager().setCurrent(derivedScheme);
                            CodeStyleSettingsManager.getInstance((Project)project).PREFERRED_PROJECT_CODE_STYLE = derivedScheme.getName();
                        }
                    }
                }
            }).setFadeoutTime(0L).setShowCallout(false).setAnimationCycle(0).setHideOnClickOutside(false).setHideOnKeyOutside(false).setHideOnLinkClick(true).setCloseButtonEnabled(true).createBalloon();
            Disposer.register((Disposable)project, (Disposable)balloon);
            Frame window = WindowManager.getInstance().getFrame(project);
            if (window == null) {
                window = JOptionPane.getRootFrame();
            }
            if (window instanceof IdeFrame && (layout = ((IdeFrame)window).getBalloonLayout()) != null) {
                balloon.show((PositionTracker)new PositionTracker<Balloon>((Component)((IdeFrame)window).getComponent()){

                    public RelativePoint recalculateLocation(Balloon object) {
                        Component c2 = this.getComponent();
                        int y = c2.getHeight() - 45;
                        return new RelativePoint(c2, new Point(c2.getWidth() - 150, y));
                    }
                }, Balloon.Position.above);
            }
        });
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ExtractCodeStyleAction.$$$reportNull$$$0(7);
        }
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file2 = null;
        if (editor != null) {
            file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        } else {
            VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            if (files2 != null && files2.length == 1 && !files2[0].isDirectory()) {
                file2 = PsiManager.getInstance((Project)project).findFile(files2[0]);
            }
        }
        if (file2 == null || file2.getVirtualFile() == null) {
            presentation.setEnabled(false);
            return;
        }
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null) {
            presentation.setEnabled(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlReport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculatedValues";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloneSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backup";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/extractor/ExtractCodeStyleAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "reportResult";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

