/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.persistence;

import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.internal.statistic.configurable.SendPeriod;
import com.intellij.internal.statistic.persistence.BasicSentUsagesPersistenceComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="UsagesStatistic", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED)})
public class UsageStatisticsPersistenceComponent
extends BasicSentUsagesPersistenceComponent
implements PersistentStateComponent<Element> {
    public static final String USAGE_STATISTICS_XML = "usage.statistics.xml";
    private boolean isAllowedForEAP = true;
    private boolean isShowNotification = true;
    @NotNull
    private SendPeriod myPeriod = SendPeriod.DAILY;
    private static final String LAST_TIME_ATTR = "time";
    private static final String IS_ALLOWED_ATTR = "allowed";
    private static final String IS_ALLOWED_EAP_ATTR = "allowedEap";
    private static final String SHOW_NOTIFICATION_ATTR = "show-notification";

    public static UsageStatisticsPersistenceComponent getInstance() {
        return (UsageStatisticsPersistenceComponent)ApplicationManager.getApplication().getComponent(UsageStatisticsPersistenceComponent.class);
    }

    public UsageStatisticsPersistenceComponent() {
        if (ApplicationManager.getApplication().isInternal()) {
            this.isShowNotification = false;
        }
    }

    public void loadState(@NotNull Element element) {
        String isShowNotificationValue;
        if (element == null) {
            UsageStatisticsPersistenceComponent.$$$reportNull$$$0(0);
        }
        try {
            this.setSentTime(Long.parseLong(element.getAttributeValue(LAST_TIME_ATTR, "0")));
        }
        catch (NumberFormatException e) {
            this.setSentTime(0L);
        }
        String isAllowedEapValue = element.getAttributeValue(IS_ALLOWED_EAP_ATTR, "true");
        this.isAllowedForEAP = StringUtil.isEmptyOrSpaces((String)isAllowedEapValue) || Boolean.parseBoolean(isAllowedEapValue);
        String isAllowedValue = element.getAttributeValue(IS_ALLOWED_ATTR);
        if (!StringUtil.isEmptyOrSpaces((String)isAllowedValue) && Boolean.parseBoolean(isAllowedValue)) {
            ConsentOptions.getInstance().setSendingUsageStatsAllowed(true);
        }
        this.setShowNotification(StringUtil.isEmptyOrSpaces((String)(isShowNotificationValue = element.getAttributeValue(SHOW_NOTIFICATION_ATTR))) || Boolean.parseBoolean(isShowNotificationValue));
    }

    public Element getState() {
        Element element = new Element("state");
        long lastTimeSent = this.getLastTimeSent();
        if (lastTimeSent > 0L) {
            element.setAttribute(LAST_TIME_ATTR, String.valueOf(lastTimeSent));
        }
        if (!this.isShowNotification()) {
            element.setAttribute(SHOW_NOTIFICATION_ATTR, "false");
        }
        if (!this.isAllowedForEAP) {
            element.setAttribute(IS_ALLOWED_EAP_ATTR, "false");
        }
        return element;
    }

    @NotNull
    public SendPeriod getPeriod() {
        SendPeriod sendPeriod = this.myPeriod;
        if (sendPeriod == null) {
            UsageStatisticsPersistenceComponent.$$$reportNull$$$0(1);
        }
        return sendPeriod;
    }

    public void setPeriod(@NotNull SendPeriod period) {
        if (period == null) {
            UsageStatisticsPersistenceComponent.$$$reportNull$$$0(2);
        }
        this.myPeriod = period;
    }

    public void setAllowed(boolean allowed) {
        ConsentOptions options = ConsentOptions.getInstance();
        if (options.isEAP()) {
            this.isAllowedForEAP = allowed;
        } else {
            options.setSendingUsageStatsAllowed(allowed);
        }
    }

    @Override
    public boolean isAllowed() {
        ConsentOptions options = ConsentOptions.getInstance();
        return options.isEAP() ? this.isAllowedForEAP : options.isSendingUsageStatsAllowed() == ConsentOptions.Permission.YES;
    }

    public void setShowNotification(boolean showNotification2) {
        this.isShowNotification = showNotification2;
    }

    @Override
    public boolean isShowNotification() {
        return this.isShowNotification;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/persistence/UsageStatisticsPersistenceComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "period";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/persistence/UsageStatisticsPersistenceComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPeriod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPeriod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

