/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.dashboard.tree.FolderDashboardGroupingRule;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.execution.dashboard.tree.RunConfigurationNode;
import com.intellij.execution.dashboard.tree.RunDashboardGroupImpl;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewGroupingContributor;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationsServiceViewContributor
implements ServiceViewGroupingContributor<RunConfigurationContributor, GroupingNode> {
    private static final ServiceViewDescriptor CONTRIBUTOR_DESCRIPTOR = new SimpleServiceViewDescriptor("Run Dashboard", AllIcons.Actions.Execute){

        public ActionGroup getToolbarActions() {
            return RunConfigurationsServiceViewContributor.getToolbarActions(null);
        }

        public ActionGroup getPopupActions() {
            return RunConfigurationsServiceViewContributor.getPopupActions();
        }
    };

    @NotNull
    public ServiceViewDescriptor getViewDescriptor() {
        ServiceViewDescriptor serviceViewDescriptor = CONTRIBUTOR_DESCRIPTOR;
        if (serviceViewDescriptor == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(0);
        }
        return serviceViewDescriptor;
    }

    @NotNull
    public List<RunConfigurationContributor> getServices(@NotNull Project project) {
        if (project == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(1);
        }
        RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)project);
        List list2 = ContainerUtil.map((Collection)runDashboardManager.getRunConfigurations(), value -> new RunConfigurationContributor(new RunConfigurationNode(project, (RunDashboardManager.RunDashboardService)value, runDashboardManager.getCustomizers(value.getSettings(), value.getDescriptor()))));
        if (list2 == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull RunConfigurationContributor contributor) {
        if (contributor == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(3);
        }
        ServiceViewDescriptor serviceViewDescriptor = contributor.getViewDescriptor();
        if (serviceViewDescriptor == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(4);
        }
        return serviceViewDescriptor;
    }

    @NotNull
    public List<GroupingNode> getGroups(@NotNull RunConfigurationContributor contributor) {
        if (contributor == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(5);
        }
        ArrayList<GroupingNode> result2 = new ArrayList<GroupingNode>();
        GroupingNode parentGroupNode = null;
        for (RunDashboardGroupingRule groupingRule : (RunDashboardGroupingRule[])RunDashboardGroupingRule.EP_NAME.getExtensions()) {
            RunDashboardGroup group = groupingRule.getGroup((AbstractTreeNode)contributor.asService());
            if (group == null) continue;
            GroupingNode node = new GroupingNode(contributor.asService().getProject(), parentGroupNode == null ? null : parentGroupNode.getGroup(), group);
            node.setParent(parentGroupNode);
            result2.add(node);
            parentGroupNode = node;
        }
        ArrayList<GroupingNode> arrayList = result2;
        if (arrayList == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public ServiceViewDescriptor getGroupDescriptor(@NotNull GroupingNode node) {
        if (node == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(7);
        }
        RunDashboardGroupViewDescriptor runDashboardGroupViewDescriptor = new RunDashboardGroupViewDescriptor(node);
        if (runDashboardGroupViewDescriptor == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(8);
        }
        return runDashboardGroupViewDescriptor;
    }

    @NotNull
    private static JComponent createEmptyContent() {
        JBPanelWithEmptyText panel2 = new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"run.dashboard.not.started.configuration.message", (Object[])new Object[0]));
        panel2.setFocusable(true);
        JBPanelWithEmptyText jBPanelWithEmptyText = panel2;
        if (jBPanelWithEmptyText == null) {
            RunConfigurationsServiceViewContributor.$$$reportNull$$$0(9);
        }
        return jBPanelWithEmptyText;
    }

    private static ActionGroup getToolbarActions(@Nullable RunContentDescriptor descriptor2) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("RunDashboardContentToolbar"));
        RunnerLayoutUiImpl ui = RunDashboardManagerImpl.getRunnerLayoutUi(descriptor2);
        if (ui == null) {
            return actionGroup;
        }
        List<AnAction> leftToolbarActions = ui.getActions();
        for (AnAction action2 : leftToolbarActions) {
            if (action2 instanceof StopAction || action2 instanceof FakeRerunAction) continue;
            actionGroup.add(action2);
        }
        return actionGroup;
    }

    private static ActionGroup getPopupActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        actions.add(actionManager.getAction("RunDashboardContentToolbar"));
        actions.addSeparator();
        actions.add(actionManager.getAction("RunDashboardTreeToolbar"));
        actions.add(actionManager.getAction("RunDashboardPopup"));
        return actions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/dashboard/RunConfigurationsServiceViewContributor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewDescriptor";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/dashboard/RunConfigurationsServiceViewContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroups";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyContent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getServices";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getServiceDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGroups";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGroupDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RunConfigurationContributor
    implements ServiceViewProvidingContributor<AbstractTreeNode, RunConfigurationNode> {
        private final RunConfigurationNode myNode;

        RunConfigurationContributor(@NotNull RunConfigurationNode node) {
            if (node == null) {
                RunConfigurationContributor.$$$reportNull$$$0(0);
            }
            this.myNode = node;
        }

        @NotNull
        public RunConfigurationNode asService() {
            RunConfigurationNode runConfigurationNode = this.myNode;
            if (runConfigurationNode == null) {
                RunConfigurationContributor.$$$reportNull$$$0(1);
            }
            return runConfigurationNode;
        }

        @NotNull
        public ServiceViewDescriptor getViewDescriptor() {
            RunConfigurationServiceViewDescriptor runConfigurationServiceViewDescriptor = new RunConfigurationServiceViewDescriptor(this.myNode);
            if (runConfigurationServiceViewDescriptor == null) {
                RunConfigurationContributor.$$$reportNull$$$0(2);
            }
            return runConfigurationServiceViewDescriptor;
        }

        @NotNull
        public List<AbstractTreeNode> getServices(@NotNull Project project) {
            if (project == null) {
                RunConfigurationContributor.$$$reportNull$$$0(3);
            }
            ArrayList<AbstractTreeNode> arrayList = new ArrayList<AbstractTreeNode>(this.myNode.getChildren());
            if (arrayList == null) {
                RunConfigurationContributor.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @NotNull
        public ServiceViewDescriptor getServiceDescriptor(final @NotNull AbstractTreeNode service) {
            if (service == null) {
                RunConfigurationContributor.$$$reportNull$$$0(5);
            }
            ServiceViewDescriptor serviceViewDescriptor = new ServiceViewDescriptor(){

                public ActionGroup getToolbarActions() {
                    return RunConfigurationsServiceViewContributor.getToolbarActions(null);
                }

                public ActionGroup getPopupActions() {
                    return RunConfigurationsServiceViewContributor.getPopupActions();
                }

                @NotNull
                public ItemPresentation getPresentation() {
                    PresentationData presentationData = service.getPresentation();
                    if (presentationData == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return presentationData;
                }

                @Nullable
                public String getId() {
                    List fragments;
                    ItemPresentation presentation = this.getPresentation();
                    String text2 = presentation.getPresentableText();
                    if (!StringUtil.isEmpty((String)text2)) {
                        return text2;
                    }
                    if (presentation instanceof PresentationData && !(fragments = ((PresentationData)presentation).getColoredText()).isEmpty()) {
                        StringBuilder result2 = new StringBuilder();
                        for (PresentableNodeDescriptor.ColoredFragment fragment : fragments) {
                            result2.append(fragment.getText());
                        }
                        return result2.toString();
                    }
                    return null;
                }

                @Nullable
                public Runnable getRemover() {
                    return service instanceof RunDashboardNode ? ((RunDashboardNode)service).getRemover() : null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/RunConfigurationsServiceViewContributor$RunConfigurationContributor$1", "getPresentation"));
                }
            };
            if (serviceViewDescriptor == null) {
                RunConfigurationContributor.$$$reportNull$$$0(6);
            }
            return serviceViewDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/dashboard/RunConfigurationsServiceViewContributor$RunConfigurationContributor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/dashboard/RunConfigurationsServiceViewContributor$RunConfigurationContributor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asService";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getViewDescriptor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServices";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServiceDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getServices";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getServiceDescriptor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RunDashboardGroupViewDescriptor
    implements ServiceViewDescriptor,
    WeighedItem {
        private final RunDashboardGroup myGroup;
        private final GroupingNode myNode;
        private final PresentationData myPresentationData;

        RunDashboardGroupViewDescriptor(GroupingNode node) {
            this.myNode = node;
            this.myGroup = node.getGroup();
            this.myPresentationData = new PresentationData();
            this.myPresentationData.setPresentableText(this.myGroup.getName());
            this.myPresentationData.setIcon(this.myGroup.getIcon());
        }

        @Nullable
        public String getId() {
            return RunDashboardGroupViewDescriptor.getId(this.myNode);
        }

        public ActionGroup getToolbarActions() {
            return RunConfigurationsServiceViewContributor.getToolbarActions(null);
        }

        public ActionGroup getPopupActions() {
            return RunConfigurationsServiceViewContributor.getPopupActions();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = this.myPresentationData;
            if (presentationData == null) {
                RunDashboardGroupViewDescriptor.$$$reportNull$$$0(0);
            }
            return presentationData;
        }

        public int getWeight() {
            Object value = ((RunDashboardGroupImpl)this.myGroup).getValue();
            if (value instanceof RunDashboardRunConfigurationStatus) {
                return ((RunDashboardRunConfigurationStatus)value).getPriority();
            }
            return 0;
        }

        private static String getId(GroupingNode node) {
            AbstractTreeNode parent = node.getParent();
            if (parent instanceof GroupingNode) {
                return RunDashboardGroupViewDescriptor.getId((GroupingNode)parent) + "/" + RunDashboardGroupViewDescriptor.getId(node.getGroup());
            }
            return RunDashboardGroupViewDescriptor.getId(node.getGroup());
        }

        private static String getId(RunDashboardGroup group) {
            Object value;
            if (group instanceof RunDashboardGroupImpl && (value = ((RunDashboardGroupImpl)group).getValue()) instanceof ConfigurationType) {
                return ((ConfigurationType)value).getId();
            }
            return group.getName();
        }

        @Nullable
        public Runnable getRemover() {
            if (this.myGroup instanceof FolderDashboardGroupingRule.FolderDashboardGroup) {
                return () -> {
                    String groupName = this.myGroup.getName();
                    Project project = ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject();
                    List services = RunDashboardManager.getInstance((Project)project).getRunConfigurations();
                    RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
                    runManager.fireBeginUpdate();
                    try {
                        for (RunDashboardManager.RunDashboardService service : services) {
                            RunnerAndConfigurationSettings settings = service.getSettings();
                            if (!groupName.equals(settings.getFolderName())) continue;
                            settings.setFolderName(null);
                        }
                    }
                    finally {
                        runManager.fireEndUpdate();
                    }
                };
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/RunConfigurationsServiceViewContributor$RunDashboardGroupViewDescriptor", "getPresentation"));
        }
    }

    private static class RunConfigurationServiceViewDescriptor
    implements ServiceViewDescriptor {
        private final RunConfigurationNode node;

        RunConfigurationServiceViewDescriptor(RunConfigurationNode node) {
            this.node = node;
        }

        @Nullable
        public String getId() {
            RunConfiguration configuration = this.node.getConfigurationSettings().getConfiguration();
            return configuration.getType().getId() + "/" + configuration.getName();
        }

        public JComponent getContentComponent() {
            Content content2 = this.node.getContent();
            if (content2 == null) {
                return RunConfigurationsServiceViewContributor.createEmptyContent();
            }
            ContentManager contentManager = content2.getManager();
            return contentManager == null ? null : contentManager.getComponent();
        }

        @NotNull
        public ItemPresentation getContentPresentation() {
            Content content2 = this.node.getContent();
            if (content2 != null) {
                PresentationData presentationData = new PresentationData(content2.getDisplayName(), null, content2.getIcon(), null);
                if (presentationData == null) {
                    RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(0);
                }
                return presentationData;
            }
            RunConfiguration configuration = this.node.getConfigurationSettings().getConfiguration();
            PresentationData presentationData = new PresentationData(configuration.getName(), null, configuration.getIcon(), null);
            if (presentationData == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(1);
            }
            return presentationData;
        }

        public ActionGroup getToolbarActions() {
            return RunConfigurationsServiceViewContributor.getToolbarActions(this.node.getDescriptor());
        }

        public ActionGroup getPopupActions() {
            return RunConfigurationsServiceViewContributor.getPopupActions();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = this.node.getPresentation();
            if (presentationData == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(2);
            }
            return presentationData;
        }

        public DataProvider getDataProvider() {
            Content content2 = this.node.getContent();
            if (content2 == null) {
                return null;
            }
            DataContext context = DataManager.getInstance().getDataContext((Component)content2.getComponent());
            return arg_0 -> ((DataContext)context).getData(arg_0);
        }

        public void onNodeSelected() {
            Content content2 = this.node.getContent();
            if (content2 == null) {
                return;
            }
            ContentManager contentManager = content2.getManager();
            if (contentManager == null || content2 == contentManager.getSelectedContent()) {
                return;
            }
            contentManager.setSelectedContent(content2);
        }

        public void onNodeUnselected() {
            Content content2 = this.node.getContent();
            if (content2 == null) {
                return;
            }
            ContentManager contentManager = content2.getManager();
            if (contentManager == null || content2 != contentManager.getSelectedContent()) {
                return;
            }
            contentManager.removeFromSelection(content2);
        }

        @Nullable
        public Navigatable getNavigatable() {
            for (RunDashboardCustomizer customizer : this.node.getCustomizers()) {
                Navigatable navigatable = customizer.getNavigatable((RunDashboardRunConfigurationNode)this.node);
                if (navigatable == null) continue;
                return navigatable;
            }
            return null;
        }

        @Nullable
        public Object getPresentationTag(Object fragment) {
            Map links = (Map)this.node.getUserData(RunDashboardCustomizer.NODE_LINKS);
            return links == null ? null : links.get(fragment);
        }

        @Nullable
        public Runnable getRemover() {
            RunnerAndConfigurationSettings settings = this.node.getConfigurationSettings();
            RunManager runManager = RunManager.getInstance((Project)settings.getConfiguration().getProject());
            return runManager.hasSettings(settings) ? () -> runManager.removeConfiguration(settings) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/execution/dashboard/RunConfigurationsServiceViewContributor$RunConfigurationServiceViewDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

