/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.util.Key;
import com.intellij.util.ReflectionUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/stats/completion/CompletionUtil;", "", "()V", "COMPLETION_STARTING_TIME_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "getCOMPLETION_STARTING_TIME_KEY", "()Lcom/intellij/openapi/util/Key;", "ML_SORTING_CONTRIBUTION_KEY", "getML_SORTING_CONTRIBUTION_KEY", "getCurrentCompletion", "Lcom/intellij/codeInsight/completion/CompletionProgressIndicator;", "getCurrentCompletionParameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "getMLTimeContribution", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "(Lcom/intellij/codeInsight/lookup/impl/LookupImpl;)Ljava/lang/Long;", "getShownTimestamp", "intellij.statsCollector"})
public final class CompletionUtil {
    @NotNull
    private static final Key<Long> COMPLETION_STARTING_TIME_KEY;
    @NotNull
    private static final Key<Long> ML_SORTING_CONTRIBUTION_KEY;
    public static final CompletionUtil INSTANCE;

    @NotNull
    public final Key<Long> getCOMPLETION_STARTING_TIME_KEY() {
        return COMPLETION_STARTING_TIME_KEY;
    }

    @NotNull
    public final Key<Long> getML_SORTING_CONTRIBUTION_KEY() {
        return ML_SORTING_CONTRIBUTION_KEY;
    }

    @Nullable
    public final CompletionParameters getCurrentCompletionParameters() {
        CompletionProgressIndicator completionProgressIndicator = this.getCurrentCompletion();
        return completionProgressIndicator != null ? completionProgressIndicator.getParameters() : null;
    }

    @Nullable
    public final Long getShownTimestamp(@NotNull LookupImpl lookup) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        if (lookup.isShown()) {
            return (Long)ReflectionUtil.getField(LookupImpl.class, (Object)lookup, Long.TYPE, (String)"myStampShown");
        }
        return null;
    }

    @Nullable
    public final Long getMLTimeContribution(@NotNull LookupImpl lookup) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        return (Long)lookup.getUserData(ML_SORTING_CONTRIBUTION_KEY);
    }

    private final CompletionProgressIndicator getCurrentCompletion() {
        CompletionService completionService = CompletionService.getCompletionService();
        Intrinsics.checkExpressionValueIsNotNull((Object)completionService, (String)"CompletionService.getCompletionService()");
        CompletionProcess completionProcess = completionService.getCurrentCompletion();
        if (!(completionProcess instanceof CompletionProgressIndicator)) {
            completionProcess = null;
        }
        return (CompletionProgressIndicator)completionProcess;
    }

    private CompletionUtil() {
    }

    static {
        CompletionUtil completionUtil;
        INSTANCE = completionUtil = new CompletionUtil();
        Key key = Key.create((String)"com.intellij.stats.completion.starting.time");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<Long>(\"com.in\u2026ompletion.starting.time\")");
        COMPLETION_STARTING_TIME_KEY = key;
        Key key2 = Key.create((String)"com.intellij.stats.completion.ml.contribution");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<Long>(\"com.in\u2026pletion.ml.contribution\")");
        ML_SORTING_CONTRIBUTION_KEY = key2;
    }
}

