/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnProgressCanceller;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.AuthCallbackCase;
import org.jetbrains.idea.svn.commandLine.CertificateCallbackCase;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandParametersResolutionModule;
import org.jetbrains.idea.svn.commandLine.CommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.ProxyCallback;
import org.jetbrains.idea.svn.commandLine.ProxyModule;
import org.jetbrains.idea.svn.commandLine.SshTunnelRuntimeModule;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.TerminalExecutor;
import org.jetbrains.idea.svn.commandLine.TerminalSshModule;
import org.jetbrains.idea.svn.commandLine.TerminalSslCertificateModule;
import org.jetbrains.idea.svn.commandLine.TerminalUserNamePasswordModule;
import org.jetbrains.idea.svn.commandLine.TwoWaySslCallback;
import org.jetbrains.idea.svn.commandLine.UsernamePasswordCallback;
import org.jetbrains.idea.svn.commandLine.WinTerminalExecutor;

public class CommandRuntime {
    private static final Logger LOG = Logger.getInstance(CommandRuntime.class);
    @NotNull
    private final AuthenticationService myAuthenticationService;
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final List<CommandRuntimeModule> myModules;
    private final String exePath;

    public CommandRuntime(@NotNull SvnVcs vcs, @NotNull AuthenticationService authenticationService) {
        if (vcs == null) {
            CommandRuntime.$$$reportNull$$$0(0);
        }
        if (authenticationService == null) {
            CommandRuntime.$$$reportNull$$$0(1);
        }
        this.myVcs = vcs;
        this.myAuthenticationService = authenticationService;
        SvnApplicationSettings settings = SvnApplicationSettings.getInstance();
        this.exePath = settings.getCommandLinePath();
        this.myModules = new ArrayList<CommandRuntimeModule>();
        this.myModules.add(new CommandParametersResolutionModule(this));
        this.myModules.add(new ProxyModule(this));
        this.myModules.add(new SshTunnelRuntimeModule(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CommandExecutor runWithAuthenticationAttempt(@NotNull Command command) throws SvnBindException {
        if (command == null) {
            CommandRuntime.$$$reportNull$$$0(2);
        }
        this.onStart(command);
        boolean repeat = true;
        CommandExecutor executor = null;
        while (repeat) {
            executor = this.newExecutor(command);
            executor.run();
            repeat = this.onAfterCommand(executor, command);
        }
        CommandExecutor commandExecutor = executor;
        CommandExecutor commandExecutor2 = commandExecutor;
        if (commandExecutor2 == null) {
            CommandRuntime.$$$reportNull$$$0(3);
        }
        return commandExecutor2;
        finally {
            this.onFinish();
        }
    }

    @NotNull
    public CommandExecutor runLocal(@NotNull Command command, int timeout) throws SvnBindException {
        if (command == null) {
            CommandRuntime.$$$reportNull$$$0(4);
        }
        if (command.getWorkingDirectory() == null) {
            command.setWorkingDirectory(CommandParametersResolutionModule.getDefaultWorkingDirectory(this.myVcs.getProject()));
        }
        CommandExecutor executor = this.newExecutor(command);
        executor.run(timeout);
        this.onAfterCommand(executor, command);
        CommandExecutor commandExecutor = executor;
        if (commandExecutor == null) {
            CommandRuntime.$$$reportNull$$$0(5);
        }
        return commandExecutor;
    }

    private void onStart(@NotNull Command command) throws SvnBindException {
        if (command == null) {
            CommandRuntime.$$$reportNull$$$0(6);
        }
        command.setCanceller(new SvnProgressCanceller());
        for (CommandRuntimeModule module : this.myModules) {
            module.onStart(command);
        }
    }

    private boolean onAfterCommand(@NotNull CommandExecutor executor, @NotNull Command command) throws SvnBindException {
        if (executor == null) {
            CommandRuntime.$$$reportNull$$$0(7);
        }
        if (command == null) {
            CommandRuntime.$$$reportNull$$$0(8);
        }
        boolean repeat = false;
        Integer exitCode = executor.getExitCodeReference();
        if (exitCode == null || exitCode != 0) {
            CommandRuntime.logNullExitCode(executor, exitCode);
            this.cleanupManualDestroy(executor, command);
            repeat = !StringUtil.isEmpty((String)executor.getErrorOutput()) ? this.handleErrorText(executor, command) : CommandRuntime.handleErrorCode(executor);
        } else {
            CommandRuntime.handleSuccess(executor);
        }
        return repeat;
    }

    private static void handleSuccess(@NotNull CommandExecutor executor) {
        if (executor == null) {
            CommandRuntime.$$$reportNull$$$0(9);
        }
        if (!StringUtil.isEmptyOrSpaces((String)executor.getErrorOutput())) {
            LOG.info("Detected warning - " + executor.getErrorOutput());
        }
    }

    private static boolean handleErrorCode(CommandExecutor executor) throws SvnBindException {
        Integer exitCode = executor.getExitCodeReference();
        if (exitCode != null) {
            LOG.info("Command - " + executor.getCommandText());
            LOG.info("Command output - " + executor.getOutput());
            throw new SvnBindException("Svn process exited with error code: " + exitCode);
        }
        return false;
    }

    private boolean handleErrorText(CommandExecutor executor, Command command) throws SvnBindException {
        String errText = executor.getErrorOutput().trim();
        AuthCallbackCase callback = this.createCallback(errText, command.getRepositoryUrl(), executor instanceof TerminalExecutor);
        if (!executor.checkCancelled() && callback != null && callback.getCredentials(errText)) {
            command.setConfigDir(this.myAuthenticationService.getSpecialConfigDir().toFile());
            callback.updateParameters(command);
            return true;
        }
        throw new SvnBindException(errText);
    }

    private void cleanupManualDestroy(CommandExecutor executor, Command command) throws SvnBindException {
        if (executor.isManuallyDestroyed()) {
            this.cleanup(executor, command.getWorkingDirectory());
            String destroyReason = executor.getDestroyReason();
            if (!StringUtil.isEmpty((String)destroyReason)) {
                throw new SvnBindException(destroyReason);
            }
        }
    }

    private void onFinish() {
        this.myAuthenticationService.reset();
    }

    private static void logNullExitCode(@NotNull CommandExecutor executor, @Nullable Integer exitCode) {
        if (executor == null) {
            CommandRuntime.$$$reportNull$$$0(10);
        }
        if (exitCode == null) {
            LOG.info("Null exit code returned, but not errors detected " + executor.getCommandText());
        }
    }

    @Nullable
    private AuthCallbackCase createCallback(@NotNull String errText, @Nullable Url url, boolean isUnderTerminal) {
        if (errText == null) {
            CommandRuntime.$$$reportNull$$$0(11);
        }
        ArrayList<AuthCallbackCase> authCases = new ArrayList<AuthCallbackCase>();
        if (isUnderTerminal) {
            authCases.add(new ProxyCallback(this.myAuthenticationService, url));
            authCases.add(new TwoWaySslCallback(this.myAuthenticationService, url));
        } else {
            authCases.add(new CertificateCallbackCase(this.myAuthenticationService, url));
            authCases.add(new ProxyCallback(this.myAuthenticationService, url));
            authCases.add(new TwoWaySslCallback(this.myAuthenticationService, url));
            authCases.add(new UsernamePasswordCallback(this.myAuthenticationService, url));
        }
        return (AuthCallbackCase)ContainerUtil.find(authCases, authCase -> authCase.canHandle(errText));
    }

    private void cleanup(@NotNull CommandExecutor executor, @NotNull File workingDirectory) throws SvnBindException {
        if (executor == null) {
            CommandRuntime.$$$reportNull$$$0(12);
        }
        if (workingDirectory == null) {
            CommandRuntime.$$$reportNull$$$0(13);
        }
        if (executor.getCommandName().isWriteable()) {
            File wcRoot = SvnUtil.getWorkingCopyRoot(workingDirectory);
            if (wcRoot != null) {
                Command cleanupCommand = new Command(SvnCommandName.cleanup);
                cleanupCommand.setWorkingDirectory(wcRoot);
                this.newExecutor(cleanupCommand).run();
            } else {
                LOG.info("Could not execute cleanup for command " + executor.getCommandText());
            }
        }
    }

    @NotNull
    private CommandExecutor newExecutor(@NotNull Command command) {
        CommandExecutor executor;
        if (command == null) {
            CommandRuntime.$$$reportNull$$$0(14);
        }
        if (!this.myVcs.getSvnConfiguration().isRunUnderTerminal() || CommandRuntime.isLocal(command)) {
            command.putIfNotPresent("--non-interactive");
            executor = new CommandExecutor(this.exePath, command);
        } else {
            executor = this.newTerminalExecutor(command);
            ((TerminalExecutor)executor).addInteractiveListener(new TerminalSshModule(this, executor));
            ((TerminalExecutor)executor).addInteractiveListener(new TerminalSslCertificateModule(this, executor));
            ((TerminalExecutor)executor).addInteractiveListener(new TerminalUserNamePasswordModule(this, executor));
        }
        CommandExecutor commandExecutor = executor;
        if (commandExecutor == null) {
            CommandRuntime.$$$reportNull$$$0(15);
        }
        return commandExecutor;
    }

    @NotNull
    private TerminalExecutor newTerminalExecutor(@NotNull Command command) {
        if (command == null) {
            CommandRuntime.$$$reportNull$$$0(16);
        }
        TerminalExecutor terminalExecutor = SystemInfo.isWindows ? new WinTerminalExecutor(this.exePath, command) : new TerminalExecutor(this.exePath, command);
        if (terminalExecutor == null) {
            CommandRuntime.$$$reportNull$$$0(17);
        }
        return terminalExecutor;
    }

    public static boolean isLocal(@NotNull Command command) {
        if (command == null) {
            CommandRuntime.$$$reportNull$$$0(18);
        }
        return SvnCommandName.version.equals((Object)command.getName()) || SvnCommandName.cleanup.equals((Object)command.getName()) || SvnCommandName.add.equals((Object)command.getName()) || SvnCommandName.delete.equals((Object)command.getName()) || SvnCommandName.revert.equals((Object)command.getName()) || SvnCommandName.resolve.equals((Object)command.getName()) || SvnCommandName.upgrade.equals((Object)command.getName()) || SvnCommandName.changelist.equals((Object)command.getName()) || command.isLocalInfo() || command.isLocalStatus() || command.isLocalProperty() || command.isLocalCat();
    }

    @NotNull
    public AuthenticationService getAuthenticationService() {
        AuthenticationService authenticationService = this.myAuthenticationService;
        if (authenticationService == null) {
            CommandRuntime.$$$reportNull$$$0(19);
        }
        return authenticationService;
    }

    @NotNull
    public SvnVcs getVcs() {
        SvnVcs svnVcs = this.myVcs;
        if (svnVcs == null) {
            CommandRuntime.$$$reportNull$$$0(20);
        }
        return svnVcs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationService";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: 
            case 5: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/CommandRuntime";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errText";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/CommandRuntime";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runWithAuthenticationAttempt";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "runLocal";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "newExecutor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "newTerminalExecutor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthenticationService";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runWithAuthenticationAttempt";
                break;
            }
            case 3: 
            case 5: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runLocal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onAfterCommand";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleSuccess";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logNullExitCode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCallback";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "newExecutor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "newTerminalExecutor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isLocal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

