/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.CodeSmellDetector;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CodeAnalysisBeforeCheckinShowOnlyNew;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeAnalysisBeforeCheckinHandler
extends CheckinHandler {
    private final Project myProject;
    private final CheckinProjectPanel myCheckinPanel;
    private static final Logger LOG = Logger.getInstance(CodeAnalysisBeforeCheckinHandler.class);

    public CodeAnalysisBeforeCheckinHandler(Project project, CheckinProjectPanel panel2) {
        this.myProject = project;
        this.myCheckinPanel = panel2;
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        return new BooleanCommitOption(this.myCheckinPanel, VcsBundle.message((String)"before.checkin.standard.options.check.smells", (Object[])new Object[0]), true, (Function0<Boolean>)((Function0)() -> this.getSettings().CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT), value -> {
            this.getSettings().CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT = value;
        });
    }

    private VcsConfiguration getSettings() {
        return VcsConfiguration.getInstance((Project)this.myProject);
    }

    private CheckinHandler.ReturnResult processFoundCodeSmells(List<CodeSmellInfo> codeSmells, @Nullable CommitExecutor executor) {
        int errorCount = CodeAnalysisBeforeCheckinHandler.collectErrors(codeSmells);
        int warningCount = codeSmells.size() - errorCount;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Set virtualFiles = ContainerUtil.map2Set(codeSmells, smell -> fileDocumentManager.getFile(smell.getDocument()));
        String commitButtonText = executor != null ? executor.getActionText() : this.myCheckinPanel.getCommitActionName();
        commitButtonText = StringUtil.trimEnd((String)commitButtonText, (String)"...");
        String message = virtualFiles.size() == 1 ? VcsBundle.message((String)"before.commit.file.contains.code.smells.edit.them.confirm.text", (Object[])new Object[]{FileUtil.toSystemDependentName((String)FileUtil.getLocationRelativeToUserHome((String)((VirtualFile)virtualFiles.iterator().next()).getPath())), errorCount, warningCount}) : VcsBundle.message((String)"before.commit.files.contain.code.smells.edit.them.confirm.text", (Object[])new Object[]{virtualFiles.size(), errorCount, warningCount});
        int answer = Messages.showYesNoCancelDialog((Project)this.myProject, (String)message, (String)VcsBundle.message((String)"code.smells.error.messages.tab.name", (Object[])new Object[0]), (String)VcsBundle.message((String)"code.smells.review.button", (Object[])new Object[0]), (String)commitButtonText, (String)CommonBundle.getCancelButtonText(), (Icon)UIUtil.getWarningIcon());
        if (answer == 0) {
            CodeSmellDetector.getInstance(this.myProject).showCodeSmellErrors(codeSmells);
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }
        if (answer == 2) {
            return CheckinHandler.ReturnResult.CANCEL;
        }
        return CheckinHandler.ReturnResult.COMMIT;
    }

    private static int collectErrors(List<CodeSmellInfo> codeSmells) {
        int result2 = 0;
        for (CodeSmellInfo codeSmellInfo : codeSmells) {
            if (codeSmellInfo.getSeverity() != HighlightSeverity.ERROR) continue;
            ++result2;
        }
        return result2;
    }

    public CheckinHandler.ReturnResult beforeCheckin(CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
        if (this.getSettings().CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT) {
            if (DumbService.getInstance((Project)this.myProject).isDumb()) {
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)VcsBundle.message((String)"code.smells.error.indexing.message", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), (String)VcsBundle.message((String)"code.smells.error.indexing", (Object[])new Object[0]), (String)"&Wait", (String)"&Commit", null) == 0) {
                    return CheckinHandler.ReturnResult.CANCEL;
                }
                return CheckinHandler.ReturnResult.COMMIT;
            }
            try {
                return this.runCodeAnalysis(executor);
            }
            catch (ProcessCanceledException e) {
                return CheckinHandler.ReturnResult.CANCEL;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)("Code analysis failed with exception: " + e.getClass().getName() + ": " + e.getMessage()), (String)"Code Analysis Failed", (String)"&Commit", (String)"Ca&ncel", null) == 0) {
                    return CheckinHandler.ReturnResult.COMMIT;
                }
                return CheckinHandler.ReturnResult.CANCEL;
            }
        }
        return CheckinHandler.ReturnResult.COMMIT;
    }

    @NotNull
    private CheckinHandler.ReturnResult runCodeAnalysis(@Nullable CommitExecutor commitExecutor) {
        List<VirtualFile> files2 = CheckinHandlerUtil.filterOutGeneratedAndExcludedFiles(this.myCheckinPanel.getVirtualFiles(), this.myProject);
        if (files2.size() <= Registry.intValue((String)"vcs.code.analysis.before.checkin.show.only.new.threshold", (int)0)) {
            CheckinHandler.ReturnResult returnResult = this.runCodeAnalysisNew(commitExecutor, files2);
            if (returnResult == null) {
                CodeAnalysisBeforeCheckinHandler.$$$reportNull$$$0(0);
            }
            return returnResult;
        }
        CheckinHandler.ReturnResult returnResult = this.runCodeAnalysisOld(commitExecutor, files2);
        if (returnResult == null) {
            CodeAnalysisBeforeCheckinHandler.$$$reportNull$$$0(1);
        }
        return returnResult;
    }

    @NotNull
    private CheckinHandler.ReturnResult runCodeAnalysisNew(@Nullable CommitExecutor commitExecutor, final @NotNull List<? extends VirtualFile> files2) {
        if (files2 == null) {
            CodeAnalysisBeforeCheckinHandler.$$$reportNull$$$0(2);
        }
        final Ref codeSmells = Ref.create();
        final Ref exception = Ref.create();
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, VcsBundle.message((String)"checking.code.smells.progress.title", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    assert (this.myProject != null);
                    indicator.setIndeterminate(true);
                    codeSmells.set(CodeAnalysisBeforeCheckinShowOnlyNew.runAnalysis(this.myProject, files2, indicator));
                    indicator.setText(VcsBundle.getString((String)"before.checkin.waiting.for.smart.mode"));
                    DumbService.getInstance((Project)this.myProject).waitForSmartMode();
                }
                catch (ProcessCanceledException e) {
                    LOG.info("Code analysis canceled", (Throwable)e);
                    exception.set((Object)e);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    exception.set((Object)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/checkin/CodeAnalysisBeforeCheckinHandler$1", "run"));
            }
        });
        if (!exception.isNull()) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)((Throwable)exception.get()));
        }
        if (!((List)codeSmells.get()).isEmpty()) {
            CheckinHandler.ReturnResult returnResult = this.processFoundCodeSmells((List)codeSmells.get(), commitExecutor);
            if (returnResult == null) {
                CodeAnalysisBeforeCheckinHandler.$$$reportNull$$$0(3);
            }
            return returnResult;
        }
        CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.COMMIT;
        if (returnResult == null) {
            CodeAnalysisBeforeCheckinHandler.$$$reportNull$$$0(4);
        }
        return returnResult;
    }

    @NotNull
    private CheckinHandler.ReturnResult runCodeAnalysisOld(@Nullable CommitExecutor commitExecutor, @NotNull List<? extends VirtualFile> files2) {
        List<CodeSmellInfo> codeSmells;
        if (files2 == null) {
            CodeAnalysisBeforeCheckinHandler.$$$reportNull$$$0(5);
        }
        if (!(codeSmells = CodeSmellDetector.getInstance(this.myProject).findCodeSmells(files2)).isEmpty()) {
            CheckinHandler.ReturnResult returnResult = this.processFoundCodeSmells(codeSmells, commitExecutor);
            if (returnResult == null) {
                CodeAnalysisBeforeCheckinHandler.$$$reportNull$$$0(6);
            }
            return returnResult;
        }
        CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.COMMIT;
        if (returnResult == null) {
            CodeAnalysisBeforeCheckinHandler.$$$reportNull$$$0(7);
        }
        return returnResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/checkin/CodeAnalysisBeforeCheckinHandler";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "runCodeAnalysis";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/checkin/CodeAnalysisBeforeCheckinHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "runCodeAnalysisNew";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "runCodeAnalysisOld";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runCodeAnalysisNew";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runCodeAnalysisOld";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

