/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import icons.SpellcheckerIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AcceptWordAsCorrect
implements SpellCheckerQuickFix {
    private String myWord;

    public AcceptWordAsCorrect(String word) {
        this.myWord = word;
    }

    public AcceptWordAsCorrect() {
    }

    @NotNull
    public String getName() {
        String string = this.myWord != null ? SpellCheckerBundle.message("add.0.to.dictionary", this.myWord) : SpellCheckerBundle.message("add.to.dictionary", new Object[0]);
        if (string == null) {
            AcceptWordAsCorrect.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpellCheckerBundle.message("add.to.dictionary", new Object[0]);
        if (string == null) {
            AcceptWordAsCorrect.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        Anchor anchor = Anchor.LAST;
        if (anchor == null) {
            AcceptWordAsCorrect.$$$reportNull$$$0(2);
        }
        return anchor;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            AcceptWordAsCorrect.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            AcceptWordAsCorrect.$$$reportNull$$$0(4);
        }
        SpellCheckerManager spellCheckerManager = SpellCheckerManager.getInstance(project);
        if (this.myWord != null) {
            spellCheckerManager.acceptWordAsCorrect(this.myWord, project);
        } else {
            spellCheckerManager.acceptWordAsCorrect(ProblemDescriptorUtil.extractHighlightedText((CommonProblemDescriptor)descriptor, (PsiElement)descriptor.getPsiElement()), project);
        }
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/quickfixes/AcceptWordAsCorrect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupActionAnchor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/quickfixes/AcceptWordAsCorrect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

