/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.actions.generated.instance.MindmapLastStateMapStorage;
import freemind.controller.actions.generated.instance.MindmapLastStateStorage;
import freemind.controller.actions.generated.instance.NodeListMember;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Resources;
import freemind.main.Tools;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;

public class LastStateStorageManagement {
    public static final int LIST_AMOUNT_LIMIT = 50;
    private MindmapLastStateMapStorage mLastStatesMap = null;
    protected static Logger logger = null;

    public LastStateStorageManagement(String pXml) {
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        try {
            XmlAction action = Tools.unMarshall(pXml);
            if (action != null && action instanceof MindmapLastStateMapStorage) {
                this.mLastStatesMap = (MindmapLastStateMapStorage)action;
            }
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
        }
        if (this.mLastStatesMap == null) {
            logger.warning("Creating a new last state map storage as there was no old one or it was corrupt.");
            this.mLastStatesMap = new MindmapLastStateMapStorage();
        }
    }

    public String getXml() {
        return Tools.marshall((XmlAction)this.mLastStatesMap);
    }

    public void clearTabIndices() {
        for (MindmapLastStateStorage store : this.mLastStatesMap.getListMindmapLastStateStorageList()) {
            store.setTabIndex(-1);
        }
    }

    public void changeOrAdd(MindmapLastStateStorage pStore) {
        boolean found = false;
        for (MindmapLastStateStorage store : this.mLastStatesMap.getListMindmapLastStateStorageList()) {
            if (!Tools.safeEquals(pStore.getRestorableName(), store.getRestorableName())) continue;
            store.setLastZoom(pStore.getLastZoom());
            store.setLastSelected(pStore.getLastSelected());
            store.setX(pStore.getX());
            store.setY(pStore.getY());
            Vector listCopy = new Vector(pStore.getListNodeListMemberList());
            store.clearNodeListMemberList();
            for (NodeListMember member : listCopy) {
                store.addNodeListMember(member);
            }
            found = true;
            this.setLastChanged(store);
            break;
        }
        if (!found) {
            this.setLastChanged(pStore);
            this.mLastStatesMap.addMindmapLastStateStorage(pStore);
        }
        if (this.mLastStatesMap.sizeMindmapLastStateStorageList() > 50) {
            TreeMap<Long, MindmapLastStateStorage> dateToStoreMap = new TreeMap<Long, MindmapLastStateStorage>();
            for (MindmapLastStateStorage store : this.mLastStatesMap.getListMindmapLastStateStorageList()) {
                dateToStoreMap.put(-store.getLastChanged(), store);
            }
            this.mLastStatesMap.clearMindmapLastStateStorageList();
            int counter = 0;
            for (Map.Entry entry : dateToStoreMap.entrySet()) {
                this.mLastStatesMap.addMindmapLastStateStorage((MindmapLastStateStorage)entry.getValue());
                if (++counter < 50) continue;
                break;
            }
        }
    }

    private void setLastChanged(MindmapLastStateStorage pStore) {
        pStore.setLastChanged(System.currentTimeMillis());
    }

    public MindmapLastStateStorage getStorage(String pRestorableName) {
        for (MindmapLastStateStorage store : this.mLastStatesMap.getListMindmapLastStateStorageList()) {
            if (!Tools.safeEquals(pRestorableName, store.getRestorableName())) continue;
            this.setLastChanged(store);
            return store;
        }
        return null;
    }

    public List getLastOpenList() {
        Vector<MindmapLastStateStorage> ret = new Vector<MindmapLastStateStorage>();
        for (MindmapLastStateStorage store : this.mLastStatesMap.getListMindmapLastStateStorageList()) {
            if (store.getTabIndex() < 0) continue;
            ret.add(store);
        }
        Collections.sort(ret, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                MindmapLastStateStorage store0 = (MindmapLastStateStorage)arg0;
                MindmapLastStateStorage store1 = (MindmapLastStateStorage)arg1;
                return store0.getTabIndex() - store1.getTabIndex();
            }
        });
        return ret;
    }

    public int getLastFocussedTab() {
        return this.mLastStatesMap.getLastFocusedTab();
    }

    public void setLastFocussedTab(int pIndex) {
        this.mLastStatesMap.setLastFocusedTab(pIndex);
    }
}

