/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;

public class AddImportsOperation
implements IWorkspaceRunnable {
    private IJavaScriptUnit fCompilationUnit;
    private final int fSelectionOffset;
    private final int fSelectionLength;
    private final IChooseImportQuery fQuery;
    private IStatus fStatus;
    private boolean fDoSave;

    public AddImportsOperation(IJavaScriptUnit cu, int selectionOffset, int selectionLength, IChooseImportQuery query, boolean save) {
        Assert.isNotNull((Object)cu);
        this.fCompilationUnit = cu;
        this.fSelectionOffset = selectionOffset;
        this.fSelectionLength = selectionLength;
        this.fQuery = query;
        this.fStatus = Status.OK_STATUS;
        this.fDoSave = save;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(CodeGenerationMessages.AddImportsOperation_description, 4);
            JavaScriptUnit astRoot = JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)this.fCompilationUnit, ASTProvider.WAIT_YES, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ImportRewrite importRewrite = StubUtility.createImportRewrite(astRoot, true);
            MultiTextEdit res = new MultiTextEdit();
            TextEdit edit = this.evaluateEdits(astRoot, importRewrite, this.fSelectionOffset, this.fSelectionLength, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (edit == null) {
                return;
            }
            try {
                res.addChild(edit);
                TextEdit importsEdit = importRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                res.addChild(importsEdit);
                JavaModelUtil.applyEdit(this.fCompilationUnit, (TextEdit)res, this.fDoSave, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (BadLocationException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TextEdit evaluateEdits(JavaScriptUnit root, ImportRewrite importRewrite, int offset, int length, IProgressMonitor monitor) throws BadLocationException, JavaScriptModelException {
        TypeNameMatch chosen;
        IJavaScriptSearchScope searchScope;
        TypeNameMatch[] types;
        int qualifierStart;
        String name;
        String containerName;
        int simpleNameStart;
        String simpleName;
        SimpleName nameNode = null;
        if (root != null) {
            ASTNode node = NodeFinder.perform((ASTNode)root, offset, length);
            if (node instanceof QualifiedName) {
                nameNode = ((QualifiedName)node).getName();
            } else if (node instanceof SimpleName) {
                nameNode = (SimpleName)node;
            }
        }
        if (nameNode != null) {
            Name qualifier;
            simpleName = nameNode.getIdentifier();
            simpleNameStart = nameNode.getStartPosition();
            if (nameNode.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
                qualifier = ((QualifiedName)nameNode.getParent()).getQualifier();
                containerName = qualifier.getFullyQualifiedName();
                name = JavaModelUtil.concatenateName(containerName, simpleName);
                qualifierStart = qualifier.getStartPosition();
            } else if (nameNode.getParent().getLocationInParent() == QualifiedType.NAME_PROPERTY) {
                qualifier = ((QualifiedType)nameNode.getParent().getParent()).getQualifier();
                containerName = ASTNodes.asString((ASTNode)qualifier);
                name = JavaModelUtil.concatenateName(containerName, simpleName);
                qualifierStart = qualifier.getStartPosition();
            } else if (nameNode.getLocationInParent() == FunctionInvocation.NAME_PROPERTY) {
                qualifier = ((FunctionInvocation)nameNode.getParent()).getExpression();
                if (!(qualifier instanceof Name)) return null;
                containerName = ASTNodes.asString((ASTNode)qualifier);
                name = JavaModelUtil.concatenateName(containerName, simpleName);
                qualifierStart = qualifier.getStartPosition();
            } else {
                containerName = "";
                name = simpleName;
                qualifierStart = simpleNameStart;
            }
            IBinding binding = nameNode.resolveBinding();
            if (binding != null && !binding.isRecovered()) {
                ITypeBinding declaringClass;
                if (binding instanceof ITypeBinding) {
                    ITypeBinding typeBinding = (ITypeBinding)binding;
                    String qualifiedBindingName = typeBinding.getQualifiedName();
                    if (containerName.length() > 0 && !qualifiedBindingName.equals(name)) {
                        return null;
                    }
                    String res = importRewrite.addImport(typeBinding);
                    if (containerName.length() <= 0 || res.equals(simpleName)) return new ReplaceEdit(qualifierStart, simpleNameStart - qualifierStart, new String());
                    return null;
                }
                if (!(binding instanceof IVariableBinding) && !(binding instanceof IFunctionBinding)) return null;
                boolean isField = binding instanceof IVariableBinding;
                ITypeBinding iTypeBinding = declaringClass = isField ? ((IVariableBinding)binding).getDeclaringClass() : ((IFunctionBinding)binding).getDeclaringClass();
                if (declaringClass == null) {
                    return null;
                }
                if (!Modifier.isStatic((int)binding.getModifiers())) return null;
                if (Modifier.isPrivate((int)declaringClass.getModifiers())) {
                    this.fStatus = JavaUIStatus.createError(4, Messages.format(CodeGenerationMessages.AddImportsOperation_error_not_visible_class, declaringClass.getName()), null);
                    return null;
                }
                if (containerName.length() <= 0 || !containerName.equals(declaringClass.getName()) && !containerName.equals(declaringClass.getQualifiedName())) return null;
                String res = importRewrite.addStaticImport(declaringClass.getQualifiedName(), binding.getName(), isField);
                if (res.equals(simpleName)) return new ReplaceEdit(qualifierStart, simpleNameStart - qualifierStart, "");
                return null;
            }
            if (binding != null && binding.getKind() != 2) {
                return null;
            }
        } else {
            int nameEnd;
            int len;
            IBuffer buffer = this.fCompilationUnit.getBuffer();
            name = buffer.getText(qualifierStart = this.getNameStart(buffer, offset), len = (nameEnd = this.getNameEnd(buffer, offset + length)) - qualifierStart).trim();
            if (name.length() == 0) {
                return null;
            }
            simpleName = Signature.getSimpleName((String)name);
            containerName = Signature.getQualifier((String)name);
            simpleNameStart = this.getSimpleNameStart(buffer, qualifierStart, containerName);
            int res = importRewrite.getDefaultImportRewriteContext().findInContext(containerName, simpleName, 1);
            if (res == 3) {
                this.fStatus = JavaUIStatus.createError(4, CodeGenerationMessages.AddImportsOperation_error_importclash, null);
                return null;
            }
            if (res == 1) {
                return new ReplaceEdit(qualifierStart, simpleNameStart - qualifierStart, "");
            }
        }
        if ((types = this.findAllTypes(simpleName, searchScope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.fCompilationUnit.getJavaScriptProject()}), nameNode, (IProgressMonitor)new SubProgressMonitor(monitor, 1))).length == 0) {
            this.fStatus = JavaUIStatus.createError(4, Messages.format(CodeGenerationMessages.AddImportsOperation_error_notresolved_message, simpleName), null);
            return null;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (types.length > 1 && this.fQuery != null) {
            chosen = this.fQuery.chooseImport(types, containerName);
            if (chosen == null) {
                throw new OperationCanceledException();
            }
        } else {
            chosen = types[0];
        }
        importRewrite.addImport(chosen.getFullyQualifiedName());
        return new ReplaceEdit(qualifierStart, simpleNameStart - qualifierStart, "");
    }

    private int getNameStart(IBuffer buffer, int pos) throws BadLocationException {
        while (pos > 0) {
            char ch = buffer.getChar(pos - 1);
            if (!Character.isJavaIdentifierPart(ch) && ch != '.') {
                return pos;
            }
            --pos;
        }
        return pos;
    }

    private int getNameEnd(IBuffer doc, int pos) throws BadLocationException {
        if (pos > 0 && Character.isWhitespace(doc.getChar(pos - 1))) {
            return pos;
        }
        int len = doc.getLength();
        while (pos < len) {
            char ch = doc.getChar(pos);
            if (!Character.isJavaIdentifierPart(ch)) {
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    private int getSimpleNameStart(IBuffer buffer, int nameStart, String containerName) throws BadLocationException {
        int containerLen = containerName.length();
        int docLen = buffer.getLength();
        if (containerLen > 0 && nameStart + containerLen + 1 < docLen) {
            int k = 0;
            while (k < containerLen) {
                if (buffer.getChar(nameStart + k) != containerName.charAt(k)) {
                    return nameStart;
                }
                ++k;
            }
            if (buffer.getChar(nameStart + containerLen) == '.') {
                return nameStart + containerLen + 1;
            }
        }
        return nameStart;
    }

    private int getSearchForConstant(int typeKinds) {
        switch (typeKinds & 2) {
            case 2: {
                return 5;
            }
        }
        return 0;
    }

    private TypeNameMatch[] findAllTypes(String simpleTypeName, IJavaScriptSearchScope searchScope, SimpleName nameNode, IProgressMonitor monitor) throws JavaScriptModelException {
        boolean is50OrHigher = JavaModelUtil.is50OrHigher(this.fCompilationUnit.getJavaScriptProject());
        int typeKinds = 126;
        if (nameNode != null) {
            typeKinds = ASTResolving.getPossibleTypeKinds((ASTNode)nameNode, is50OrHigher);
        }
        ArrayList typeInfos = new ArrayList();
        TypeNameMatchCollector requestor = new TypeNameMatchCollector(typeInfos);
        int matchMode = 8;
        new SearchEngine().searchAllTypeNames(null, matchMode, simpleTypeName.toCharArray(), matchMode, this.getSearchForConstant(typeKinds), searchScope, (TypeNameMatchRequestor)requestor, 3, monitor);
        ArrayList<TypeNameMatch> typeRefsFound = new ArrayList<TypeNameMatch>(typeInfos.size());
        int i = 0;
        int len = typeInfos.size();
        while (i < len) {
            TypeNameMatch curr = (TypeNameMatch)typeInfos.get(i);
            if (curr.getPackageName().length() > 0 && this.isOfKind(curr, typeKinds, is50OrHigher) && this.isVisible(curr)) {
                typeRefsFound.add(curr);
            }
            ++i;
        }
        return typeRefsFound.toArray(new TypeNameMatch[typeRefsFound.size()]);
    }

    private boolean isOfKind(TypeNameMatch curr, int typeKinds, boolean is50OrHigher) {
        return (typeKinds & 2) != 0;
    }

    private boolean isVisible(TypeNameMatch curr) {
        int flags = curr.getModifiers();
        if (Flags.isPrivate((int)flags)) {
            return false;
        }
        if (Flags.isPublic((int)flags)) {
            return true;
        }
        return curr.getPackageName().equals(this.fCompilationUnit.getParent().getElementName());
    }

    public ISchedulingRule getScheduleRule() {
        return this.fCompilationUnit.getJavaScriptProject().getResource();
    }

    public static interface IChooseImportQuery {
        public TypeNameMatch chooseImport(TypeNameMatch[] var1, String var2);
    }
}

