/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;

public class ClasspathShortener {
    private static final String CLASSPATH_ENV_VAR_PREFIX = "CLASSPATH=";
    public static final int ARG_MAX_LINUX = 0x200000;
    public static final int ARG_MAX_WINDOWS = Short.MAX_VALUE;
    public static final int ARG_MAX_MACOS = 262144;
    public static final int MAX_ARG_STRLEN_LINUX = 131072;
    private final String os;
    private final String javaVersion;
    private final ILaunch launch;
    private final List<String> cmdLine;
    private int lastJavaArgumentIndex;
    private String[] envp;
    private File processTempFilesDir;
    private final List<File> processTempFiles = new ArrayList<File>();

    public ClasspathShortener(IVMInstall vmInstall, ILaunch launch, String[] cmdLine, int lastJavaArgumentIndex, File workingDir, String[] envp) {
        this(Platform.getOS(), ClasspathShortener.getJavaVersion(vmInstall), launch, cmdLine, lastJavaArgumentIndex, workingDir, envp);
    }

    protected ClasspathShortener(String os, String javaVersion, ILaunch launch, String[] cmdLine, int lastJavaArgumentIndex, File workingDir, String[] envp) {
        Assert.isNotNull((Object)os);
        Assert.isNotNull((Object)javaVersion);
        Assert.isNotNull((Object)launch);
        Assert.isNotNull((Object)cmdLine);
        this.os = os;
        this.javaVersion = javaVersion;
        this.launch = launch;
        this.cmdLine = new ArrayList<String>(Arrays.asList(cmdLine));
        this.lastJavaArgumentIndex = lastJavaArgumentIndex;
        this.envp = envp == null ? null : Arrays.copyOf(envp, envp.length);
        this.processTempFilesDir = workingDir != null ? workingDir : Paths.get(".", new String[0]).toAbsolutePath().normalize().toFile();
    }

    public void setProcessTempFilesDir(File processTempFilesDir) {
        this.processTempFilesDir = processTempFilesDir;
    }

    public File getProcessTempFilesDir() {
        return this.processTempFilesDir;
    }

    public String[] getEnvp() {
        return this.envp;
    }

    public String[] getCmdLine() {
        return this.cmdLine.toArray(new String[this.cmdLine.size()]);
    }

    public List<File> getProcessTempFiles() {
        return new ArrayList<File>(this.processTempFiles);
    }

    public boolean shortenCommandLineIfNecessary() {
        return this.shortenClasspathIfNecessary() | this.shortenModulePathIfNecessary();
    }

    private int getClasspathArgumentIndex() {
        int i = 0;
        while (i <= this.lastJavaArgumentIndex) {
            String element = this.cmdLine.get(i);
            if ("-cp".equals(element) || "-classpath".equals(element) || "--class-path".equals(element)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    private int getModulepathArgumentIndex() {
        int i = 0;
        while (i <= this.lastJavaArgumentIndex) {
            String element = this.cmdLine.get(i);
            if ("-p".equals(element) || "--module-path".equals(element)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    private boolean shortenModulePathIfNecessary() {
        int modulePathArgumentIndex;
        block5: {
            modulePathArgumentIndex = this.getModulepathArgumentIndex();
            if (modulePathArgumentIndex == -1) {
                return false;
            }
            String modulePath = this.cmdLine.get(modulePathArgumentIndex);
            if (this.getCommandLineLength() > this.getMaxCommandLineLength() || modulePath.length() > this.getMaxArgLength()) break block5;
            return false;
        }
        try {
            if (this.isArgumentFileSupported()) {
                this.shortenModulePathUsingModulePathArgumentFile(modulePathArgumentIndex);
                return true;
            }
        }
        catch (CoreException e) {
            LaunchingPlugin.log(e.getStatus());
        }
        return false;
    }

    private boolean shortenClasspathIfNecessary() {
        int classpathArgumentIndex;
        block11: {
            block10: {
                block9: {
                    block8: {
                        classpathArgumentIndex = this.getClasspathArgumentIndex();
                        if (classpathArgumentIndex == -1) {
                            return false;
                        }
                        boolean forceUseClasspathOnlyJar = this.getLaunchConfigurationUseClasspathOnlyJarAttribute();
                        if (!forceUseClasspathOnlyJar) break block8;
                        this.shortenClasspathUsingClasspathOnlyJar(classpathArgumentIndex);
                        return true;
                    }
                    String classpath = this.cmdLine.get(classpathArgumentIndex);
                    if (this.getCommandLineLength() > this.getMaxCommandLineLength() || classpath.length() > this.getMaxArgLength()) break block9;
                    return false;
                }
                if (!this.isArgumentFileSupported()) break block10;
                this.shortenClasspathUsingClasspathArgumentFile(classpathArgumentIndex);
                return true;
            }
            if (!this.os.equals("win32")) break block11;
            this.shortenClasspathUsingClasspathEnvVariable(classpathArgumentIndex);
            return true;
        }
        try {
            if (this.handleClasspathTooLongStatus()) {
                this.shortenClasspathUsingClasspathOnlyJar(classpathArgumentIndex);
                return true;
            }
        }
        catch (CoreException e) {
            LaunchingPlugin.log(e.getStatus());
        }
        return false;
    }

    protected boolean getLaunchConfigurationUseClasspathOnlyJarAttribute() throws CoreException {
        ILaunchConfiguration launchConfiguration = this.launch.getLaunchConfiguration();
        if (launchConfiguration == null) {
            return false;
        }
        return launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_CLASSPATH_ONLY_JAR, false);
    }

    public static String getJavaVersion(IVMInstall vmInstall) {
        if (vmInstall instanceof IVMInstall2) {
            IVMInstall2 install = (IVMInstall2)((Object)vmInstall);
            return install.getJavaVersion();
        }
        return null;
    }

    private boolean isArgumentFileSupported() {
        return JavaCore.compareJavaVersions((String)this.javaVersion, (String)"9") >= 0;
    }

    private int getCommandLineLength() {
        return this.cmdLine.stream().map(argument -> argument.length() + 1).reduce((a, b) -> a + b).get();
    }

    private int getEnvironmentLength() {
        if (this.envp == null) {
            return 0;
        }
        return Arrays.stream(this.envp).map(element -> element.length() + 1).reduce((a, b) -> a + b).orElse(0);
    }

    protected int getMaxCommandLineLength() {
        switch (this.os) {
            case "linux": {
                return 0x200000 - this.getEnvironmentLength() - 2048;
            }
            case "macosx": {
                return 262144 - this.getEnvironmentLength() - 2048;
            }
            case "win32": {
                return 30719;
            }
        }
        return Integer.MAX_VALUE;
    }

    protected int getMaxArgLength() {
        if (this.os.equals("linux")) {
            return 129024;
        }
        return Integer.MAX_VALUE;
    }

    private void shortenClasspathUsingClasspathArgumentFile(int classpathArgumentIndex) throws CoreException {
        String classpath = this.cmdLine.get(classpathArgumentIndex);
        File file = this.createClassPathArgumentFile(classpath);
        this.removeCmdLineArgs(classpathArgumentIndex - 1, 2);
        this.addCmdLineArgs(classpathArgumentIndex - 1, String.valueOf('@') + file.getAbsolutePath());
        this.addProcessTempFile(file);
    }

    private void shortenModulePathUsingModulePathArgumentFile(int modulePathArgumentIndex) throws CoreException {
        String modulePath = this.cmdLine.get(modulePathArgumentIndex);
        File file = this.createModulePathArgumentFile(modulePath);
        this.removeCmdLineArgs(modulePathArgumentIndex - 1, 2);
        this.addCmdLineArgs(modulePathArgumentIndex - 1, String.valueOf('@') + file.getAbsolutePath());
        this.addProcessTempFile(file);
    }

    private void shortenClasspathUsingClasspathOnlyJar(int classpathArgumentIndex) throws CoreException {
        String classpath = this.cmdLine.get(classpathArgumentIndex);
        File classpathOnlyJar = this.createClasspathOnlyJar(classpath);
        this.removeCmdLineArgs(classpathArgumentIndex, 1);
        this.addCmdLineArgs(classpathArgumentIndex, classpathOnlyJar.getAbsolutePath());
        this.addProcessTempFile(classpathOnlyJar);
    }

    protected void addProcessTempFile(File file) {
        this.processTempFiles.add(file);
    }

    protected boolean handleClasspathTooLongStatus() throws CoreException {
        Status status = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 125, "", null);
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
        if (handler == null) {
            return false;
        }
        Object result = handler.handleStatus((IStatus)status, (Object)this.launch);
        if (!(result instanceof Boolean)) {
            return false;
        }
        return (Boolean)result;
    }

    private File createClasspathOnlyJar(String classpath) throws CoreException {
        try {
            String timeStamp = this.getLaunchTimeStamp();
            File jarFile = new File(this.processTempFilesDir, String.format(".temp-%s-classpathOnly-%s.jar", this.getLaunchConfigurationName(), timeStamp));
            URI workingDirUri = this.processTempFilesDir.toURI();
            StringBuilder manifestClasspath = new StringBuilder();
            String[] classpathArray = this.getClasspathAsArray(classpath);
            int i = 0;
            while (i < classpathArray.length) {
                if (i != 0) {
                    manifestClasspath.append(' ');
                }
                File file = new File(classpathArray[i]);
                String relativePath = URIUtil.makeRelative((URI)file.toURI(), (URI)workingDirUri).toString();
                manifestClasspath.append(relativePath);
                ++i;
            }
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, manifestClasspath.toString());
            Throwable throwable = null;
            Object var9_11 = null;
            try {
                JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
                if (target != null) {
                    target.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return jarFile;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, "Cannot create classpath only jar", (Throwable)e));
        }
    }

    private String[] getClasspathAsArray(String classpath) {
        return classpath.split("" + this.getPathSeparatorChar());
    }

    protected char getPathSeparatorChar() {
        char separator = ':';
        if (this.os.equals("win32")) {
            separator = ';';
        }
        return separator;
    }

    protected String getLaunchConfigurationName() {
        return this.launch.getLaunchConfiguration().getName();
    }

    private File createClassPathArgumentFile(String classpath) throws CoreException {
        try {
            String timeStamp = this.getLaunchTimeStamp();
            File classPathFile = new File(this.processTempFilesDir, String.format(".temp-%s-classpath-arg-%s.txt", this.getLaunchConfigurationName(), timeStamp));
            byte[] bytes = ("-classpath " + this.quoteWindowsPath(classpath)).getBytes(StandardCharsets.UTF_8);
            Files.write(classPathFile.toPath(), bytes, new OpenOption[0]);
            return classPathFile;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, "Cannot create classpath argument file", (Throwable)e));
        }
    }

    private File createModulePathArgumentFile(String modulePath) throws CoreException {
        try {
            String timeStamp = this.getLaunchTimeStamp();
            File modulePathFile = new File(this.processTempFilesDir, String.format(".temp-%s-module-path-arg-%s.txt", this.getLaunchConfigurationName(), timeStamp));
            byte[] bytes = ("--module-path " + this.quoteWindowsPath(modulePath)).getBytes(StandardCharsets.UTF_8);
            Files.write(modulePathFile.toPath(), bytes, new OpenOption[0]);
            return modulePathFile;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 4, "Cannot create module-path argument file", (Throwable)e));
        }
    }

    protected String getLaunchTimeStamp() {
        String timeStamp = this.launch.getAttribute("org.eclipse.debug.core.launch.timestamp");
        if (timeStamp == null) {
            timeStamp = Long.toString(System.currentTimeMillis());
        }
        return timeStamp;
    }

    private String[] getEnvpFromNativeEnvironment() {
        Map<String, String> nativeEnvironment = this.getNativeEnvironment();
        String[] envp = new String[nativeEnvironment.size()];
        int idx = 0;
        for (Map.Entry<String, String> entry : nativeEnvironment.entrySet()) {
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            String key = entry.getKey();
            envp[idx] = String.valueOf(key) + '=' + value;
            ++idx;
        }
        return envp;
    }

    protected Map<String, String> getNativeEnvironment() {
        return DebugPlugin.getDefault().getLaunchManager().getNativeEnvironment();
    }

    private void shortenClasspathUsingClasspathEnvVariable(int classpathArgumentIndex) {
        String classpath = this.cmdLine.get(classpathArgumentIndex);
        if (this.envp == null) {
            this.envp = this.getEnvpFromNativeEnvironment();
        }
        String classpathEnvVar = CLASSPATH_ENV_VAR_PREFIX + this.quoteWindowsPath(classpath);
        int index = this.getEnvClasspathIndex(this.envp);
        if (index < 0) {
            this.envp = Arrays.copyOf(this.envp, this.envp.length + 1);
            this.envp[this.envp.length - 1] = classpathEnvVar;
        } else {
            this.envp[index] = classpathEnvVar;
        }
        this.removeCmdLineArgs(classpathArgumentIndex - 1, 2);
    }

    private void removeCmdLineArgs(int index, int length) {
        int i = 0;
        while (i < length) {
            this.cmdLine.remove(index);
            --this.lastJavaArgumentIndex;
            ++i;
        }
    }

    private void addCmdLineArgs(int index, String ... newArgs) {
        this.cmdLine.addAll(index, Arrays.asList(newArgs));
        this.lastJavaArgumentIndex += newArgs.length;
    }

    private int getEnvClasspathIndex(String[] env) {
        if (env != null) {
            int i = 0;
            while (i < env.length) {
                if (env[i].regionMatches(true, 0, CLASSPATH_ENV_VAR_PREFIX, 0, 10)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public String quoteWindowsPath(String path) {
        if (this.os.equals("win32")) {
            return "\"" + path + "\"";
        }
        return path;
    }
}

