/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.resources.ISystemMountPathMapper;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.files.ui.resources.UniversalFileTransferUtility;
import org.eclipse.rse.internal.files.ui.resources.DefaultMountPathMapper;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFile;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class SystemRemoteEditManager {
    public static final String REMOTE_EDIT_PROJECT_NAME = "RemoteSystemsTempFiles";
    public static final String REMOTE_EDIT_PROJECT_NATURE_ID = "org.eclipse.rse.ui.remoteSystemsTempNature";
    public static final String REMOTE_EDIT_PROJECT_BUILDER_ID = "org.eclipse.rse.ui.remoteSystemsTempBuilder";
    private static SystemRemoteEditManager inst;
    private List _mountPathMappers;
    static /* synthetic */ Class class$0;

    private SystemRemoteEditManager() {
        this.registerMountPathMappers();
    }

    public static SystemRemoteEditManager getInstance() {
        if (inst == null) {
            inst = new SystemRemoteEditManager();
        }
        return inst;
    }

    public String getActualHostFor(String hostname, String remotePath, IRemoteFileSubSystem subsystem) {
        ISystemMountPathMapper mapper = this.getMountPathMapperFor(hostname, remotePath, subsystem);
        if (mapper != null) {
            return mapper.getActualHostFor(hostname, remotePath);
        }
        return hostname;
    }

    public String getMountPathFor(String hostname, String remotePath, IRemoteFileSubSystem subsystem) {
        ISystemMountPathMapper mapper = this.getMountPathMapperFor(hostname, remotePath, subsystem);
        if (mapper != null) {
            return mapper.getMountedMappingFor(hostname, remotePath);
        }
        return remotePath;
    }

    public String getWorkspacePathFor(String hostname, String remotePath, IRemoteFileSubSystem subsystem) {
        ISystemMountPathMapper mapper = this.getMountPathMapperFor(hostname, remotePath, subsystem);
        if (mapper != null) {
            return mapper.getWorkspaceMappingFor(hostname, remotePath, subsystem);
        }
        return remotePath;
    }

    public ISystemMountPathMapper getMountPathMapperFor(String hostname, String remotePath, IRemoteFileSubSystem subsystem) {
        ISystemMountPathMapper result = null;
        int i = 0;
        while (i < this._mountPathMappers.size()) {
            ISystemMountPathMapper mapper = (ISystemMountPathMapper)this._mountPathMappers.get(i);
            if (mapper != null && mapper.handlesMappingFor(hostname, remotePath, subsystem)) {
                if (result == null) {
                    result = mapper;
                } else if (mapper.getPriority(hostname, remotePath, subsystem) < result.getPriority(hostname, remotePath, subsystem)) {
                    result = mapper;
                }
            }
            ++i;
        }
        if (result == null) {
            return new DefaultMountPathMapper();
        }
        return result;
    }

    protected void registerMountPathMappers() {
        this._mountPathMappers = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] systemTypeExtensions = registry.getConfigurationElementsFor("org.eclipse.rse.ui", "mountPathMappers");
        int i = 0;
        while (i < systemTypeExtensions.length) {
            try {
                this._mountPathMappers.add(systemTypeExtensions[i].createExecutableExtension("class"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public boolean doesRemoteEditProjectExist() {
        IWorkspaceRoot root = SystemBasePlugin.getWorkspaceRoot();
        IProject editProject = root.getProject(REMOTE_EDIT_PROJECT_NAME);
        return editProject != null && editProject.exists() && editProject.isOpen();
    }

    public IProject getRemoteEditProject() {
        IWorkspaceRoot root = SystemBasePlugin.getWorkspaceRoot();
        IProject editProject = root.getProject(REMOTE_EDIT_PROJECT_NAME);
        if (editProject != null && editProject.exists() && editProject.isOpen()) {
            return editProject;
        }
        if (editProject == null || !editProject.exists() || !editProject.isOpen()) {
            editProject = this.createRemoteEditProject();
        }
        return editProject;
    }

    private IProject createRemoteEditProject() {
        IProject editProject;
        block8: {
            IWorkspaceRoot root = SystemBasePlugin.getWorkspaceRoot();
            editProject = root.getProject(REMOTE_EDIT_PROJECT_NAME);
            if (editProject != null && editProject.exists() && editProject.isOpen()) {
                return editProject;
            }
            try {
                if (editProject == null) break block8;
                NullProgressMonitor monitor = new NullProgressMonitor();
                if (!editProject.exists()) {
                    editProject.create((IProgressMonitor)monitor);
                }
                if (!editProject.isOpen()) {
                    try {
                        editProject.open((IProgressMonitor)monitor);
                    }
                    catch (CoreException e) {
                        editProject.delete(true, (IProgressMonitor)monitor);
                        editProject.create((IProgressMonitor)monitor);
                        editProject.open((IProgressMonitor)monitor);
                    }
                }
                IProjectDescription description = editProject.getDescription();
                String[] natures = description.getNatureIds();
                String[] newNatures = new String[natures.length + 1];
                int i = 0;
                while (i < natures.length) {
                    newNatures[i] = natures[i];
                    ++i;
                }
                newNatures[newNatures.length - 1] = REMOTE_EDIT_PROJECT_NATURE_ID;
                description.setNatureIds(newNatures);
                editProject.setDescription(description, null);
            }
            catch (CoreException e) {
                SystemBasePlugin.logError((String)"Error creating temp project", (Throwable)e);
            }
        }
        return editProject;
    }

    public IPath getRemoteEditProjectLocation() {
        return this.getRemoteEditProject().getLocation();
    }

    public String getRemoteEditProjectAbsolutePath() {
        return this.getRemoteEditProjectLocation().makeAbsolute().toOSString();
    }

    protected int caculateCacheSize() {
        if (!this.doesRemoteEditProjectExist()) {
            return 0;
        }
        IProject project = this.getRemoteEditProject();
        String path = project.getLocation().toOSString();
        File file = new File(path);
        return this.calculateSize(file);
    }

    private int calculateSize(File file) {
        int size = 0;
        if (file.isFile()) {
            size = (int)file.length();
        } else if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                size += this.calculateSize(children[i]);
                ++i;
            }
        }
        return size;
    }

    protected IFile getLeastRecentlyChangedFile(List deletedList) {
        if (!this.doesRemoteEditProjectExist()) {
            return null;
        }
        IProject project = this.getRemoteEditProject();
        IFile result = this.getLeastRecentlyChangedFile((IContainer)project, deletedList);
        deletedList.add(result);
        return result;
    }

    private IFile getLeastRecentlyChangedFile(IContainer file, List deletedList) {
        IFile result = null;
        try {
            IResource[] children = file.members();
            int i = 0;
            while (i < children.length) {
                IFile candidate = null;
                IResource child = children[i];
                if (child instanceof IFolder) {
                    if (!child.getName().equals(".settings")) {
                        candidate = this.getLeastRecentlyChangedFile((IContainer)((IFolder)child), deletedList);
                    }
                } else {
                    candidate = (IFile)child;
                }
                if (!(candidate == null || deletedList.contains(candidate) || candidate.getName().startsWith(".") || this.isFileInUse(candidate, true))) {
                    if (result == null) {
                        result = candidate;
                    } else if (candidate.getLocation().toFile().lastModified() < result.getLocation().toFile().lastModified()) {
                        result = candidate;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public ISystemEditableRemoteObject getEditableFor(IFile fileToDelete, boolean quickCheck) {
        SystemIFileProperties properties = new SystemIFileProperties((IResource)fileToDelete);
        Object object = properties.getRemoteFileObject();
        if (object != null) {
            ISystemEditableRemoteObject editableFile = (ISystemEditableRemoteObject)object;
            return editableFile;
        }
        if (!quickCheck) {
            ISubSystem subsystem;
            String subsystemStr = properties.getRemoteFileSubSystem();
            String pathStr = properties.getRemoteFilePath();
            if (subsystemStr != null && pathStr != null && (subsystem = RSECorePlugin.getTheSystemRegistry().getSubSystem(subsystemStr)) != null) {
                Object rmtObject = null;
                try {
                    rmtObject = subsystem.getObjectWithAbsoluteName(pathStr, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    return null;
                }
                if (rmtObject != null && rmtObject instanceof IAdaptable) {
                    ISystemRemoteElementAdapter adapter;
                    IAdaptable iAdaptable = (IAdaptable)rmtObject;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapter = (ISystemRemoteElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                        return adapter.getEditableRemoteObject(rmtObject);
                    }
                }
            }
        }
        return null;
    }

    public boolean isFileInUse(IFile fileToDelete, boolean quickCheck) {
        SystemIFileProperties properties = new SystemIFileProperties((IResource)fileToDelete);
        boolean isDirty = properties.getDirty();
        if (isDirty) {
            return true;
        }
        ISystemEditableRemoteObject editable = this.getEditableFor(fileToDelete, quickCheck);
        if (editable != null && quickCheck) {
            return true;
        }
        if (editable != null) {
            try {
                boolean result;
                boolean bl = result = editable.checkOpenInEditor() == -1;
                if (!result) {
                    return !result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    protected void cleanupCache() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        boolean enableMaxSize = store.getBoolean("org.eclipse.rse.subsystems.files.core.preferences.limit.cache");
        if (enableMaxSize) {
            int max = Integer.parseInt("512") * 1000000;
            try {
                String maxSize = store.getString("org.eclipse.rse.subsystems.files.core.preferences.max.cache.size");
                if (maxSize != null && !maxSize.equals("")) {
                    max = Integer.parseInt(maxSize) * 1000000;
                }
            }
            catch (NumberFormatException nfe) {
                SystemBasePlugin.logError((String)"Could not get max cache size", (Throwable)nfe);
                max = Integer.parseInt("512") * 1000000;
            }
            try {
                int currentSize = this.caculateCacheSize();
                if (currentSize > max) {
                    int delta = currentSize - max;
                    ArrayList deletedList = new ArrayList();
                    while (delta > 0) {
                        IFile leastRecent = this.getLeastRecentlyChangedFile(deletedList);
                        if (leastRecent != null) {
                            File theFile = leastRecent.getLocation().toFile();
                            int sizeSaved = (int)theFile.length();
                            Display.getDefault().asyncExec((Runnable)new DeleteFileRunnable(leastRecent));
                            delta -= sizeSaved;
                            continue;
                        }
                        delta = 0;
                    }
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"Error occured trying to clean cache", (Throwable)e);
            }
        }
    }

    public void refreshRemoteEditProject() {
        if (!this.doesRemoteEditProjectExist()) {
            return;
        }
        try {
            IProject project = this.getRemoteEditProject();
            if (!project.getWorkspace().isTreeLocked()) {
                this.cleanupCache();
                project.refreshLocal(2, null);
            }
        }
        catch (Exception e) {
            SystemBasePlugin.logError((String)"Error refreshing remote edit project", (Throwable)e);
        }
    }

    public void refreshRemoteEditContainer(IContainer parent) {
        if (!this.doesRemoteEditProjectExist()) {
            return;
        }
        try {
            IProject project = this.getRemoteEditProject();
            if (!project.getWorkspace().isTreeLocked()) {
                this.cleanupCache();
                parent.refreshLocal(1, null);
            }
        }
        catch (Exception e) {
            SystemBasePlugin.logError((String)"Error refreshing remote edit project", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SystemEditableRemoteFile getEditableRemoteObject(Object element, IEditorDescriptor descriptor) {
        SystemEditableRemoteFile editable = null;
        RemoteFile remoteFile = (RemoteFile)element;
        if (!remoteFile.isFile()) return editable;
        try {
            SystemIFileProperties properties;
            Object obj;
            IFile file = (IFile)UniversalFileTransferUtility.getTempFileFor((IRemoteFile)remoteFile);
            if (file != null && (obj = (properties = new SystemIFileProperties((IResource)file)).getRemoteFileObject()) != null && obj instanceof SystemEditableRemoteFile) {
                editable = (SystemEditableRemoteFile)obj;
                String remotePath = remoteFile.getAbsolutePath();
                String replicaRemotePath = editable.getAbsolutePath();
                if (replicaRemotePath.equals(remotePath)) {
                    if (descriptor == null) return editable;
                    editable.setEditorDescriptor(descriptor);
                    return editable;
                }
                IEditorPart editor = editable.getEditorPart();
                boolean editorWasClosed = false;
                if (editor.isDirty()) {
                    editorWasClosed = editor.getEditorSite().getPage().closeEditor(editor, true);
                    if (editorWasClosed) {
                        editable.doImmediateSaveAndUpload();
                    }
                } else {
                    editorWasClosed = editor.getEditorSite().getPage().closeEditor(editor, true);
                }
                if (!editorWasClosed) {
                    return null;
                }
                try {
                    IFile originalFile = editable.getLocalResource();
                    originalFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }
            if (descriptor == null) return new SystemEditableRemoteFile((IRemoteFile)remoteFile);
            return new SystemEditableRemoteFile((IRemoteFile)remoteFile, descriptor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return editable;
    }

    public class DeleteFileRunnable
    implements Runnable {
        private IFile _theFile;

        public DeleteFileRunnable(IFile theFile) {
            this._theFile = theFile;
        }

        public void run() {
            if (!this.inUse()) {
                this._theFile.getLocation().toFile().delete();
            }
        }

        public boolean inUse() {
            if (!SystemRemoteEditManager.this.doesRemoteEditProjectExist()) {
                return false;
            }
            IWorkbenchWindow activeWindow = SystemBasePlugin.getActiveWorkbenchWindow();
            IWorkbenchPage activePage = activeWindow.getActivePage();
            IEditorReference[] activeReferences = activePage.getEditorReferences();
            int k = 0;
            while (k < activeReferences.length) {
                IFile file;
                IEditorInput editorInput;
                IEditorPart part = activeReferences[k].getEditor(true);
                if (part != null && (editorInput = part.getEditorInput()) instanceof IFileEditorInput && (file = ((IFileEditorInput)editorInput).getFile()).equals((Object)this._theFile)) {
                    return true;
                }
                ++k;
            }
            return false;
        }
    }
}

