/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core;

import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.osgi.util.NLS;

public class CommonListenerList<T>
implements Iterable<T> {
    private final CopyOnWriteArrayList<T> listeners;
    private final String pluginId;

    public CommonListenerList(String pluginId) {
        Assert.isNotNull((Object)pluginId);
        this.pluginId = pluginId;
        this.listeners = new CopyOnWriteArrayList();
    }

    public void add(T listener) {
        Assert.isNotNull(listener);
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public Iterator<T> iterator() {
        return this.listeners.iterator();
    }

    public void notify(final Notifier<T> runnable) {
        for (final T listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, CommonListenerList.this.pluginId, NLS.bind((String)"Unexpected error notifying listener {0}", listener.getClass()), e));
                    CommonListenerList.this.remove(listener);
                }

                public void run() throws Exception {
                    runnable.run(listener);
                }
            });
        }
    }

    public void remove(T listener) {
        this.listeners.remove(listener);
    }

    public static abstract class Notifier<T> {
        public abstract void run(T var1) throws Exception;
    }
}

