/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.base.util.EAnnotations;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnablementDialog
extends AbstractSetupDialog {
    private static final String TITLE = "Oomph Extension Installation";
    private final EClass eClass;
    private final String typeText;
    private final EList<SetupTask> enablementTasks;
    private final String defaultImageKey;
    private ComposedAdapterFactory adapterFactory;

    public EnablementDialog(Shell parentShell, EClass eClass, String typeText, EList<SetupTask> enablementTasks, String defaultImageKey) {
        super(parentShell, TITLE, 650, 400, (OomphUIPlugin)SetupEditorPlugin.INSTANCE, false);
        this.eClass = eClass;
        this.typeText = typeText;
        this.enablementTasks = enablementTasks;
        this.defaultImageKey = defaultImageKey;
        this.adapterFactory = BaseEditUtil.createAdapterFactory();
    }

    public boolean close() {
        this.adapterFactory.dispose();
        return super.close();
    }

    protected String getShellText() {
        return TITLE;
    }

    protected String getDefaultMessage() {
        return "Review the extension details and press Install to proceed with the installation.";
    }

    protected int getContainerMargin() {
        return 10;
    }

    protected void createUI(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        ItemProvider input = this.createTreeViewerInput();
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)UIUtil.createGridLayout((int)2));
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        final Label extensionImageLabel = new Label(mainComposite, 0);
        extensionImageLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        extensionImageLabel.setImage(SetupEditorPlugin.INSTANCE.getSWTImage(this.defaultImageKey));
        Label extensionTextLabel = new Label(mainComposite, 0);
        extensionTextLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        extensionTextLabel.setText("Install " + this.typeText + " extension:");
        final TreeViewer treeViewer = new TreeViewer(mainComposite, 2048);
        treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        treeViewer.setInput((Object)input);
        UIUtil.asyncExec((Runnable)new Runnable(){

            public void run() {
                treeViewer.expandAll();
                Job iconLoader = new Job("IconLoader"){

                    protected IStatus run(IProgressMonitor monitor) {
                        URI imageURI = EAnnotations.getImageURI((EClass)EnablementDialog.this.eClass);
                        if (imageURI != null) {
                            final Image image = ExtendedImageRegistry.INSTANCE.getImage(BaseEditUtil.getImage((URI)imageURI));
                            UIUtil.asyncExec((Runnable)new Runnable(){

                                public void run() {
                                    extensionImageLabel.setImage(image);
                                }
                            });
                        }
                        return Status.OK_STATUS;
                    }
                };
                iconLoader.setSystem(true);
                iconLoader.schedule();
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Install", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private ItemProvider createTreeViewerInput() {
        HashMap requirements = new HashMap();
        ArrayList extraRequirements = new ArrayList();
        int size = this.enablementTasks.size();
        int i = 0;
        while (i < size) {
            SetupTask task = (SetupTask)this.enablementTasks.get(i);
            if (task instanceof P2Task) {
                P2Task p2Task = (P2Task)task;
                EList repositories = p2Task.getRepositories();
                if (repositories.isEmpty()) {
                    extraRequirements.addAll(p2Task.getRequirements());
                } else {
                    VariableTask variableTask;
                    SetupTask nextTask;
                    Repository repository = (Repository)repositories.get(0);
                    String url = repository.getURL();
                    if (url.startsWith("${") && i + 1 < size && (nextTask = (SetupTask)this.enablementTasks.get(i + 1)) instanceof VariableTask && url.equals("${" + (variableTask = (VariableTask)nextTask).getName() + "}")) {
                        url = variableTask.getValue();
                    }
                    if (url.equals("${oomph.update.url}")) {
                        url = SetupCorePlugin.UPDATE_URL;
                    }
                    CollectionUtil.addAll(requirements, (Object)url, (Collection)p2Task.getRequirements());
                }
            }
            ++i;
        }
        ArrayList urls = new ArrayList(requirements.keySet());
        Collections.sort(urls);
        ItemProvider input = new ItemProvider((AdapterFactory)this.adapterFactory);
        EList children = input.getChildren();
        Image repositoryImage = SetupEditorPlugin.INSTANCE.getSWTImage("full/obj16/Repository");
        for (String url : urls) {
            ItemProvider repository = new ItemProvider(url, (Object)repositoryImage);
            repository.getChildren().addAll((Collection)requirements.get(url));
            children.add((Object)repository);
        }
        children.addAll(extraRequirements);
        return input;
    }
}

