/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry.compression;

import com.sun.j3d.utils.geometry.compression.CompressedGeometryData;

class CompressedGeometryRetained {
    private static final int HEADER_LENGTH = 48;
    private static final int HEADER_MAJOR_VERSION_OFFSET = 0;
    private static final int HEADER_MINOR_VERSION_OFFSET = 1;
    private static final int HEADER_MINOR_MINOR_VERSION_OFFSET = 2;
    private static final int HEADER_BUFFER_TYPE_OFFSET = 3;
    private static final int HEADER_BUFFER_DATA_OFFSET = 4;
    static final byte TYPE_POINT = 1;
    static final byte TYPE_LINE = 2;
    static final byte TYPE_TRIANGLE = 4;
    int majorVersionNumber;
    int minorVersionNumber;
    int minorMinorVersionNumber;
    int packedVersion;
    int bufferType;
    int bufferContents;
    int renderFlags;
    int offset;
    int size;
    byte[] compressedGeometry;
    private byte[] originalCompressedGeometry = null;
    private boolean byReference = false;

    CompressedGeometryRetained() {
    }

    boolean isByReference() {
        return this.byReference;
    }

    private void createByCopy(byte[] byArray) {
        this.compressedGeometry = new byte[48 + this.size];
        this.compressedGeometry[0] = (byte)this.majorVersionNumber;
        this.compressedGeometry[1] = (byte)this.minorVersionNumber;
        this.compressedGeometry[2] = (byte)this.minorMinorVersionNumber;
        this.compressedGeometry[3] = (byte)this.bufferType;
        this.compressedGeometry[4] = (byte)this.bufferContents;
        System.arraycopy(byArray, this.offset, this.compressedGeometry, 48, this.size);
        this.offset = 48;
    }

    void createCompressedGeometry(CompressedGeometryData.Header header, byte[] byArray, boolean bl) {
        this.byReference = bl;
        this.majorVersionNumber = header.majorVersionNumber;
        this.minorVersionNumber = header.minorVersionNumber;
        this.minorMinorVersionNumber = header.minorMinorVersionNumber;
        this.packedVersion = header.majorVersionNumber << 24 | header.minorVersionNumber << 16 | header.minorMinorVersionNumber << 8;
        switch (header.bufferType) {
            case 0: {
                this.bufferType = 1;
                break;
            }
            case 1: {
                this.bufferType = 2;
                break;
            }
            case 2: {
                this.bufferType = 4;
            }
        }
        this.bufferContents = header.bufferDataPresent;
        this.renderFlags = 0;
        this.size = header.size;
        this.offset = header.start;
        if (bl) {
            this.compressedGeometry = byArray;
            this.originalCompressedGeometry = byArray;
        } else {
            this.createByCopy(byArray);
            this.originalCompressedGeometry = null;
        }
    }

    int getVertexFormat() {
        int n = 1;
        if ((this.bufferContents & 1) != 0) {
            n |= 2;
        }
        if ((this.bufferContents & 2) != 0) {
            n = (this.bufferContents & 4) != 0 ? (n |= 0xC) : (n |= 4);
        }
        return n;
    }

    int getBufferType() {
        switch (this.bufferType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 2;
    }

    void copy(byte[] byArray) {
        System.arraycopy(this.compressedGeometry, this.offset, byArray, 0, this.size);
    }

    byte[] getReference() {
        return this.originalCompressedGeometry;
    }
}

