/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.util.ArrayList;
import java.util.List;
import net.osmand.data.MapObject;
import net.osmand.data.TransportStop;
import net.osmand.util.MapUtils;

public class TransportRoute
extends MapObject {
    private List<TransportStop> forwardStops = new ArrayList<TransportStop>();
    private List<TransportStop> backwardStops = new ArrayList<TransportStop>();
    private String ref;
    private String operator;
    private String type;
    private Integer dist = null;

    public List<TransportStop> getForwardStops() {
        return this.forwardStops;
    }

    public List<TransportStop> getBackwardStops() {
        return this.backwardStops;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getDistance() {
        if (this.dist == null) {
            this.dist = this.getAvgBothDistance();
        }
        return this.dist;
    }

    public void setDistance(Integer dist) {
        this.dist = dist;
    }

    public int getAvgBothDistance() {
        int i;
        int d = 0;
        int bSsize = this.backwardStops.size();
        int fSsize = this.forwardStops.size();
        for (i = 1; i < bSsize; ++i) {
            d = (int)((double)d + MapUtils.getDistance(this.backwardStops.get(i - 1).getLocation(), this.backwardStops.get(i).getLocation()));
        }
        for (i = 1; i < fSsize; ++i) {
            d = (int)((double)d + MapUtils.getDistance(this.forwardStops.get(i - 1).getLocation(), this.forwardStops.get(i).getLocation()));
        }
        return d;
    }
}

