/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.ErrorRateTooHighException;
import org.languagetool.Experimental;
import org.languagetool.GlobalConfig;
import org.languagetool.InputSentence;
import org.languagetool.Language;
import org.languagetool.ResourceBundleTools;
import org.languagetool.ResultCache;
import org.languagetool.RuleCheckTimeMessage;
import org.languagetool.RuleLoggerManager;
import org.languagetool.RuleMatchListener;
import org.languagetool.ShortDescriptionProvider;
import org.languagetool.SimpleInputSentence;
import org.languagetool.UserConfig;
import org.languagetool.databroker.DefaultResourceDataBroker;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.language.CommonWords;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.CleanOverlappingFilter;
import org.languagetool.rules.LanguageDependentFilter;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleMatchFilter;
import org.languagetool.rules.SameRuleGroupFilter;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.rules.neuralnetwork.Word2VecModel;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.FalseFriendRuleLoader;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.xml.sax.SAXException;

public class JLanguageTool {
    public static final String VERSION = "4.8";
    @Nullable
    public static final String BUILD_DATE = JLanguageTool.getBuildDate();
    @Nullable
    public static final String GIT_SHORT_ID = JLanguageTool.getShortGitId();
    public static final String PATTERN_FILE = "grammar.xml";
    public static final String FALSE_FRIEND_FILE = "false-friends.xml";
    public static final String SENTENCE_START_TAGNAME = "SENT_START";
    public static final String SENTENCE_END_TAGNAME = "SENT_END";
    public static final String PARAGRAPH_END_TAGNAME = "PARA_END";
    public static final String MESSAGE_BUNDLE = "org.languagetool.MessagesBundle";
    public static final String DICTIONARY_FILENAME_EXTENSION = ".dict";
    private final ResultCache cache;
    private final UserConfig userConfig;
    private final ShortDescriptionProvider descProvider;
    private float maxErrorsPerWordRate;
    private static ResourceDataBroker dataBroker = new DefaultResourceDataBroker();
    private final List<Rule> builtinRules;
    private final List<Rule> userRules = new ArrayList<Rule>();
    private final Set<String> optionalLanguageModelRules = new HashSet<String>();
    private final Set<String> disabledRules = new HashSet<String>();
    private final Set<CategoryId> disabledRuleCategories = new HashSet<CategoryId>();
    private final Set<String> enabledRules = new HashSet<String>();
    private final Set<CategoryId> enabledRuleCategories = new HashSet<CategoryId>();
    private final Language language;
    private final List<Language> altLanguages;
    private final Language motherTongue;
    private final List<RuleMatchFilter> matchFilters = new LinkedList<RuleMatchFilter>();
    private PrintStream printStream;
    private boolean listUnknownWords;
    private Set<String> unknownWords;
    private boolean cleanOverlappingMatches;
    private static final List<File> temporaryFiles = new ArrayList<File>();

    @Nullable
    private static String getBuildDate() {
        try {
            URL res = JLanguageTool.class.getResource(JLanguageTool.class.getSimpleName() + ".class");
            if (res == null) {
                return null;
            }
            URLConnection connObj = res.openConnection();
            if (connObj instanceof JarURLConnection) {
                JarURLConnection conn = (JarURLConnection)connObj;
                Manifest manifest = conn.getManifest();
                return manifest.getMainAttributes().getValue("Implementation-Date");
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get build date from JAR", e);
        }
    }

    @Nullable
    private static String getShortGitId() {
        try {
            InputStream in = JLanguageTool.class.getClassLoader().getResourceAsStream("git.properties");
            if (in != null) {
                Properties props = new Properties();
                props.load(in);
                return props.getProperty("git.commit.id.abbrev");
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get git id from 'git.properties'", e);
        }
    }

    public static boolean isPremiumVersion() {
        return false;
    }

    public JLanguageTool(Language lang, Language motherTongue) {
        this(lang, motherTongue, null);
    }

    public JLanguageTool(Language language) {
        this(language, null, null, null);
    }

    public JLanguageTool(Language language, Language motherTongue, ResultCache cache) {
        this(language, motherTongue, cache, null);
    }

    @Experimental
    public JLanguageTool(Language language, ResultCache cache, UserConfig userConfig) {
        this(language, null, cache, userConfig);
    }

    @Experimental
    public JLanguageTool(Language language, List<Language> altLanguages, Language motherTongue, ResultCache cache, GlobalConfig globalConfig, UserConfig userConfig) {
        this.language = Objects.requireNonNull(language, "language cannot be null");
        this.altLanguages = Objects.requireNonNull(altLanguages, "altLanguages cannot be null (but empty)");
        this.motherTongue = motherTongue;
        this.userConfig = userConfig == null ? new UserConfig() : userConfig;
        ResourceBundle messages = ResourceBundleTools.getMessageBundle(language);
        this.builtinRules = this.getAllBuiltinRules(language, messages, userConfig, globalConfig);
        this.cleanOverlappingMatches = true;
        try {
            this.activateDefaultPatternRules();
            if (!language.hasNGramFalseFriendRule(motherTongue)) {
                this.activateDefaultFalseFriendRules();
            }
            this.updateOptionalLanguageModelRules(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not activate rules", e);
        }
        this.cache = cache;
        this.descProvider = new ShortDescriptionProvider(language);
    }

    @Experimental
    public JLanguageTool(Language language, Language motherTongue, ResultCache cache, UserConfig userConfig) {
        this(language, Collections.emptyList(), motherTongue, cache, null, userConfig);
    }

    public static synchronized ResourceDataBroker getDataBroker() {
        if (dataBroker == null) {
            dataBroker = new DefaultResourceDataBroker();
        }
        return dataBroker;
    }

    public static synchronized void setDataBroker(ResourceDataBroker broker) {
        dataBroker = broker;
    }

    public void setListUnknownWords(boolean listUnknownWords) {
        this.listUnknownWords = listUnknownWords;
    }

    public void setCleanOverlappingMatches(boolean cleanOverlappingMatches) {
        this.cleanOverlappingMatches = cleanOverlappingMatches;
    }

    @Experimental
    public void setMaxErrorsPerWordRate(float maxErrorsPerWordRate) {
        this.maxErrorsPerWordRate = maxErrorsPerWordRate;
    }

    public static ResourceBundle getMessageBundle() {
        return ResourceBundleTools.getMessageBundle();
    }

    public static ResourceBundle getMessageBundle(Language lang) {
        return ResourceBundleTools.getMessageBundle(lang);
    }

    private List<Rule> getAllBuiltinRules(Language language, ResourceBundle messages, UserConfig userConfig, GlobalConfig globalConfig) {
        try {
            ArrayList<Rule> rules = new ArrayList<Rule>(language.getRelevantRules(messages, userConfig, this.motherTongue, this.altLanguages));
            rules.addAll(language.getRelevantRulesGlobalConfig(messages, globalConfig, userConfig, this.motherTongue, this.altLanguages));
            return rules;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get rules of language " + language, e);
        }
    }

    public void setOutput(PrintStream printStream) {
        this.printStream = printStream;
    }

    public List<AbstractPatternRule> loadPatternRules(String filename) throws IOException {
        PatternRuleLoader ruleLoader = new PatternRuleLoader();
        try (InputStream is = this.getClass().getResourceAsStream(filename);){
            if (is == null) {
                if (filename.contains("-test-")) {
                    List<AbstractPatternRule> list = Collections.emptyList();
                    return list;
                }
                List<AbstractPatternRule> list = ruleLoader.getRules(new File(filename));
                return list;
            }
            List<AbstractPatternRule> list = ruleLoader.getRules(is, filename);
            return list;
        }
    }

    public List<AbstractPatternRule> loadFalseFriendRules(String filename) throws ParserConfigurationException, SAXException, IOException {
        if (this.motherTongue == null) {
            return Collections.emptyList();
        }
        FalseFriendRuleLoader ruleLoader = new FalseFriendRuleLoader(this.motherTongue);
        try (InputStream is = this.getClass().getResourceAsStream(filename);){
            if (is == null) {
                List<AbstractPatternRule> list = ruleLoader.getRules(new File(filename), this.language, this.motherTongue);
                return list;
            }
            List<AbstractPatternRule> list = ruleLoader.getRules(is, this.language, this.motherTongue);
            return list;
        }
    }

    private void updateOptionalLanguageModelRules(@Nullable LanguageModel lm) {
        ResourceBundle messages = JLanguageTool.getMessageBundle(this.language);
        try {
            List<Rule> rules = this.language.getRelevantLanguageModelCapableRules(messages, lm, this.userConfig, this.motherTongue, this.altLanguages);
            this.userRules.removeIf(rule -> this.optionalLanguageModelRules.contains(rule.getId()));
            this.optionalLanguageModelRules.clear();
            rules.stream().map(Rule::getId).forEach(this.optionalLanguageModelRules::add);
            this.userRules.addAll(rules);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load language model capable rules.", e);
        }
    }

    public void activateNeuralNetworkRules(File modelDir) throws IOException {
        ResourceBundle messages = JLanguageTool.getMessageBundle(this.language);
        List<Rule> rules = this.language.getRelevantNeuralNetworkModels(messages, modelDir);
        this.userRules.addAll(rules);
    }

    public void activateLanguageModelRules(File indexDir) throws IOException {
        LanguageModel languageModel = this.language.getLanguageModel(indexDir);
        if (languageModel != null) {
            ResourceBundle messages = JLanguageTool.getMessageBundle(this.language);
            List<Rule> rules = this.language.getRelevantLanguageModelRules(messages, languageModel);
            this.userRules.addAll(rules);
            this.updateOptionalLanguageModelRules(languageModel);
        }
    }

    public void activateWord2VecModelRules(File indexDir) throws IOException {
        Word2VecModel word2vecModel = this.language.getWord2VecModel(indexDir);
        if (word2vecModel != null) {
            ResourceBundle messages = JLanguageTool.getMessageBundle(this.language);
            List<Rule> rules = this.language.getRelevantWord2VecModelRules(messages, word2vecModel);
            this.userRules.addAll(rules);
        }
    }

    private void activateDefaultPatternRules() throws IOException {
        List<AbstractPatternRule> patternRules = this.language.getPatternRules();
        List<String> enabledRules = this.language.getDefaultEnabledRulesForVariant();
        List<String> disabledRules = this.language.getDefaultDisabledRulesForVariant();
        if (!enabledRules.isEmpty() || !disabledRules.isEmpty()) {
            for (AbstractPatternRule patternRule : patternRules) {
                if (enabledRules.contains(patternRule.getId())) {
                    patternRule.setDefaultOn();
                }
                if (!disabledRules.contains(patternRule.getId())) continue;
                patternRule.setDefaultOff();
            }
        }
        this.userRules.addAll(patternRules);
    }

    private void activateDefaultFalseFriendRules() throws ParserConfigurationException, SAXException, IOException {
        String falseFriendRulesFilename = JLanguageTool.getDataBroker().getRulesDir() + "/" + FALSE_FRIEND_FILE;
        this.userRules.addAll(this.loadFalseFriendRules(falseFriendRulesFilename));
    }

    public void addMatchFilter(@NotNull RuleMatchFilter filter) {
        this.matchFilters.add(Objects.requireNonNull(filter));
    }

    public void addRule(Rule rule) {
        this.userRules.add(rule);
    }

    public void disableRule(String ruleId) {
        this.disabledRules.add(ruleId);
        this.enabledRules.remove(ruleId);
    }

    public void disableRules(List<String> ruleIds) {
        this.disabledRules.addAll(ruleIds);
        this.enabledRules.removeAll(ruleIds);
    }

    public void disableCategory(CategoryId id) {
        this.disabledRuleCategories.add(id);
        this.enabledRuleCategories.remove(id);
    }

    public boolean isCategoryDisabled(CategoryId id) {
        return this.disabledRuleCategories.contains(id);
    }

    public Language getLanguage() {
        return this.language;
    }

    public Set<String> getDisabledRules() {
        return this.disabledRules;
    }

    public void enableRule(String ruleId) {
        this.disabledRules.remove(ruleId);
        this.enabledRules.add(ruleId);
    }

    public void enableRuleCategory(CategoryId id) {
        this.disabledRuleCategories.remove(id);
        this.enabledRuleCategories.add(id);
    }

    public List<String> sentenceTokenize(String text) {
        return this.language.getSentenceTokenizer().tokenize(text);
    }

    public List<RuleMatch> check(String text) throws IOException {
        return this.check(text, true, ParagraphHandling.NORMAL);
    }

    public List<RuleMatch> check(String text, RuleMatchListener listener) throws IOException {
        return this.check(text, true, ParagraphHandling.NORMAL, listener);
    }

    public List<RuleMatch> check(String text, boolean tokenizeText, ParagraphHandling paraMode) throws IOException {
        return this.check(new AnnotatedTextBuilder().addText(text).build(), tokenizeText, paraMode);
    }

    public List<RuleMatch> check(String text, boolean tokenizeText, ParagraphHandling paraMode, RuleMatchListener listener) throws IOException {
        return this.check(new AnnotatedTextBuilder().addText(text).build(), tokenizeText, paraMode, listener);
    }

    public List<RuleMatch> check(AnnotatedText text) throws IOException {
        return this.check(text, true, ParagraphHandling.NORMAL);
    }

    public List<RuleMatch> check(AnnotatedText text, RuleMatchListener listener) throws IOException {
        return this.check(text, true, ParagraphHandling.NORMAL, listener);
    }

    public List<RuleMatch> check(AnnotatedText annotatedText, boolean tokenizeText, ParagraphHandling paraMode) throws IOException {
        return this.check(annotatedText, tokenizeText, paraMode, null);
    }

    public List<RuleMatch> check(AnnotatedText annotatedText, boolean tokenizeText, ParagraphHandling paraMode, RuleMatchListener listener) throws IOException {
        Mode mode = paraMode == ParagraphHandling.ONLYNONPARA ? Mode.ALL_BUT_TEXTLEVEL_ONLY : (paraMode == ParagraphHandling.ONLYPARA ? Mode.TEXTLEVEL_ONLY : Mode.ALL);
        return this.check(annotatedText, tokenizeText, paraMode, listener, mode);
    }

    public List<RuleMatch> check(AnnotatedText annotatedText, boolean tokenizeText, ParagraphHandling paraMode, RuleMatchListener listener, Mode mode) throws IOException {
        List<Object> sentences;
        if (tokenizeText) {
            sentences = this.sentenceTokenize(annotatedText.getPlainText());
        } else {
            sentences = new ArrayList();
            sentences.add(annotatedText.getPlainText());
        }
        List<Rule> allRules = this.getAllRules();
        if (this.printStream != null) {
            this.printIfVerbose(allRules.size() + " rules activated for language " + this.language);
        }
        this.unknownWords = new HashSet<String>();
        List<AnalyzedSentence> analyzedSentences = this.analyzeSentences(sentences);
        List<RuleMatch> ruleMatches = this.performCheck(analyzedSentences, sentences, allRules, paraMode, annotatedText, listener, mode);
        ruleMatches = new SameRuleGroupFilter().filter(ruleMatches);
        if (this.cleanOverlappingMatches) {
            ruleMatches = new CleanOverlappingFilter(this.language).filter(ruleMatches);
        }
        ruleMatches = new LanguageDependentFilter(this.language, this.enabledRules, this.disabledRuleCategories).filter(ruleMatches);
        ruleMatches = this.applyCustomFilters(ruleMatches, annotatedText);
        return ruleMatches;
    }

    public List<AnalyzedSentence> analyzeText(String text) throws IOException {
        List<String> sentences = this.sentenceTokenize(text);
        return this.analyzeSentences(sentences);
    }

    protected List<AnalyzedSentence> analyzeSentences(List<String> sentences) throws IOException {
        ArrayList<AnalyzedSentence> analyzedSentences = new ArrayList<AnalyzedSentence>();
        int j = 0;
        for (String sentence : sentences) {
            AnalyzedSentence analyzedSentence = this.getAnalyzedSentence(sentence);
            this.rememberUnknownWords(analyzedSentence);
            if (++j == sentences.size()) {
                AnalyzedTokenReadings[] anTokens = analyzedSentence.getTokens();
                anTokens[anTokens.length - 1].setParagraphEnd();
                analyzedSentence = new AnalyzedSentence(anTokens);
            }
            analyzedSentences.add(analyzedSentence);
            this.printSentenceInfo(analyzedSentence);
        }
        return analyzedSentences;
    }

    protected void printSentenceInfo(AnalyzedSentence analyzedSentence) {
        if (this.printStream != null) {
            this.printIfVerbose(analyzedSentence.toString());
            this.printIfVerbose(analyzedSentence.getAnnotations());
        }
    }

    protected List<RuleMatch> performCheck(List<AnalyzedSentence> analyzedSentences, List<String> sentences, List<Rule> allRules, ParagraphHandling paraMode, AnnotatedText annotatedText, Mode mode) throws IOException {
        return this.performCheck(analyzedSentences, sentences, allRules, paraMode, annotatedText, null, mode);
    }

    protected List<RuleMatch> performCheck(List<AnalyzedSentence> analyzedSentences, List<String> sentences, List<Rule> allRules, ParagraphHandling paraMode, AnnotatedText annotatedText, RuleMatchListener listener, Mode mode) throws IOException {
        TextCheckCallable matcher = new TextCheckCallable(allRules, sentences, analyzedSentences, paraMode, annotatedText, 0, 0, 1, listener, mode);
        try {
            return (List)matcher.call();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<RuleMatch> checkAnalyzedSentence(ParagraphHandling paraMode, List<Rule> rules, AnalyzedSentence analyzedSentence) throws IOException {
        ArrayList<RuleMatch> sentenceMatches = new ArrayList<RuleMatch>();
        RuleLoggerManager logger = RuleLoggerManager.getInstance();
        for (Rule rule : rules) {
            if (rule instanceof TextLevelRule || this.ignoreRule(rule) || rule instanceof PatternRule && ((PatternRule)rule).canBeIgnoredFor(analyzedSentence) || paraMode == ParagraphHandling.ONLYPARA) continue;
            long time = System.currentTimeMillis();
            RuleMatch[] thisMatches = rule.match(analyzedSentence);
            logger.log(new RuleCheckTimeMessage(rule.getId(), this.language.getShortCodeWithCountryAndVariant(), time, analyzedSentence.getText().length()), Level.FINE);
            for (RuleMatch elem : thisMatches) {
                sentenceMatches.add(elem);
            }
        }
        AnnotatedText text = new AnnotatedTextBuilder().addText(analyzedSentence.getText()).build();
        return this.applyCustomFilters(new SameRuleGroupFilter().filter(sentenceMatches), text);
    }

    private boolean ignoreRule(Rule rule) {
        boolean isRuleDisabled;
        Category ruleCategory = rule.getCategory();
        boolean isCategoryDisabled = (this.disabledRuleCategories.contains(ruleCategory.getId()) || rule.getCategory().isDefaultOff()) && !this.enabledRuleCategories.contains(ruleCategory.getId());
        boolean bl = isRuleDisabled = this.disabledRules.contains(rule.getId()) || rule.isDefaultOff() && !this.enabledRules.contains(rule.getId());
        boolean isDisabled = isCategoryDisabled ? !this.enabledRules.contains(rule.getId()) : isRuleDisabled;
        return isDisabled;
    }

    public RuleMatch adjustRuleMatchPos(RuleMatch match, int charCount, int columnCount, int lineCount, String sentence, AnnotatedText annotatedText) {
        int fromPos = match.getFromPos() + charCount;
        int toPos = match.getToPos() + charCount;
        if (annotatedText != null) {
            fromPos = annotatedText.getOriginalTextPositionFor(fromPos, false);
            toPos = annotatedText.getOriginalTextPositionFor(toPos - 1, true) + 1;
        }
        RuleMatch thisMatch = new RuleMatch(match);
        thisMatch.setOffsetPosition(fromPos, toPos, thisMatch);
        List<SuggestedReplacement> replacements = match.getSuggestedReplacementObjects();
        thisMatch.setSuggestedReplacementObjects(this.extendSuggestions(replacements));
        String sentencePartToError = sentence.substring(0, match.getFromPos());
        String sentencePartToEndOfError = sentence.substring(0, match.getToPos());
        int lastLineBreakPos = sentencePartToError.lastIndexOf(10);
        int column = lastLineBreakPos == -1 ? sentencePartToError.length() + columnCount : sentencePartToError.length() - lastLineBreakPos;
        int lastLineBreakPosInError = sentencePartToEndOfError.lastIndexOf(10);
        int endColumn = lastLineBreakPosInError == -1 ? sentencePartToEndOfError.length() + columnCount : sentencePartToEndOfError.length() - lastLineBreakPosInError;
        int lineBreaksToError = JLanguageTool.countLineBreaks(sentencePartToError);
        int lineBreaksToEndOfError = JLanguageTool.countLineBreaks(sentencePartToEndOfError);
        thisMatch.setLine(lineCount + lineBreaksToError);
        thisMatch.setEndLine(lineCount + lineBreaksToEndOfError);
        thisMatch.setColumn(column);
        thisMatch.setEndColumn(endColumn);
        return thisMatch;
    }

    private List<SuggestedReplacement> extendSuggestions(List<SuggestedReplacement> replacements) {
        ArrayList<SuggestedReplacement> extended = new ArrayList<SuggestedReplacement>();
        for (SuggestedReplacement replacement : replacements) {
            SuggestedReplacement newReplacement = new SuggestedReplacement(replacement);
            if (replacement.getShortDescription() == null) {
                String descOrNull = this.descProvider.getShortDescription(replacement.getReplacement());
                newReplacement.setShortDescription(descOrNull);
            }
            extended.add(newReplacement);
        }
        return extended;
    }

    protected void rememberUnknownWords(AnalyzedSentence analyzedText) {
        if (this.listUnknownWords) {
            AnalyzedTokenReadings[] atr;
            for (AnalyzedTokenReadings reading : atr = analyzedText.getTokensWithoutWhitespace()) {
                if (reading.isTagged()) continue;
                this.unknownWords.add(reading.getToken());
            }
        }
    }

    public List<String> getUnknownWords() {
        if (!this.listUnknownWords) {
            throw new IllegalStateException("listUnknownWords is set to false, unknown words not stored");
        }
        ArrayList<String> words = new ArrayList<String>(this.unknownWords);
        Collections.sort(words);
        return words;
    }

    static int countLineBreaks(String s) {
        int nextPos;
        int pos = -1;
        int count = 0;
        while ((nextPos = s.indexOf(10, pos + 1)) != -1) {
            pos = nextPos;
            ++count;
        }
        return count;
    }

    public AnalyzedSentence getAnalyzedSentence(String sentence) throws IOException {
        AnalyzedSentence cachedSentence;
        SimpleInputSentence cacheKey = new SimpleInputSentence(sentence, this.language);
        AnalyzedSentence analyzedSentence = cachedSentence = this.cache != null ? this.cache.getIfPresent(cacheKey) : null;
        if (cachedSentence != null) {
            return cachedSentence;
        }
        AnalyzedSentence raw = this.getRawAnalyzedSentence(sentence);
        AnalyzedSentence disambig = this.language.getDisambiguator().disambiguate(raw);
        AnalyzedSentence analyzedSentence2 = new AnalyzedSentence(disambig.getTokens(), raw.getTokens());
        if (this.language.getPostDisambiguationChunker() != null) {
            this.language.getPostDisambiguationChunker().addChunkTags(Arrays.asList(analyzedSentence2.getTokens()));
        }
        if (this.cache != null) {
            this.cache.put(cacheKey, analyzedSentence2);
        }
        return analyzedSentence2;
    }

    public AnalyzedSentence getRawAnalyzedSentence(String sentence) throws IOException {
        AnalyzedToken sentenceStartToken;
        List<String> tokens = this.language.getWordTokenizer().tokenize(sentence);
        Map<Integer, String> softHyphenTokens = this.replaceSoftHyphens(tokens);
        List<AnalyzedTokenReadings> aTokens = this.language.getTagger().tag(tokens);
        if (this.language.getChunker() != null) {
            this.language.getChunker().addChunkTags(aTokens);
        }
        AnalyzedTokenReadings[] tokenArray = new AnalyzedTokenReadings[tokens.size() + 1];
        AnalyzedToken[] startTokenArray = new AnalyzedToken[1];
        int toArrayCount = 0;
        startTokenArray[0] = sentenceStartToken = new AnalyzedToken("", SENTENCE_START_TAGNAME, null);
        tokenArray[toArrayCount++] = new AnalyzedTokenReadings(startTokenArray, 0);
        int startPos = 0;
        for (AnalyzedTokenReadings posTag : aTokens) {
            posTag.setStartPos(startPos);
            tokenArray[toArrayCount++] = posTag;
            startPos += posTag.getToken().length();
        }
        int numTokens = aTokens.size();
        int posFix = 0;
        for (int i = 0; i < numTokens; ++i) {
            if (i > 0) {
                aTokens.get(i).setWhitespaceBefore(aTokens.get(i - 1).getToken());
                aTokens.get(i).setStartPos(aTokens.get(i).getStartPos() + posFix);
            }
            if (softHyphenTokens.isEmpty() || softHyphenTokens.get(i) == null) continue;
            posFix += softHyphenTokens.get(i).length() - aTokens.get(i).getToken().length();
            AnalyzedToken newToken = this.language.getTagger().createToken(softHyphenTokens.get(i), null);
            aTokens.get(i).addReading(newToken, "softHyphenTokens");
        }
        int lastToken = toArrayCount - 1;
        for (int i = 0; i < toArrayCount - 1; ++i) {
            if (tokenArray[lastToken - i].isWhitespace()) continue;
            lastToken -= i;
            break;
        }
        tokenArray[lastToken].setSentEnd();
        if (tokenArray.length == lastToken + 1 && tokenArray[lastToken].isLinebreak()) {
            tokenArray[lastToken].setParagraphEnd();
        }
        return new AnalyzedSentence(tokenArray);
    }

    private Map<Integer, String> replaceSoftHyphens(List<String> tokens) {
        Pattern ignoredCharacterRegex = this.language.getIgnoredCharactersRegex();
        HashMap<Integer, String> ignoredCharsTokens = new HashMap<Integer, String>();
        if (ignoredCharacterRegex == null) {
            return ignoredCharsTokens;
        }
        for (int i = 0; i < tokens.size(); ++i) {
            Matcher matcher = ignoredCharacterRegex.matcher(tokens.get(i));
            if (!matcher.find()) continue;
            ignoredCharsTokens.put(i, tokens.get(i));
            tokens.set(i, matcher.replaceAll(""));
        }
        return ignoredCharsTokens;
    }

    public Map<CategoryId, Category> getCategories() {
        HashMap<CategoryId, Category> map = new HashMap<CategoryId, Category>();
        for (Rule rule : this.getAllRules()) {
            map.put(rule.getCategory().getId(), rule.getCategory());
        }
        return map;
    }

    public List<Rule> getAllRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.addAll(this.builtinRules);
        rules.addAll(this.userRules);
        return rules;
    }

    public List<Rule> getAllActiveRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<Rule> rulesActive = new ArrayList<Rule>();
        rules.addAll(this.builtinRules);
        rules.addAll(this.userRules);
        for (Rule rule : rules) {
            if (this.ignoreRule(rule)) continue;
            rulesActive.add(rule);
        }
        return rulesActive;
    }

    public List<Rule> getAllActiveOfficeRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<Rule> rulesActive = new ArrayList<Rule>();
        rules.addAll(this.builtinRules);
        rules.addAll(this.userRules);
        for (Rule rule : rules) {
            if (!this.ignoreRule(rule) && !rule.isOfficeDefaultOff()) {
                rulesActive.add(rule);
                continue;
            }
            if (rule.isOfficeDefaultOn() && !this.disabledRules.contains(rule.getId())) {
                rulesActive.add(rule);
                this.enableRule(rule.getId());
                continue;
            }
            if (this.ignoreRule(rule) || !rule.isOfficeDefaultOff() || this.enabledRules.contains(rule.getId())) continue;
            this.disableRule(rule.getId());
        }
        return rulesActive;
    }

    public List<AbstractPatternRule> getPatternRulesByIdAndSubId(String id, String subId) {
        List<Rule> rules = this.getAllRules();
        ArrayList<AbstractPatternRule> rulesById = new ArrayList<AbstractPatternRule>();
        for (Rule rule : rules) {
            if (!(rule instanceof AbstractPatternRule) || !rule.getId().equals(id) || !((AbstractPatternRule)rule).getSubId().equals(subId)) continue;
            rulesById.add((AbstractPatternRule)rule);
        }
        return rulesById;
    }

    protected void printIfVerbose(String s) {
        if (this.printStream != null) {
            this.printStream.println(s);
        }
    }

    public static void addTemporaryFile(File file) {
        temporaryFiles.add(file);
    }

    public static void removeTemporaryFiles() {
        for (File file : temporaryFiles) {
            file.delete();
        }
    }

    protected List<RuleMatch> applyCustomFilters(List<RuleMatch> matches, AnnotatedText text) {
        List<RuleMatch> transformed = matches;
        for (RuleMatchFilter filter : this.matchFilters) {
            transformed = filter.filter(transformed, text);
        }
        return transformed;
    }

    public void setConfigValues(Map<String, Integer> v) {
        this.userConfig.insertConfigValues(v);
    }

    class TextCheckCallable
    implements Callable<List<RuleMatch>> {
        private final List<Rule> rules;
        private final ParagraphHandling paraMode;
        private final AnnotatedText annotatedText;
        private final List<String> sentences;
        private final List<AnalyzedSentence> analyzedSentences;
        private final RuleMatchListener listener;
        private final Mode mode;
        private int charCount;
        private int lineCount;
        private int columnCount;

        TextCheckCallable(List<Rule> rules, List<String> sentences, List<AnalyzedSentence> analyzedSentences, ParagraphHandling paraMode, AnnotatedText annotatedText, int charCount, int lineCount, int columnCount, RuleMatchListener listener, Mode mode) {
            this.rules = rules;
            if (sentences.size() != analyzedSentences.size()) {
                throw new IllegalArgumentException("sentences and analyzedSentences do not have the same length : " + sentences.size() + " != " + analyzedSentences.size());
            }
            this.sentences = Objects.requireNonNull(sentences);
            this.analyzedSentences = Objects.requireNonNull(analyzedSentences);
            this.paraMode = Objects.requireNonNull(paraMode);
            this.annotatedText = Objects.requireNonNull(annotatedText);
            this.charCount = charCount;
            this.lineCount = lineCount;
            this.columnCount = columnCount;
            this.listener = listener;
            this.mode = Objects.requireNonNull(mode);
        }

        @Override
        public List<RuleMatch> call() throws Exception {
            ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
            if (this.mode == Mode.ALL) {
                ruleMatches.addAll(this.getTextLevelRuleMatches());
                ruleMatches.addAll(this.getOtherRuleMatches());
            } else if (this.mode == Mode.ALL_BUT_TEXTLEVEL_ONLY) {
                ruleMatches.addAll(this.getOtherRuleMatches());
            } else if (this.mode == Mode.TEXTLEVEL_ONLY) {
                ruleMatches.addAll(this.getTextLevelRuleMatches());
            } else {
                throw new IllegalArgumentException("Unknown mode: " + (Object)((Object)this.mode));
            }
            return ruleMatches;
        }

        private List<RuleMatch> getTextLevelRuleMatches() throws IOException {
            ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
            RuleLoggerManager logger = RuleLoggerManager.getInstance();
            String lang = JLanguageTool.this.language.getShortCodeWithCountryAndVariant();
            for (Rule rule : this.rules) {
                if (!(rule instanceof TextLevelRule) || JLanguageTool.this.ignoreRule(rule) || this.paraMode == ParagraphHandling.ONLYNONPARA) continue;
                long time = System.currentTimeMillis();
                RuleMatch[] matches = ((TextLevelRule)rule).match(this.analyzedSentences, this.annotatedText);
                logger.log(new RuleCheckTimeMessage(rule.getId(), lang, time, this.annotatedText.getPlainText().length()), Level.FINE);
                ArrayList<RuleMatch> adaptedMatches = new ArrayList<RuleMatch>();
                for (RuleMatch match : matches) {
                    LineColumnRange range = this.getLineColumnRange(match);
                    int newFromPos = this.annotatedText.getOriginalTextPositionFor(match.getFromPos(), false);
                    int newToPos = this.annotatedText.getOriginalTextPositionFor(match.getToPos() - 1, true) + 1;
                    RuleMatch newMatch = new RuleMatch(match);
                    newMatch.setOffsetPosition(newFromPos, newToPos, newMatch);
                    newMatch.setLine(range.from.line);
                    newMatch.setEndLine(range.to.line);
                    if (match.getLine() == 0) {
                        newMatch.setColumn(range.from.column + 1);
                    } else {
                        newMatch.setColumn(range.from.column);
                    }
                    newMatch.setEndColumn(range.to.column);
                    adaptedMatches.add(newMatch);
                }
                ruleMatches.addAll(adaptedMatches);
                if (this.listener == null) continue;
                for (RuleMatch adaptedMatch : adaptedMatches) {
                    this.listener.matchFound(adaptedMatch);
                }
            }
            return ruleMatches;
        }

        private List<RuleMatch> getOtherRuleMatches() {
            ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
            int i = 0;
            int wordCounter = 0;
            for (AnalyzedSentence analyzedSentence : this.analyzedSentences) {
                String sentence = this.sentences.get(i++);
                wordCounter += analyzedSentence.getTokensWithoutWhitespace().length;
                try {
                    List<RuleMatch> sentenceMatches = null;
                    InputSentence cacheKey = null;
                    if (JLanguageTool.this.cache != null) {
                        cacheKey = new InputSentence(analyzedSentence.getText(), JLanguageTool.this.language, JLanguageTool.this.motherTongue, JLanguageTool.this.disabledRules, JLanguageTool.this.disabledRuleCategories, JLanguageTool.this.enabledRules, JLanguageTool.this.enabledRuleCategories, JLanguageTool.this.userConfig, JLanguageTool.this.altLanguages, this.mode);
                        sentenceMatches = JLanguageTool.this.cache.getIfPresent(cacheKey);
                    }
                    if (sentenceMatches == null) {
                        sentenceMatches = JLanguageTool.this.checkAnalyzedSentence(this.paraMode, this.rules, analyzedSentence);
                    }
                    if (JLanguageTool.this.cache != null) {
                        JLanguageTool.this.cache.put(cacheKey, sentenceMatches);
                    }
                    ArrayList<RuleMatch> adaptedMatches = new ArrayList<RuleMatch>();
                    for (RuleMatch elem : sentenceMatches) {
                        RuleMatch thisMatch = JLanguageTool.this.adjustRuleMatchPos(elem, this.charCount, this.columnCount, this.lineCount, sentence, this.annotatedText);
                        adaptedMatches.add(thisMatch);
                        if (this.listener == null) continue;
                        this.listener.matchFound(thisMatch);
                    }
                    ruleMatches.addAll(adaptedMatches);
                    float errorsPerWord = (float)ruleMatches.size() / (float)wordCounter;
                    if (JLanguageTool.this.maxErrorsPerWordRate > 0.0f && errorsPerWord > JLanguageTool.this.maxErrorsPerWordRate && wordCounter > 25) {
                        CommonWords commonWords = new CommonWords();
                        throw new ErrorRateTooHighException("Text checking was stopped due to too many errors (more than " + String.format("%.0f", Float.valueOf(JLanguageTool.this.maxErrorsPerWordRate * 100.0f)) + "% of words seem to have an error). Are you sure you have set the correct text language? Language set: " + JLanguageTool.this.language.getName() + ", text length: " + this.annotatedText.getPlainText().length() + ", common word count: " + commonWords.getKnownWordsPerLanguage(this.annotatedText.getPlainText()));
                    }
                    this.charCount += sentence.length();
                    this.lineCount += JLanguageTool.countLineBreaks(sentence);
                    int lineBreakPos = sentence.lastIndexOf(10);
                    if (lineBreakPos == -1) {
                        this.columnCount += sentence.length();
                        continue;
                    }
                    if (lineBreakPos == 0) {
                        this.columnCount = sentence.length();
                        if (JLanguageTool.this.language.getSentenceTokenizer().singleLineBreaksMarksPara()) continue;
                        --this.columnCount;
                        continue;
                    }
                    this.columnCount = sentence.length() - lineBreakPos;
                }
                catch (ErrorRateTooHighException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not check sentence (language: " + JLanguageTool.this.language + "): '" + StringUtils.abbreviate((String)analyzedSentence.toTextString(), (int)500) + "'", e);
                }
            }
            return ruleMatches;
        }

        private LineColumnRange getLineColumnRange(RuleMatch match) {
            LineColumnPosition fromPos = new LineColumnPosition(-1, -1);
            LineColumnPosition toPos = new LineColumnPosition(-1, -1);
            LineColumnPosition pos = new LineColumnPosition(0, 0);
            int charCount = 0;
            for (AnalyzedSentence analyzedSentence : this.analyzedSentences) {
                for (AnalyzedTokenReadings readings : analyzedSentence.getTokens()) {
                    String token = readings.getToken();
                    if ("\n".equals(token)) {
                        ++pos.line;
                        pos.column = 0;
                    }
                    pos.column += token.length();
                    if ((charCount += token.length()) == match.getFromPos()) {
                        fromPos = new LineColumnPosition(pos.line, pos.column);
                    }
                    if (charCount != match.getToPos()) continue;
                    toPos = new LineColumnPosition(pos.line, pos.column);
                }
            }
            return new LineColumnRange(fromPos, toPos);
        }

        private class LineColumnRange {
            LineColumnPosition from;
            LineColumnPosition to;

            private LineColumnRange(LineColumnPosition from, LineColumnPosition to) {
                this.from = from;
                this.to = to;
            }
        }

        private class LineColumnPosition {
            int line;
            int column;

            private LineColumnPosition(int line, int column) {
                this.line = line;
                this.column = column;
            }
        }
    }

    public static enum Mode {
        ALL,
        TEXTLEVEL_ONLY,
        ALL_BUT_TEXTLEVEL_ONLY;

    }

    public static enum ParagraphHandling {
        NORMAL,
        ONLYPARA,
        ONLYNONPARA;

    }
}

