/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.dictionary;

import java.io.IOException;
import net.java.sen.dictionary.CToken;
import net.java.sen.dictionary.Dictionary;
import net.java.sen.dictionary.Morpheme;
import net.java.sen.dictionary.Node;
import net.java.sen.dictionary.SentenceIterator;

public abstract class Tokenizer {
    protected final Dictionary dictionary;
    protected final CToken unknownCToken;
    protected final Node bosNode;
    protected final Node eosNode;
    protected final String unknownPartOfSpeechDescription;
    protected final boolean tokenizeUnknownKatakana;
    private final Morpheme unknownMorpheme;

    public boolean isTokenizeUnknownKatakan() {
        return this.tokenizeUnknownKatakana;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public Node getBOSNode() {
        Node bosNode = this.bosNode.clone();
        bosNode.prev = this.bosNode.clone();
        return bosNode;
    }

    public Node getEOSNode() {
        return this.eosNode.clone();
    }

    public Node getUnknownNode(char[] surface, int start, int length, int span) {
        Node unknownNode = new Node();
        unknownNode.setCToken(this.unknownCToken);
        unknownNode.start = start;
        unknownNode.length = length;
        unknownNode.span = span;
        unknownNode.morpheme = this.unknownMorpheme;
        return unknownNode;
    }

    public abstract Node lookup(SentenceIterator var1, char[] var2) throws IOException;

    public Tokenizer(Dictionary dictionary, String unknownPartOfSpeechDescription, boolean tokenizeUnknownKatakana) {
        this.dictionary = dictionary;
        this.unknownPartOfSpeechDescription = unknownPartOfSpeechDescription;
        this.bosNode = new Node();
        this.bosNode.setCToken(this.dictionary.getBOSToken());
        this.eosNode = new Node();
        this.eosNode.setCToken(this.dictionary.getEOSToken());
        this.unknownCToken = this.dictionary.getUnknownToken();
        this.unknownCToken.cost = (short)30000;
        this.unknownMorpheme = new Morpheme(unknownPartOfSpeechDescription, null, null, "*", new String[0], new String[0], null);
        this.tokenizeUnknownKatakana = tokenizeUnknownKatakana;
    }
}

