/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;

public class ComQuery {
    public static void sendSubCmd(PacketOutputStream out, ClientPrepareResult clientPrepareResult, ParameterHolder[] parameters, int queryTimeout) throws IOException {
        out.write(3);
        if (queryTimeout > 0) {
            out.write(("SET STATEMENT max_statement_time=" + queryTimeout + " FOR ").getBytes());
        }
        if (clientPrepareResult.isRewriteType()) {
            out.write(clientPrepareResult.getQueryParts().get(0));
            out.write(clientPrepareResult.getQueryParts().get(1));
            for (int i = 0; i < clientPrepareResult.getParamCount(); ++i) {
                parameters[i].writeTo(out);
                out.write(clientPrepareResult.getQueryParts().get(i + 2));
            }
            out.write(clientPrepareResult.getQueryParts().get(clientPrepareResult.getParamCount() + 2));
        } else {
            out.write(clientPrepareResult.getQueryParts().get(0));
            for (int i = 0; i < clientPrepareResult.getParamCount(); ++i) {
                parameters[i].writeTo(out);
                out.write(clientPrepareResult.getQueryParts().get(i + 1));
            }
        }
    }

    public static int sendRewriteCmd(PacketOutputStream pos, List<byte[]> queryParts, int currentIndex, int paramCount, List<ParameterHolder[]> parameterList, boolean rewriteValues) throws IOException {
        pos.startPacket(0);
        pos.write(3);
        int index = currentIndex;
        ParameterHolder[] parameters = parameterList.get(index++);
        byte[] firstPart = queryParts.get(0);
        byte[] secondPart = queryParts.get(1);
        if (!rewriteValues) {
            pos.write(firstPart, 0, firstPart.length);
            pos.write(secondPart, 0, secondPart.length);
            int staticLength = 1;
            for (byte[] queryPart : queryParts) {
                staticLength += queryPart.length;
            }
            for (int i = 0; i < paramCount; ++i) {
                parameters[i].writeTo(pos);
                pos.write(queryParts.get(i + 2));
            }
            pos.write(queryParts.get(paramCount + 2));
            while (index < parameterList.size()) {
                parameters = parameterList.get(index);
                int parameterLength = 0;
                boolean knownParameterSize = true;
                for (ParameterHolder parameter : parameters) {
                    long paramSize = parameter.getApproximateTextProtocolLength();
                    if (paramSize == -1L) {
                        knownParameterSize = false;
                        break;
                    }
                    parameterLength = (int)((long)parameterLength + paramSize);
                }
                if (knownParameterSize) {
                    if (pos.checkRemainingSize(staticLength + parameterLength)) {
                        pos.write(59);
                        pos.write(firstPart, 0, firstPart.length);
                        pos.write(secondPart, 0, secondPart.length);
                        for (int i = 0; i < paramCount; ++i) {
                            parameters[i].writeTo(pos);
                            pos.write(queryParts.get(i + 2));
                        }
                        pos.write(queryParts.get(paramCount + 2));
                        ++index;
                        continue;
                    }
                } else {
                    pos.write(59);
                    pos.write(firstPart, 0, firstPart.length);
                    pos.write(secondPart, 0, secondPart.length);
                    for (int i = 0; i < paramCount; ++i) {
                        parameters[i].writeTo(pos);
                        pos.write(queryParts.get(i + 2));
                    }
                    pos.write(queryParts.get(paramCount + 2));
                    ++index;
                }
                break;
            }
        } else {
            pos.write(firstPart, 0, firstPart.length);
            pos.write(secondPart, 0, secondPart.length);
            int lastPartLength = queryParts.get(paramCount + 2).length;
            int intermediatePartLength = queryParts.get(1).length;
            for (int i = 0; i < paramCount; ++i) {
                parameters[i].writeTo(pos);
                pos.write(queryParts.get(i + 2));
                intermediatePartLength += queryParts.get(i + 2).length;
            }
            while (index < parameterList.size()) {
                parameters = parameterList.get(index);
                int parameterLength = 0;
                boolean knownParameterSize = true;
                for (ParameterHolder parameter : parameters) {
                    long paramSize = parameter.getApproximateTextProtocolLength();
                    if (paramSize == -1L) {
                        knownParameterSize = false;
                        break;
                    }
                    parameterLength = (int)((long)parameterLength + paramSize);
                }
                if (knownParameterSize) {
                    if (!pos.checkRemainingSize(1 + parameterLength + intermediatePartLength + lastPartLength)) break;
                    pos.write(44);
                    pos.write(secondPart, 0, secondPart.length);
                    for (int i = 0; i < paramCount; ++i) {
                        parameters[i].writeTo(pos);
                        byte[] addPart = queryParts.get(i + 2);
                        pos.write(addPart, 0, addPart.length);
                    }
                    ++index;
                    continue;
                }
                pos.write(44);
                pos.write(secondPart, 0, secondPart.length);
                for (int i = 0; i < paramCount; ++i) {
                    parameters[i].writeTo(pos);
                    pos.write(queryParts.get(i + 2));
                }
                ++index;
                break;
            }
            pos.write(queryParts.get(paramCount + 2));
        }
        pos.flush();
        return index;
    }

    public static int sendBatchAggregateSemiColon(PacketOutputStream writer, String firstQuery, List<String> queries, int currentIndex) throws IOException {
        byte[] sqlByte;
        int index;
        writer.startPacket(0);
        writer.write(3);
        writer.write(firstQuery.getBytes(StandardCharsets.UTF_8));
        for (index = currentIndex; index < queries.size() && writer.checkRemainingSize((sqlByte = queries.get(index).getBytes(StandardCharsets.UTF_8)).length + 1); ++index) {
            writer.write(59);
            writer.write(sqlByte);
        }
        writer.flush();
        return index;
    }

    public static void sendDirect(PacketOutputStream pos, byte[] sqlBytes) throws IOException {
        pos.startPacket(0);
        pos.write(3);
        pos.write(sqlBytes);
        pos.flush();
    }

    public static void sendDirect(PacketOutputStream pos, byte[] sqlBytes, int queryTimeout) throws IOException {
        pos.startPacket(0);
        pos.write(3);
        if (queryTimeout > 0) {
            pos.write(("SET STATEMENT max_statement_time=" + queryTimeout + " FOR ").getBytes());
        }
        pos.write(sqlBytes);
        pos.flush();
    }

    public static void sendMultiDirect(PacketOutputStream pos, List<byte[]> sqlBytes) throws IOException {
        pos.startPacket(0);
        pos.write(3);
        for (byte[] bytes : sqlBytes) {
            pos.write(bytes);
        }
        pos.flush();
    }

    public static void sendMultiDirect(PacketOutputStream pos, List<byte[]> sqlBytes, int queryTimeout) throws IOException {
        pos.startPacket(0);
        pos.write(3);
        pos.write(("SET STATEMENT max_statement_time=" + queryTimeout + " FOR ").getBytes());
        for (byte[] bytes : sqlBytes) {
            pos.write(bytes);
        }
        pos.flush();
    }
}

