/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search;

import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.MethodNameMatchRequestor;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.search.DLTKSearchMethodNameMatch;
import org.eclipse.dltk.internal.core.search.DLTKSearchScope;
import org.eclipse.dltk.internal.core.search.IRestrictedAccessMethodRequestor;
import org.eclipse.dltk.internal.core.util.HandleFactory;
import org.eclipse.dltk.internal.core.util.HashtableOfArrayToObject;

public class MethodNameMatchRequestorWrapper
implements IRestrictedAccessMethodRequestor {
    MethodNameMatchRequestor requestor;
    private IDLTKSearchScope scope;
    private HandleFactory handleFactory;
    private String lastPkgFragmentRootPath;
    private IProjectFragment lastProjectFragment;
    private HashtableOfArrayToObject packageHandles;

    public MethodNameMatchRequestorWrapper(MethodNameMatchRequestor requestor, IDLTKSearchScope scope) {
        this.requestor = requestor;
        this.scope = scope;
        if (!(scope instanceof DLTKSearchScope)) {
            this.handleFactory = new HandleFactory();
        }
    }

    @Override
    public void acceptMethod(int modifiers, char[] packageName, char[] simpleMethodName, char[][] enclosingTypeNames, char[][] parameterNames, String path) {
        try {
            IMethod method = null;
            if (this.handleFactory != null) {
                Openable openable = this.handleFactory.createOpenable(path, this.scope);
                if (openable == null) {
                    return;
                }
                switch (openable.getElementType()) {
                    case 5: {
                        ISourceModule cu = (ISourceModule)((Object)openable);
                        method = cu.getMethod(new String(simpleMethodName));
                    }
                }
            } else {
                int separatorIndex = path.indexOf("|");
                IMethod iMethod = method = separatorIndex == -1 ? this.createMethodFromPath(path, new String(simpleMethodName)) : null;
                if (DLTKCore.DEBUG) {
                    System.err.println("TODO: Add types from zips...");
                }
            }
            if (method != null) {
                this.requestor.acceptMethodNameMatch(new DLTKSearchMethodNameMatch(method, method.getFlags()));
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    private IMethod createMethodFromPath(String resourcePath, String simpleMethodName) throws ModelException {
        String simpleName;
        ISourceModule unit;
        Object[] pkgName;
        Path resourcePath2;
        int rootPathLength = -1;
        if (this.lastPkgFragmentRootPath == null || !resourcePath.startsWith(this.lastPkgFragmentRootPath) || (rootPathLength = this.lastPkgFragmentRootPath.length()) <= 0 || resourcePath.charAt(rootPathLength) != '/') {
            IProjectFragment root = ((DLTKSearchScope)this.scope).projectFragment(resourcePath);
            if (root == null) {
                return null;
            }
            this.lastProjectFragment = root;
            this.lastPkgFragmentRootPath = this.lastProjectFragment.getPath().toString();
            this.packageHandles = new HashtableOfArrayToObject(5);
        }
        if (!(resourcePath2 = new Path(resourcePath)).toString().startsWith(this.lastPkgFragmentRootPath)) {
            return null;
        }
        String[] simpleNames = new Path(resourcePath = resourcePath.substring(this.lastPkgFragmentRootPath.length() + 1)).segments();
        int length = simpleNames.length - 1;
        if (length > 0) {
            pkgName = new String[length];
            System.arraycopy(simpleNames, 0, pkgName, 0, length);
        } else {
            pkgName = CharOperation.NO_STRINGS;
        }
        IScriptFolder pkgFragment = (IScriptFolder)this.packageHandles.get(pkgName);
        if (pkgFragment == null) {
            pkgFragment = this.lastProjectFragment.getScriptFolder(ScriptModelUtil.toPath((String[])pkgName));
            this.packageHandles.put(pkgName, pkgFragment);
        }
        if ((unit = pkgFragment.getSourceModule(simpleName = simpleNames[length])) == null) {
            return null;
        }
        return this.findMethod(unit, simpleMethodName);
    }

    private IMethod findMethod(ISourceModule unit, String simpleMethodName) throws ModelException {
        IModelElement[] elements = unit.getChildren();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getElementType() == 9) {
                IMethod function = (IMethod)elements[i];
                if (function.getElementName().equals(simpleMethodName)) {
                    return function;
                }
            } else if (elements[i].getElementType() == 7) {
                IType type = (IType)elements[i];
                IMethod[] methods = type.getMethods();
                int j = 0;
                while (j < methods.length) {
                    IMethod method = methods[j];
                    if (method.getElementName().equals(simpleMethodName)) {
                        return method;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }
}

