/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jsampler.CC;
import org.jsampler.event.SamplerChannelListEvent;
import org.jsampler.event.SamplerChannelListListener;
import org.jsampler.view.fantasia.Channel;
import org.jsampler.view.fantasia.ChannelOptionsView;
import org.jsampler.view.fantasia.ChannelView;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.FantasiaUtils;
import org.jsampler.view.fantasia.NormalChannelOptionsView;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.basic.FantasiaPainter;
import org.jsampler.view.fantasia.basic.PixmapButton;
import org.jsampler.view.fantasia.basic.PixmapPane;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.linuxsampler.lscp.SamplerChannel;

public class SmallChannelView
extends JPanel
implements ChannelView {
    private final Channel channel;
    private ChannelOptionsView channelOptionsView = null;
    private final ChannelScreen screen;
    private final Channel.PowerButton btnPower;
    private final MuteButton btnMute = new MuteButton();
    private final SoloButton btnSolo = new SoloButton();
    private final Channel.OptionsButton btnOptions;
    private final Vector<JComponent> components = new Vector();
    private final EventHandler eventHandler = new EventHandler();

    public SmallChannelView(Channel channel) {
        this.components.add(this);
        this.channel = channel;
        this.screen = new ChannelScreen(channel);
        this.btnPower = new Channel.PowerButton(channel);
        this.components.add(this.btnPower);
        this.btnOptions = new Channel.OptionsButton(channel);
        this.components.add(this.btnOptions);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEmptyBorder(1, 3, 0, 11));
        this.add(this.btnPower);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.createVSeparator());
        this.add(Box.createRigidArea(new Dimension(3, 0)));
        this.add(this.screen);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.createVSeparator());
        this.add(new FxSendsButton());
        this.add(this.createVSeparator());
        this.add(Box.createRigidArea(new Dimension(1, 0)));
        this.components.add(this.btnMute);
        this.components.add(this.btnSolo);
        this.add(this.btnMute);
        this.add(this.btnSolo);
        this.add(Box.createRigidArea(new Dimension(1, 0)));
        this.add(this.createVSeparator());
        this.add(Box.createRigidArea(new Dimension(8, 0)));
        this.add(this.btnOptions);
        this.setPreferredSize(new Dimension(420, 22));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.installView();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            super.paintComponent(graphics);
        }
        double d = this.getSize().getHeight();
        double d2 = this.getSize().getWidth();
        Color color = this.channel.isSelected() ? new Color(0x555555) : new Color(0x888888);
        Color color2 = this.channel.isSelected() ? new Color(0x606060) : new Color(0x707070);
        Graphics2D graphics2D = (Graphics2D)graphics;
        FantasiaPainter.paintGradient(graphics2D, 0.0, 0.0, d2 - 1.0, d - 1.0, color, color2);
        FantasiaPainter.paintOuterBorder(graphics2D, 0.0, 0.0, d2 - 1.0, d - 1.0, false, 0.27f, 0.11f, 0.64f, 0.2f);
    }

    @Override
    public ChannelView.Type getType() {
        return ChannelView.Type.SMALL;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void installView() {
        String string = "volMeasurementUnitDecibel";
        FantasiaPrefs.preferences().addPropertyChangeListener(string, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = FantasiaPrefs.preferences().getBoolProperty("volMeasurementUnitDecibel");
                SmallChannelView.this.screen.updateVolumeInfo();
            }
        });
        this.addEnhancedMouseListener(this.channel.getContextMenu());
        CC.getSamplerModel().addSamplerChannelListListener(this.getHandler());
        this.addEnhancedMouseListener(this.getHandler());
    }

    @Override
    public void uninstallView() {
        CC.getSamplerModel().removeSamplerChannelListListener(this.getHandler());
        this.screen.onDestroy();
        this.btnOptions.onDestroy();
        this.uninstallChannelOptionsView();
        this.removeEnhancedMouseListener(this.getHandler());
    }

    @Override
    public void installChannelOptionsView() {
        if (this.channelOptionsView != null) {
            return;
        }
        this.channelOptionsView = new NormalChannelOptionsView(this.channel);
        this.channelOptionsView.installView();
    }

    @Override
    public void uninstallChannelOptionsView() {
        if (this.channelOptionsView == null) {
            return;
        }
        this.channelOptionsView.uninstallView();
        this.channelOptionsView = null;
    }

    @Override
    public ChannelOptionsView getChannelOptionsView() {
        return this.channelOptionsView;
    }

    @Override
    public void updateChannelInfo() {
        SamplerChannel samplerChannel = this.channel.getChannelInfo();
        this.screen.updateScreenInfo(samplerChannel);
        this.screen.updateVolumeInfo();
        this.updateMuteIcon(samplerChannel);
        if (samplerChannel.isSoloChannel()) {
            this.btnSolo.setIcon(Res.gfxSoloSmallOn);
        } else {
            this.btnSolo.setIcon(Res.gfxSoloSmallOff);
        }
        boolean bl = samplerChannel.getEngine() != null;
        this.btnSolo.setEnabled(bl);
        this.btnMute.setEnabled(bl);
        if (this.getChannelOptionsView() != null) {
            this.getChannelOptionsView().updateChannelInfo();
        }
    }

    @Override
    public void updateStreamCount(int n) {
        this.screen.updateStreamCount(n);
    }

    @Override
    public void updateVoiceCount(int n) {
        this.screen.updateVoiceCount(n);
    }

    @Override
    public void expandChannel() {
        if (this.btnOptions.isSelected()) {
            return;
        }
        this.btnOptions.doClick();
    }

    @Override
    public boolean isOptionsButtonSelected() {
        return this.btnOptions.isSelected();
    }

    @Override
    public void setOptionsButtonSelected(boolean bl) {
        this.btnOptions.setSelected(bl);
    }

    @Override
    public void addEnhancedMouseListener(MouseListener mouseListener) {
        this.removeEnhancedMouseListener(mouseListener);
        for (JComponent jComponent : this.components) {
            jComponent.addMouseListener(mouseListener);
        }
        this.screen.addEnhancedMouseListener(mouseListener);
    }

    @Override
    public void removeEnhancedMouseListener(MouseListener mouseListener) {
        for (JComponent jComponent : this.components) {
            jComponent.removeMouseListener(mouseListener);
        }
        this.screen.removeEnhancedMouseListener(mouseListener);
    }

    private void updateMuteIcon(SamplerChannel samplerChannel) {
        if (samplerChannel.isMutedBySolo()) {
            this.btnMute.setIcon(Res.gfxMutedBySoloSmall);
        } else if (samplerChannel.isMuted()) {
            this.btnMute.setIcon(Res.gfxMuteSmallOn);
        } else {
            this.btnMute.setIcon(Res.gfxMuteSmallOff);
        }
    }

    protected JPanel createVSeparator() {
        PixmapPane pixmapPane = new PixmapPane(Res.gfxVLine);
        pixmapPane.setOpaque(false);
        pixmapPane.setPreferredSize(new Dimension(2, 22));
        pixmapPane.setMinimumSize(pixmapPane.getPreferredSize());
        pixmapPane.setMaximumSize(pixmapPane.getPreferredSize());
        return pixmapPane;
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    private class FxSendsButton
    extends PixmapButton
    implements ActionListener {
        FxSendsButton() {
            super(Res.gfxFx);
            this.setRolloverIcon(Res.gfxFxRO);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SmallChannelView.this.channel.showFxSendsDialog();
        }

        @Override
        public boolean contains(int n, int n2) {
            return n > 5 && n < 23 && n2 > 5 && n2 < 16;
        }
    }

    private static class ChannelInfoPane
    extends JPanel {
        private final Channel channel;
        private final JLabel lInfo;
        private int channelIndex = -1;
        private boolean showNumbering;
        private boolean showMidiInfo;

        ChannelInfoPane(Channel channel) {
            this.channel = channel;
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 0));
            this.lInfo = FantasiaUtils.createScreenLabel("");
            this.lInfo.setFont(Res.fontScreenMono);
            this.updateChannelIndex();
            this.updateLabelLength();
            this.add(this.lInfo);
        }

        private void updateLabelLength() {
            this.lInfo.setPreferredSize(null);
            int n = 0;
            if (this.getShowNumbering()) {
                n += 4;
            }
            if (this.channelIndex > 98) {
                ++n;
            }
            if (this.getShowMidiInfo()) {
                n += 6;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("0");
            }
            this.lInfo.setText(stringBuffer.toString());
            this.lInfo.setPreferredSize(this.lInfo.getPreferredSize());
            this.lInfo.setMinimumSize(this.lInfo.getPreferredSize());
            this.lInfo.setMaximumSize(this.lInfo.getPreferredSize());
        }

        protected void updateChannelInfo() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getShowNumbering()) {
                if (this.channelIndex < 9) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.channelIndex + 1).append(": ");
            }
            if (this.getShowMidiInfo()) {
                SamplerChannel samplerChannel = this.channel.getChannelInfo();
                if (samplerChannel.getMidiInputDevice() == -1) {
                    stringBuffer.append("-/-");
                } else {
                    stringBuffer.append(samplerChannel.getMidiInputPort()).append("/");
                    if (samplerChannel.getMidiInputChannel() == -1) {
                        stringBuffer.append("All");
                    } else {
                        stringBuffer.append(samplerChannel.getMidiInputChannel() + 1);
                    }
                }
            }
            this.lInfo.setText(stringBuffer.toString());
        }

        protected void updateChannelIndex() {
            int n = CC.getMainFrame().getChannelNumber(this.channel.getModel());
            boolean bl = false;
            if (n > 98 && this.channelIndex <= 98) {
                bl = true;
            }
            if (n < 99 && this.channelIndex >= 99) {
                bl = true;
            }
            this.channelIndex = n;
            if (bl) {
                this.updateLabelLength();
            }
            if (!this.getShowNumbering()) {
                return;
            }
            this.updateChannelInfo();
        }

        protected boolean getShowNumbering() {
            return this.showNumbering;
        }

        protected void setShowNumbering(boolean bl) {
            if (bl == this.showNumbering) {
                return;
            }
            this.showNumbering = bl;
            this.updateLabelLength();
            this.updateChannelIndex();
        }

        protected boolean getShowMidiInfo() {
            return this.showMidiInfo;
        }

        protected void setShowMidiInfo(boolean bl) {
            if (bl == this.showMidiInfo) {
                return;
            }
            this.showMidiInfo = bl;
            String string = bl ? FantasiaI18n.i18n.getLabel("SmallChannelView.ttMidiPortChannel") : null;
            this.lInfo.setToolTipText(string);
            this.updateLabelLength();
            this.updateChannelInfo();
        }
    }

    static class ChannelScreen
    extends PixmapPane {
        private final Channel channel;
        private final ChannelInfoPane channelInfoPane;
        private final Channel.StreamVoiceCountPane streamVoiceCountPane;
        private final Channel.VolumePane volumePane;
        private JButton btnInstr = FantasiaUtils.createScreenButton(FantasiaI18n.i18n.getButtonLabel("ChannelScreen.btnInstr"));
        private static Insets pixmapInsets = new Insets(5, 5, 4, 5);
        private final Vector<JComponent> components = new Vector();
        private final PropertyChangeListener chnNumberingListener;
        private final PropertyChangeListener showMidiInfoListener;
        private final PropertyChangeListener showStreamVoiceCountListener;
        private boolean bShowNumbering;
        private boolean bShowMidiInfo;

        ChannelScreen(final Channel channel) {
            super(Res.gfxTextField);
            this.components.add(this);
            this.channel = channel;
            this.streamVoiceCountPane = new Channel.StreamVoiceCountPane(channel);
            this.components.add(this.streamVoiceCountPane);
            this.channelInfoPane = new ChannelInfoPane(channel);
            this.volumePane = new Channel.VolumePane(channel);
            this.components.add(this.volumePane);
            this.setPixmapInsets(pixmapInsets);
            this.setBorder(BorderFactory.createEmptyBorder(4, 3, 3, 4));
            this.setLayout(new BoxLayout(this, 0));
            JPanel jPanel = new JPanel();
            this.components.add(jPanel);
            jPanel.setOpaque(false);
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(this.channelInfoPane);
            this.btnInstr.setRolloverEnabled(false);
            this.btnInstr.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.btnInstr.setHorizontalAlignment(2);
            int n = this.btnInstr.getPreferredSize().height;
            this.btnInstr.setPreferredSize(new Dimension(100, n));
            this.btnInstr.setMinimumSize(this.btnInstr.getPreferredSize());
            this.btnInstr.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
            this.components.add(this.btnInstr);
            jPanel.add(this.btnInstr);
            jPanel.add(this.streamVoiceCountPane);
            n = jPanel.getPreferredSize().height;
            jPanel.setPreferredSize(new Dimension(201, n));
            jPanel.setMinimumSize(jPanel.getPreferredSize());
            jPanel.setMaximumSize(jPanel.getPreferredSize());
            this.add(jPanel);
            this.add(Box.createRigidArea(new Dimension(3, 0)));
            this.add(this.volumePane);
            this.setPreferredSize(new Dimension(270, this.getPreferredSize().height));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.btnInstr.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    channel.loadInstrument();
                }
            });
            this.chnNumberingListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    bShowNumbering = FantasiaPrefs.preferences().getBoolProperty("channel.smallView.showChannelNumbering");
                    channelInfoPane.setShowNumbering(bShowNumbering);
                }
            };
            FantasiaPrefs.preferences().addPropertyChangeListener("channel.smallView.showChannelNumbering", this.chnNumberingListener);
            this.bShowNumbering = FantasiaPrefs.preferences().getBoolProperty("channel.smallView.showChannelNumbering");
            this.channelInfoPane.setShowNumbering(this.bShowNumbering);
            this.showMidiInfoListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    bShowMidiInfo = FantasiaPrefs.preferences().getBoolProperty("channel.smallView.showMidiInfo");
                    channelInfoPane.setShowMidiInfo(bShowMidiInfo);
                }
            };
            FantasiaPrefs.preferences().addPropertyChangeListener("channel.smallView.showMidiInfo", this.showMidiInfoListener);
            this.bShowMidiInfo = FantasiaPrefs.preferences().getBoolProperty("channel.smallView.showMidiInfo");
            this.channelInfoPane.setShowMidiInfo(this.bShowMidiInfo);
            this.showStreamVoiceCountListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = FantasiaPrefs.preferences().getBoolProperty("channel.smallView.showStreamVoiceCount");
                    streamVoiceCountPane.setVisible(bl);
                }
            };
            FantasiaPrefs.preferences().addPropertyChangeListener("channel.smallView.showStreamVoiceCount", this.showStreamVoiceCountListener);
            boolean bl = FantasiaPrefs.preferences().getBoolProperty("channel.smallView.showStreamVoiceCount");
            this.streamVoiceCountPane.setVisible(bl);
        }

        public void addEnhancedMouseListener(MouseListener mouseListener) {
            this.removeEnhancedMouseListener(mouseListener);
            for (JComponent jComponent : this.components) {
                jComponent.addMouseListener(mouseListener);
            }
        }

        public void removeEnhancedMouseListener(MouseListener mouseListener) {
            for (JComponent jComponent : this.components) {
                jComponent.removeMouseListener(mouseListener);
            }
        }

        protected void updateVolumeInfo() {
            float f = this.channel.getChannelInfo().getVolume() * 100.0f;
            this.volumePane.updateVolumeInfo((int)f);
        }

        protected void updateStreamCount(int n) {
            this.streamVoiceCountPane.updateStreamCount(n);
        }

        protected void updateVoiceCount(int n) {
            this.streamVoiceCountPane.updateVoiceCount(n);
        }

        protected void updateScreenInfo(SamplerChannel samplerChannel) {
            String string = this.btnInstr.getToolTipText();
            int n = samplerChannel.getInstrumentStatus();
            if (n >= 0 && n < 100) {
                this.btnInstr.setText(FantasiaI18n.i18n.getLabel("ChannelScreen.loadingInstrument", n));
                if (string != null) {
                    this.btnInstr.setToolTipText(null);
                }
            } else if (n == -1) {
                this.btnInstr.setText(FantasiaI18n.i18n.getButtonLabel("ChannelScreen.btnInstr"));
                if (string != null) {
                    this.btnInstr.setToolTipText(null);
                }
            } else if (n < -1) {
                this.btnInstr.setText(FantasiaI18n.i18n.getLabel("ChannelScreen.errorLoadingInstrument"));
                if (string != null) {
                    this.btnInstr.setToolTipText(null);
                }
            } else {
                if (samplerChannel.getInstrumentName() != null) {
                    this.btnInstr.setText(samplerChannel.getInstrumentName());
                } else {
                    this.btnInstr.setText(FantasiaI18n.i18n.getButtonLabel("ChannelScreen.btnInstr"));
                }
                this.btnInstr.setToolTipText(samplerChannel.getInstrumentName());
            }
            this.channelInfoPane.updateChannelInfo();
        }

        public void onDestroy() {
            String string = "channel.smallView.showChannelNumbering";
            FantasiaPrefs.preferences().removePropertyChangeListener(string, this.chnNumberingListener);
            string = "channel.smallView.showMidiInfo";
            FantasiaPrefs.preferences().removePropertyChangeListener(string, this.showMidiInfoListener);
            string = "channel.smallView.showStreamVoiceCount";
            FantasiaPrefs.preferences().removePropertyChangeListener(string, this.showStreamVoiceCountListener);
        }
    }

    private class SoloButton
    extends PixmapButton
    implements ActionListener {
        SoloButton() {
            super(Res.gfxSoloSmallOff);
            this.setDisabledIcon(SubstanceImageCreator.makeTransparent(this, Res.gfxSoloSmallOff, 0.4));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            SamplerChannel samplerChannel = SmallChannelView.this.channel.getChannelInfo();
            boolean bl2 = bl = !samplerChannel.isSoloChannel();
            if (bl) {
                this.setIcon(Res.gfxSoloSmallOn);
                if (samplerChannel.isMutedBySolo()) {
                    SmallChannelView.this.btnMute.setIcon(Res.gfxMuteSmallOff);
                }
            } else {
                this.setIcon(Res.gfxSoloSmallOff);
                if (!samplerChannel.isMuted() && CC.getSamplerModel().getSoloChannelCount() > 1) {
                    SmallChannelView.this.btnMute.setIcon(Res.gfxMutedBySoloSmall);
                }
            }
            SmallChannelView.this.channel.getModel().setBackendSolo(bl);
        }
    }

    private class MuteButton
    extends PixmapButton
    implements ActionListener {
        MuteButton() {
            super(Res.gfxMuteSmallOff);
            this.setDisabledIcon(SubstanceImageCreator.makeTransparent(this, Res.gfxMuteSmallOff, 0.4));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SamplerChannel samplerChannel = SmallChannelView.this.channel.getChannelInfo();
            boolean bl = true;
            if (samplerChannel.isMuted() && !samplerChannel.isMutedBySolo()) {
                bl = false;
                boolean bl2 = CC.getSamplerModel().hasSoloChannel();
                if (samplerChannel.isSoloChannel() || !bl2) {
                    this.setIcon(Res.gfxMuteSmallOff);
                } else {
                    this.setIcon(Res.gfxMutedBySoloSmall);
                }
            } else {
                this.setIcon(Res.gfxMuteSmallOn);
            }
            SmallChannelView.this.channel.getModel().setBackendMute(bl);
        }
    }

    private class EventHandler
    extends MouseAdapter
    implements SamplerChannelListListener {
        private EventHandler() {
        }

        @Override
        public void channelAdded(SamplerChannelListEvent samplerChannelListEvent) {
            if (CC.getSamplerModel().getChannelListIsAdjusting()) {
                return;
            }
            SmallChannelView.this.screen.channelInfoPane.updateChannelIndex();
        }

        @Override
        public void channelRemoved(SamplerChannelListEvent samplerChannelListEvent) {
            SmallChannelView.this.screen.channelInfoPane.updateChannelIndex();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3 && SmallChannelView.this.channel.isSelected()) {
                return;
            }
            CC.getMainFrame().getSelectedChannelsPane().processChannelSelection(SmallChannelView.this.channel, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
        }
    }
}

