/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2z1;

import SQLite.Database;
import SQLite.Exception;
import SQLite.JDBC2z1.JDBCResultSetMetaData;
import SQLite.JDBC2z1.JDBCStatement;
import SQLite.JDBC2z1.TableResultX;
import SQLite.Shell;
import SQLite.StringEncoder;
import SQLite.TableResult;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;

public class JDBCResultSet
implements ResultSet {
    private int row;
    protected TableResult tr;
    private JDBCStatement s;
    private JDBCResultSetMetaData md;
    private String lastg;
    private int updatable;
    private String uptable;
    private String[] pkcols;
    private int[] pkcoli;
    private static final int UPD_UNKNOWN = -1;
    private static final int UPD_NO = 0;
    private static final int UPD_INS = 1;
    private static final int UPD_INSUPDDEL = 2;
    private boolean oninsrow;
    private String[] rowbuf;
    private static final boolean nullrepl = Database.version().compareTo("2.5.0") < 0;

    public JDBCResultSet(TableResult tableResult, JDBCStatement jDBCStatement) {
        this.tr = tableResult;
        this.s = jDBCStatement;
        this.md = null;
        this.lastg = null;
        this.row = -1;
        this.updatable = -1;
        this.oninsrow = false;
        this.rowbuf = null;
    }

    public boolean isUpdatable() throws SQLException {
        if (this.updatable == -1) {
            try {
                JDBCResultSetMetaData jDBCResultSetMetaData = (JDBCResultSetMetaData)this.getMetaData();
                HashSet<String> hashSet = new HashSet<String>();
                String string = null;
                for (int i = 1; i <= this.tr.ncolumns; ++i) {
                    string = jDBCResultSetMetaData.getTableName(i);
                    hashSet.add(string);
                }
                if (hashSet.size() > 1 || string == null) {
                    this.updatable = 0;
                    throw new SQLException("view or join");
                }
                this.updatable = 1;
                this.uptable = string;
                JDBCResultSet jDBCResultSet = (JDBCResultSet)this.s.conn.getMetaData().getPrimaryKeys(null, null, this.uptable);
                if (jDBCResultSet.tr.nrows > 0) {
                    boolean bl = false;
                    this.pkcols = new String[jDBCResultSet.tr.nrows];
                    this.pkcoli = new int[jDBCResultSet.tr.nrows];
                    for (int i = 0; i < jDBCResultSet.tr.nrows; ++i) {
                        String[] stringArray = (String[])jDBCResultSet.tr.rows.elementAt(i);
                        this.pkcols[i] = stringArray[3];
                        try {
                            this.pkcoli[i] = this.findColumn(this.pkcols[i]) - 1;
                            continue;
                        }
                        catch (SQLException sQLException) {
                            bl = true;
                        }
                    }
                    if (!bl) {
                        this.updatable = 2;
                    }
                }
                jDBCResultSet.close();
            }
            catch (SQLException sQLException) {
                this.updatable = 0;
            }
        }
        if (this.updatable < 1) {
            throw new SQLException("result set not updatable");
        }
        return true;
    }

    public void fillRowbuf() throws SQLException {
        if (this.rowbuf == null) {
            if (this.row < 0) {
                throw new SQLException("cursor outside of result set");
            }
            this.rowbuf = new String[this.tr.ncolumns];
            System.arraycopy(this.tr.rows.elementAt(this.row), 0, this.rowbuf, 0, this.tr.ncolumns);
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.tr == null) {
            return false;
        }
        ++this.row;
        return this.row < this.tr.nrows;
    }

    @Override
    public int findColumn(String string) throws SQLException {
        JDBCResultSetMetaData jDBCResultSetMetaData = (JDBCResultSetMetaData)this.getMetaData();
        return jDBCResultSetMetaData.findColByName(string);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.tr == null) {
            throw new SQLException("no rows");
        }
        return this.row + 1;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.tr == null) {
            throw new SQLException("result set already closed");
        }
        if (this.row >= 0) {
            --this.row;
        }
        return this.row >= 0;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (this.tr == null) {
            return false;
        }
        if (n < 0) {
            n = this.tr.nrows + 1 + n;
        }
        if (--n < 0 || n > this.tr.nrows) {
            return false;
        }
        this.row = n;
        return true;
    }

    @Override
    public boolean relative(int n) throws SQLException {
        if (this.tr == null) {
            return false;
        }
        if (this.row + n < 0 || this.row + n >= this.tr.nrows) {
            return false;
        }
        this.row += n;
        return true;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw new SQLException("only forward fetch direction supported");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n != 1) {
            throw new SQLException("fetch size must be 1");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 1;
    }

    @Override
    public String getString(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        return this.lastg;
    }

    @Override
    public String getString(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getString(n);
    }

    @Override
    public int getInt(int n) throws SQLException {
        Integer n2 = this.internalGetInt(n);
        if (n2 != null) {
            return n2;
        }
        return 0;
    }

    private Integer internalGetInt(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Integer.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    @Override
    public int getInt(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInt(n);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        return this.getInt(n) == 1 || Boolean.parseBoolean(this.getString(n));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBoolean(n);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.md == null) {
            this.md = new JDBCResultSetMetaData(this);
        }
        return this.md;
    }

    @Override
    public short getShort(int n) throws SQLException {
        Short s = this.internalGetShort(n);
        if (s != null) {
            return s;
        }
        return 0;
    }

    private Short internalGetShort(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Short.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    @Override
    public short getShort(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getShort(n);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return this.internalGetTime(n, null);
    }

    /*
     * Loose catch block
     */
    private Time internalGetTime(int n, Calendar calendar) throws SQLException {
        block8: {
            if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
                throw new SQLException("column " + n + " not found");
            }
            String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
            this.lastg = stringArray[n - 1];
            if (!this.s.conn.useJulian) break block8;
            try {
                return new Time(Database.long_from_julian(this.lastg));
            }
            catch (java.lang.Exception exception) {
                return Time.valueOf(this.lastg);
            }
            {
                catch (java.lang.Exception exception) {
                    this.lastg = null;
                    return null;
                }
            }
        }
        try {
            return Time.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            return new Time(Database.long_from_julian(this.lastg));
        }
    }

    @Override
    public Time getTime(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.internalGetTime(n, calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n, calendar);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.internalGetTimestamp(n, null);
    }

    /*
     * Loose catch block
     */
    private Timestamp internalGetTimestamp(int n, Calendar calendar) throws SQLException {
        block8: {
            if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
                throw new SQLException("column " + n + " not found");
            }
            String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
            this.lastg = stringArray[n - 1];
            if (!this.s.conn.useJulian) break block8;
            try {
                return new Timestamp(Database.long_from_julian(this.lastg));
            }
            catch (java.lang.Exception exception) {
                return Timestamp.valueOf(this.lastg);
            }
            {
                catch (java.lang.Exception exception) {
                    this.lastg = null;
                    return null;
                }
            }
        }
        try {
            return Timestamp.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            return new Timestamp(Database.long_from_julian(this.lastg));
        }
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.internalGetTimestamp(n, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n, calendar);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return this.internalGetDate(n, null);
    }

    /*
     * Loose catch block
     */
    private Date internalGetDate(int n, Calendar calendar) throws SQLException {
        block8: {
            if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
                throw new SQLException("column " + n + " not found");
            }
            String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
            this.lastg = stringArray[n - 1];
            if (!this.s.conn.useJulian) break block8;
            try {
                return new Date(Database.long_from_julian(this.lastg));
            }
            catch (java.lang.Exception exception) {
                return Date.valueOf(this.lastg);
            }
            {
                catch (java.lang.Exception exception) {
                    this.lastg = null;
                    return null;
                }
            }
        }
        try {
            return Date.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            return new Date(Database.long_from_julian(this.lastg));
        }
    }

    @Override
    public Date getDate(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.internalGetDate(n, calendar);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n, calendar);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        Double d = this.internalGetDouble(n);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    private Double internalGetDouble(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Double.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    @Override
    public double getDouble(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDouble(n);
    }

    @Override
    public float getFloat(int n) throws SQLException {
        Float f = this.internalGetFloat(n);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    private Float internalGetFloat(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Float.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    @Override
    public float getFloat(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getFloat(n);
    }

    @Override
    public long getLong(int n) throws SQLException {
        Long l = this.internalGetLong(n);
        if (l != null) {
            return l;
        }
        return 0L;
    }

    private Long internalGetLong(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        try {
            return Long.valueOf(this.lastg);
        }
        catch (java.lang.Exception exception) {
            this.lastg = null;
            return null;
        }
    }

    @Override
    public long getLong(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getLong(n);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getUnicodeStream(n);
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getAsciiStream(n);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBigDecimal(n);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        int n2 = this.findColumn(string);
        return this.getBigDecimal(n2, n);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        byte[] byArray = this.getBytes(string);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public byte getByte(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getByte(n);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        byte[] byArray = null;
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        if (this.lastg != null) {
            byArray = StringEncoder.decode(this.lastg);
        }
        return byArray;
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBytes(n);
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        Object object = this.lastg;
        if (this.tr instanceof TableResultX) {
            switch (((TableResultX)this.tr).sql_type[n - 1]) {
                case 5: {
                    object = this.internalGetShort(n);
                    break;
                }
                case 4: {
                    object = this.internalGetInt(n);
                    break;
                }
                case 8: {
                    object = this.internalGetDouble(n);
                    break;
                }
                case 6: {
                    object = this.internalGetFloat(n);
                    break;
                }
                case -5: {
                    object = this.internalGetLong(n);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    object = this.getBytes(n);
                    break;
                }
                case 0: {
                    object = null;
                }
            }
        }
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n);
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Object getObject(String string, Map map) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n, map);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getRef(n);
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBlob(n);
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getClob(n);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getArray(n);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            char[] cArray = string.toCharArray();
            return new CharArrayReader(cArray);
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        String string2 = this.getString(string);
        if (string2 != null) {
            char[] cArray = string2.toCharArray();
            return new CharArrayReader(cArray);
        }
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastg == null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.tr == null) {
            return true;
        }
        return this.row == 0;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        return this.row < 0;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.tr == null) {
            return;
        }
        this.row = -1;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        this.row = 0;
        return true;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        return this.row >= this.tr.nrows;
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.tr == null) {
            return;
        }
        this.row = this.tr.nrows;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.tr == null) {
            return true;
        }
        return this.row == this.tr.nrows - 1;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        this.row = this.tr.nrows - 1;
        return true;
    }

    @Override
    public int getType() throws SQLException {
        return 1005;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1008;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void insertRow() throws SQLException {
        int n;
        this.isUpdatable();
        if (!this.oninsrow || this.rowbuf == null) {
            throw new SQLException("no insert data provided");
        }
        JDBCResultSetMetaData jDBCResultSetMetaData = (JDBCResultSetMetaData)this.getMetaData();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO ");
        stringBuilder.append(Shell.sql_quote_dbl(this.uptable));
        stringBuilder.append("(");
        for (n = 0; n < this.tr.ncolumns; ++n) {
            stringBuilder.append(Shell.sql_quote_dbl(jDBCResultSetMetaData.getColumnName(n + 1)));
            if (n >= this.tr.ncolumns - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(") VALUES(");
        for (n = 0; n < this.tr.ncolumns; ++n) {
            stringBuilder.append(nullrepl ? "'%q'" : "%Q");
            if (n >= this.tr.ncolumns - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        try {
            this.s.conn.db.exec(stringBuilder.toString(), null, this.rowbuf);
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
        this.tr.newrow(this.rowbuf);
        this.rowbuf = null;
        this.oninsrow = false;
        this.last();
    }

    @Override
    public void updateRow() throws SQLException {
        int n;
        this.isUpdatable();
        if (this.rowbuf == null) {
            throw new SQLException("no update data provided");
        }
        if (this.oninsrow) {
            throw new SQLException("cursor on insert row");
        }
        if (this.updatable < 2) {
            throw new SQLException("no primary key on table defined");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        JDBCResultSetMetaData jDBCResultSetMetaData = (JDBCResultSetMetaData)this.getMetaData();
        String[] stringArray2 = new String[this.tr.ncolumns + this.pkcols.length];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ");
        stringBuilder.append(Shell.sql_quote_dbl(this.uptable));
        stringBuilder.append(" SET ");
        for (n = 0; n < this.tr.ncolumns; ++n) {
            stringBuilder.append(Shell.sql_quote_dbl(jDBCResultSetMetaData.getColumnName(n + 1)));
            stringBuilder.append(" = " + (nullrepl ? "'%q'" : "%Q"));
            if (n < this.tr.ncolumns - 1) {
                stringBuilder.append(",");
            }
            stringArray2[n] = this.rowbuf[n];
        }
        stringBuilder.append(" WHERE ");
        int n2 = 0;
        while (n2 < this.pkcols.length) {
            stringBuilder.append(Shell.sql_quote_dbl(this.pkcols[n2]));
            stringBuilder.append(" = " + (nullrepl ? "'%q'" : "%Q"));
            if (n2 < this.pkcols.length - 1) {
                stringBuilder.append(" AND ");
            }
            stringArray2[n] = stringArray[this.pkcoli[n2]];
            ++n2;
            ++n;
        }
        try {
            this.s.conn.db.exec(stringBuilder.toString(), null, stringArray2);
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
        System.arraycopy(this.rowbuf, 0, stringArray, 0, this.rowbuf.length);
        this.rowbuf = null;
    }

    @Override
    public void deleteRow() throws SQLException {
        this.isUpdatable();
        if (this.oninsrow) {
            throw new SQLException("cursor on insert row");
        }
        if (this.updatable < 2) {
            throw new SQLException("no primary key on table defined");
        }
        this.fillRowbuf();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM ");
        stringBuilder.append(Shell.sql_quote_dbl(this.uptable));
        stringBuilder.append(" WHERE ");
        String[] stringArray = new String[this.pkcols.length];
        for (int i = 0; i < this.pkcols.length; ++i) {
            stringBuilder.append(Shell.sql_quote_dbl(this.pkcols[i]));
            stringBuilder.append(" = " + (nullrepl ? "'%q'" : "%Q"));
            if (i < this.pkcols.length - 1) {
                stringBuilder.append(" AND ");
            }
            stringArray[i] = this.rowbuf[this.pkcoli[i]];
        }
        try {
            this.s.conn.db.exec(stringBuilder.toString(), null, stringArray);
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
        this.rowbuf = null;
    }

    @Override
    public void refreshRow() throws SQLException {
        this.isUpdatable();
        if (this.oninsrow) {
            throw new SQLException("cursor on insert row");
        }
        if (this.updatable < 2) {
            throw new SQLException("no primary key on table defined");
        }
        JDBCResultSetMetaData jDBCResultSetMetaData = (JDBCResultSetMetaData)this.getMetaData();
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        for (int i = 0; i < this.tr.ncolumns; ++i) {
            stringBuilder.append(Shell.sql_quote_dbl(jDBCResultSetMetaData.getColumnName(i + 1)));
            if (i >= this.tr.ncolumns - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append(Shell.sql_quote_dbl(this.uptable));
        stringBuilder.append(" WHERE ");
        String[] stringArray2 = new String[this.pkcols.length];
        for (int i = 0; i < this.pkcols.length; ++i) {
            stringBuilder.append(Shell.sql_quote_dbl(this.pkcols[i]));
            stringBuilder.append(" = " + (nullrepl ? "'%q'" : "%Q"));
            if (i < this.pkcols.length - 1) {
                stringBuilder.append(" AND ");
            }
            stringArray2[i] = stringArray[this.pkcoli[i]];
        }
        TableResult tableResult = null;
        try {
            tableResult = this.s.conn.db.get_table(stringBuilder.toString(), stringArray2);
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
        if (tableResult.nrows != 1) {
            throw new SQLException("wrong size of result set; expected 1, got " + tableResult.nrows);
        }
        this.rowbuf = null;
        this.tr.rows.setElementAt(tableResult.rows.elementAt(0), this.row);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.rowbuf = null;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.isUpdatable();
        if (!this.oninsrow) {
            this.oninsrow = true;
            this.rowbuf = new String[this.tr.nrows];
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.oninsrow) {
            this.oninsrow = false;
            this.rowbuf = null;
        }
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = null;
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateString(n, bl ? "1" : "0");
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = Short.toString(s);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = Integer.toString(n2);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = Long.toString(l);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = Float.toString(f);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = Double.toString(d);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = string;
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = this.s.conn.db.is3() ? StringEncoder.encodeX(byArray) : StringEncoder.encode(byArray);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = date.toString();
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = time.toString();
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[n - 1] = timestamp.toString();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        this.updateString(n, object.toString());
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateString(n, object.toString());
    }

    @Override
    public void updateNull(String string) throws SQLException {
        int n = this.findColumn(string);
        this.updateNull(n);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        int n = this.findColumn(string);
        this.updateBoolean(n, bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        int n = this.findColumn(string);
        this.updateByte(n, by);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        int n = this.findColumn(string);
        this.updateShort(n, s);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        int n2 = this.findColumn(string);
        this.updateInt(n2, n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        int n = this.findColumn(string);
        this.updateLong(n, l);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        int n = this.findColumn(string);
        this.updateFloat(n, f);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        int n = this.findColumn(string);
        this.updateDouble(n, d);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        int n = this.findColumn(string);
        this.updateBigDecimal(n, bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        int n = this.findColumn(string);
        this.updateString(n, string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        int n = this.findColumn(string);
        this.updateBytes(n, byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        int n = this.findColumn(string);
        this.updateDate(n, date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        int n = this.findColumn(string);
        this.updateTime(n, time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        int n = this.findColumn(string);
        this.updateTimestamp(n, timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        int n2 = this.findColumn(string);
        this.updateAsciiStream(n2, inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        int n2 = this.findColumn(string);
        this.updateBinaryStream(n2, inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        int n2 = this.findColumn(string);
        this.updateCharacterStream(n2, reader, n);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        int n = this.findColumn(string);
        this.updateObject(n, object);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        int n2 = this.findColumn(string);
        this.updateObject(n2, object, n);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.s == null) {
            throw new SQLException("stale result set");
        }
        return this.s;
    }

    @Override
    public void close() throws SQLException {
        this.s = null;
        this.tr = null;
        this.lastg = null;
        this.oninsrow = false;
        this.rowbuf = null;
        this.row = -1;
    }

    @Override
    public URL getURL(int n) throws SQLException {
        if (this.tr == null || n < 1 || n > this.tr.ncolumns) {
            throw new SQLException("column " + n + " not found");
        }
        String[] stringArray = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = stringArray[n - 1];
        URL uRL = null;
        if (this.lastg == null) {
            return uRL;
        }
        try {
            uRL = new URL(this.lastg);
        }
        catch (java.lang.Exception exception) {
            uRL = null;
        }
        return uRL;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getURL(n);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        int n = this.findColumn(string);
        this.updateRef(n, ref);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        int n = this.findColumn(string);
        this.updateBlob(n, blob);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        int n = this.findColumn(string);
        this.updateClob(n, clob);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        int n = this.findColumn(string);
        this.updateArray(n, array);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getRowId(n);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        int n = this.findColumn(string);
        this.updateRowId(n, rowId);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.tr == null;
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        int n = this.findColumn(string);
        this.updateNString(n, string2);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        int n = this.findColumn(string);
        this.updateNClob(n, nClob);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getNClob(n);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getSQLXML(n);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        int n = this.findColumn(string);
        this.updateSQLXML(n, sQLXML);
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getNString(n);
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getNCharacterStream(n);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        int n = this.findColumn(string);
        this.updateNCharacterStream(n, reader, l);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        int n = this.findColumn(string);
        this.updateAsciiStream(n, inputStream, l);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        int n = this.findColumn(string);
        this.updateBinaryStream(n, inputStream, l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        int n = this.findColumn(string);
        this.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        int n = this.findColumn(string);
        this.updateBlob(n, inputStream, l);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        int n = this.findColumn(string);
        this.updateClob(n, reader, l);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        int n = this.findColumn(string);
        this.updateNClob(n, reader, l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        int n = this.findColumn(string);
        this.updateNCharacterStream(n, reader);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        int n = this.findColumn(string);
        this.updateAsciiStream(n, inputStream);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        int n = this.findColumn(string);
        this.updateBinaryStream(n, inputStream);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        int n = this.findColumn(string);
        this.updateCharacterStream(n, reader);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        int n = this.findColumn(string);
        this.updateBlob(n, inputStream);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        int n = this.findColumn(string);
        this.updateClob(n, reader);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        int n = this.findColumn(string);
        this.updateNClob(n, reader);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException("unsupported");
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

