/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.FailoverInfo;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.util.HashMap;
import java.util.logging.Level;

final class FailoverMapSingleton {
    private static int INITIALHASHMAPSIZE = 5;
    private static HashMap<String, FailoverInfo> failoverMap = new HashMap(INITIALHASHMAPSIZE);

    private FailoverMapSingleton() {
    }

    private static String concatPrimaryDatabase(String primary, String instance, String database) {
        StringBuilder buf = new StringBuilder();
        buf.append(primary);
        if (null != instance) {
            buf.append("\\");
            buf.append(instance);
        }
        buf.append(";");
        buf.append(database);
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FailoverInfo getFailoverInfo(SQLServerConnection connection, String primaryServer, String instance, String database) {
        Class<FailoverMapSingleton> clazz = FailoverMapSingleton.class;
        synchronized (FailoverMapSingleton.class) {
            FailoverInfo fo;
            if (failoverMap.isEmpty()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return null;
            }
            String mapKey = FailoverMapSingleton.concatPrimaryDatabase(primaryServer, instance, database);
            if (connection.getConnectionLogger().isLoggable(Level.FINER)) {
                connection.getConnectionLogger().finer(connection.toString() + " Looking up info in the map using key: " + mapKey);
            }
            if (null != (fo = failoverMap.get(mapKey))) {
                fo.log(connection);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return fo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putFailoverInfo(SQLServerConnection connection, String primaryServer, String instance, String database, FailoverInfo actualFailoverInfo, boolean actualuseFailover, String failoverPartner) throws SQLServerException {
        Class<FailoverMapSingleton> clazz = FailoverMapSingleton.class;
        synchronized (FailoverMapSingleton.class) {
            FailoverInfo fo = FailoverMapSingleton.getFailoverInfo(connection, primaryServer, instance, database);
            if (null == fo) {
                if (connection.getConnectionLogger().isLoggable(Level.FINE)) {
                    connection.getConnectionLogger().fine(connection.toString() + " Failover map add server: " + primaryServer + "; database:" + database + "; Mirror:" + failoverPartner);
                }
                failoverMap.put(FailoverMapSingleton.concatPrimaryDatabase(primaryServer, instance, database), actualFailoverInfo);
            } else {
                fo.failoverAdd(connection, actualuseFailover, failoverPartner);
            }
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return;
        }
    }
}

