/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;

public class LogicalPackage
extends PlatformObject {
    private Set<IScriptFolder> fPackages;
    private String fName;
    private IScriptProject fScriptProject;

    public LogicalPackage(IScriptFolder fragment) {
        Assert.isNotNull((Object)fragment);
        this.fPackages = new HashSet<IScriptFolder>();
        this.fScriptProject = fragment.getScriptProject();
        Assert.isNotNull((Object)this.fScriptProject);
        this.add(fragment);
        this.fName = fragment.getElementName();
    }

    public IScriptProject getScriptProject() {
        return this.fScriptProject;
    }

    public IScriptFolder[] getScriptFolders() {
        return this.fPackages.toArray(new IScriptFolder[this.fPackages.size()]);
    }

    public void add(IScriptFolder fragment) {
        Assert.isTrue((fragment != null && this.fScriptProject.equals(fragment.getScriptProject()) ? 1 : 0) != 0);
        this.fPackages.add(fragment);
    }

    public void remove(IScriptFolder fragment) {
        this.fPackages.remove(fragment);
    }

    public boolean contains(IScriptFolder fragment) {
        return this.fPackages.contains(fragment);
    }

    public String getElementName() {
        return this.fName;
    }

    public int size() {
        return this.fPackages.size();
    }

    public boolean belongs(IScriptFolder fragment) {
        if (fragment == null) {
            return false;
        }
        if (this.fScriptProject.equals(fragment.getScriptProject())) {
            return this.fName.equals(fragment.getElementName());
        }
        return false;
    }

    public boolean hasSubpackages() throws ModelException {
        for (IScriptFolder pack : this.fPackages) {
            if (!pack.hasSubfolders()) continue;
            return true;
        }
        return false;
    }

    public boolean isDefaultPackage() {
        return this.fName.length() == 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LogicalPackage)) {
            return false;
        }
        LogicalPackage lp = (LogicalPackage)((Object)o);
        if (!this.fScriptProject.equals(lp.getScriptProject())) {
            return false;
        }
        IScriptFolder[] fragments = lp.getScriptFolders();
        if (fragments.length != this.getScriptFolders().length) {
            return false;
        }
        int i = 0;
        while (i < fragments.length) {
            IScriptFolder fragment = fragments[i];
            if (!this.fPackages.contains(fragment)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        IScriptFolder[] fragments = this.getScriptFolders();
        return this.fScriptProject.hashCode() + this.getHash(fragments, fragments.length - 1);
    }

    private int getHash(IScriptFolder[] fragments, int index) {
        if (index <= 0) {
            return fragments[0].hashCode() * 17;
        }
        return fragments[index].hashCode() * 17 + this.getHash(fragments, index - 1);
    }
}

