/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LaunchConfigurationStreamProvider;

public class ContentTypeToLSPLaunchConfigEntry
extends ContentTypeToLanguageServerDefinition {
    private ILaunchConfiguration launchConfiguration;
    private Set<String> launchModes;

    public ContentTypeToLSPLaunchConfigEntry(@NonNull IContentType contentType, @NonNull ILaunchConfiguration launchConfig, @NonNull Set<String> launchModes) {
        super(contentType, new LanguageServersRegistry.LaunchConfigurationLanguageServerDefinition(launchConfig, launchModes), null);
        this.launchConfiguration = launchConfig;
        this.launchModes = Collections.unmodifiableSet(launchModes);
    }

    public void appendPreferenceTo(StringBuilder builder) {
        builder.append(((IContentType)this.getKey()).getId());
        builder.append(':');
        try {
            builder.append(this.launchConfiguration.getType().getIdentifier());
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
        }
        builder.append('/');
        builder.append(this.launchConfiguration.getName());
        builder.append('/');
        for (String launchMode : this.launchModes) {
            builder.append(launchMode);
            builder.append('+');
        }
        builder.deleteCharAt(builder.length() - 1);
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    public Set<String> getLaunchModes() {
        return this.launchModes;
    }

    static ContentTypeToLSPLaunchConfigEntry readFromPreference(String preferenceEntry) {
        IContentType contentType;
        String[] parts = preferenceEntry.split(":");
        if (parts.length != 2) {
            return null;
        }
        String contentTypeId = parts[0];
        String[] launchParts = parts[1].split("/");
        String launchType = launchParts[0];
        String launchName = launchParts[1];
        Set<String> launchModes = Collections.singleton("run");
        if (launchParts.length > 2) {
            launchModes = new HashSet<String>(Arrays.asList(launchParts[2].split("\\+")));
        }
        if ((contentType = Platform.getContentTypeManager().getContentType(contentTypeId)) == null) {
            return null;
        }
        ILaunchConfiguration launchConfiguration = LaunchConfigurationStreamProvider.findLaunchConfiguration(launchType, launchName);
        if (launchConfiguration == null) {
            return null;
        }
        return new ContentTypeToLSPLaunchConfigEntry(contentType, launchConfiguration, launchModes);
    }
}

