/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.processors;

import java.util.List;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEvent;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.logging.aeri.core.IProblemState;

public class Processors {
    public static boolean shouldProcess(List<IProcessorDescriptor> descriptors, ILogEvent event) {
        return descriptors.stream().filter(processor -> Processors.shouldProcess(processor, event)).findFirst().isPresent();
    }

    public static boolean shouldProcess(IProcessorDescriptor descriptor, ILogEvent event) {
        IProblemState interest = event.getInterest();
        if (interest == null || interest.getNeedinfo() == null) {
            return false;
        }
        return Processors.canContribute(descriptor, event) && (Processors.needinfo(descriptor, interest) || Processors.wantsToContribue(descriptor, event));
    }

    private static boolean canContribute(IProcessorDescriptor descriptor, ILogEvent event) {
        return descriptor.getProcessor().canContribute(event.getStatus(), event.getContext());
    }

    private static boolean needinfo(IProcessorDescriptor descriptor, IProblemState interest) {
        return interest.getNeedinfo().contains((Object)descriptor.getDirective());
    }

    private static boolean wantsToContribue(IProcessorDescriptor descriptor, ILogEvent event) {
        return descriptor.getProcessor().wantsToContribute(event.getStatus(), event.getContext());
    }
}

