/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.parser.CalculatorParser;
import com.eteks.parser.CompilationException;
import com.eteks.parser.Function;
import com.eteks.parser.Interpreter;
import com.eteks.parser.Syntax;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.SwingTools;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class AutoCommitSpinner
extends JSpinner {
    public AutoCommitSpinner(SpinnerModel spinnerModel) {
        this(spinnerModel, null);
    }

    public AutoCommitSpinner(SpinnerModel spinnerModel, Format format) {
        this(spinnerModel, format, true);
    }

    public AutoCommitSpinner(SpinnerModel spinnerModel, Format format, final boolean bl) {
        super(spinnerModel);
        JComponent jComponent = this.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            final JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
            SwingTools.addAutoSelectionOnFocusGain(jFormattedTextField);
            if (jFormattedTextField.getFormatterFactory() instanceof DefaultFormatterFactory) {
                DefaultFormatterFactory defaultFormatterFactory = (DefaultFormatterFactory)jFormattedTextField.getFormatterFactory();
                JFormattedTextField.AbstractFormatter abstractFormatter = defaultFormatterFactory.getDefaultFormatter();
                if (abstractFormatter instanceof DefaultFormatter) {
                    ((DefaultFormatter)abstractFormatter).setCommitsOnValidEdit(true);
                }
                if (abstractFormatter instanceof NumberFormatter) {
                    final NumberFormatter numberFormatter = (NumberFormatter)abstractFormatter;
                    NumberFormatter numberFormatter2 = new NumberFormatter(){
                        private boolean keepFocusedTextUnchanged;
                        {
                            final KeyAdapter keyAdapter = new KeyAdapter(){

                                @Override
                                public void keyTyped(KeyEvent keyEvent) {
                                    keepFocusedTextUnchanged = true;
                                }
                            };
                            jFormattedTextField.addFocusListener(new FocusAdapter(){

                                @Override
                                public void focusGained(FocusEvent focusEvent) {
                                    jFormattedTextField.addKeyListener(keyAdapter);
                                }

                                @Override
                                public void focusLost(FocusEvent focusEvent) {
                                    jFormattedTextField.removeKeyListener(keyAdapter);
                                }
                            });
                        }

                        @Override
                        public Format getFormat() {
                            Format format = super.getFormat();
                            if (jFormattedTextField.hasFocus() && format instanceof DecimalFormat) {
                                DecimalFormat decimalFormat = (DecimalFormat)format.clone();
                                decimalFormat.setGroupingUsed(false);
                                try {
                                    if (bl) {
                                        return new CalculatorFormat(decimalFormat);
                                    }
                                }
                                catch (LinkageError linkageError) {
                                    // empty catch block
                                }
                                return decimalFormat;
                            }
                            return format;
                        }

                        public Comparable getMaximum() {
                            return numberFormatter.getMaximum();
                        }

                        public Comparable getMinimum() {
                            return numberFormatter.getMinimum();
                        }

                        public void setMaximum(Comparable comparable) {
                            numberFormatter.setMaximum(comparable);
                        }

                        public void setMinimum(Comparable comparable) {
                            numberFormatter.setMinimum(comparable);
                        }

                        @Override
                        public Class<?> getValueClass() {
                            return numberFormatter.getValueClass();
                        }

                        @Override
                        public String valueToString(Object object) throws ParseException {
                            if (jFormattedTextField.hasFocus() && this.keepFocusedTextUnchanged) {
                                this.keepFocusedTextUnchanged = false;
                                return jFormattedTextField.getText();
                            }
                            return super.valueToString(object);
                        }
                    };
                    numberFormatter2.setCommitsOnValidEdit(true);
                    jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter2));
                    jFormattedTextField.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusLost(FocusEvent focusEvent) {
                            jFormattedTextField.setForeground(UIManager.getColor("FormattedTextField.foreground"));
                        }
                    });
                }
            }
        }
        if (format != null) {
            this.setFormat(format);
        }
    }

    public void setFormat(Format format) {
        JFormattedTextField jFormattedTextField;
        JFormattedTextField.AbstractFormatter abstractFormatter;
        JComponent jComponent = this.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor && (abstractFormatter = (jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField()).getFormatter()) instanceof NumberFormatter) {
            ((NumberFormatter)abstractFormatter).setFormat(format);
            this.fireStateChanged();
        }
    }

    private static class CalculatorInterpreter
    implements Interpreter {
        private CalculatorInterpreter() {
        }

        public Object getLiteralValue(Object object) {
            return object;
        }

        public Object getParameterValue(Object object) {
            return null;
        }

        public Object getConstantValue(Object object) {
            return null;
        }

        public Double getUnaryOperatorValue(Object object, Object object2) {
            if (object.equals("-")) {
                return -((Number)object2).doubleValue();
            }
            throw new IllegalArgumentException("Not implemented");
        }

        public Double getBinaryOperatorValue(Object object, Object object2, Object object3) {
            if (object.equals("+")) {
                return ((Number)object2).doubleValue() + ((Number)object3).doubleValue();
            }
            if (object.equals("-")) {
                return ((Number)object2).doubleValue() - ((Number)object3).doubleValue();
            }
            if (object.equals("/")) {
                return ((Number)object2).doubleValue() / ((Number)object3).doubleValue();
            }
            if (object.equals("*")) {
                return ((Number)object2).doubleValue() * ((Number)object3).doubleValue();
            }
            if (object.equals("^")) {
                return Math.pow(((Number)object2).doubleValue(), ((Number)object3).doubleValue());
            }
            throw new IllegalArgumentException("Not implemented");
        }

        public Double getCommonFunctionValue(Object object, Object object2) {
            if (object.equals("LN")) {
                return Math.log(((Number)object2).doubleValue());
            }
            if (object.equals("LOG")) {
                return Math.log(((Number)object2).doubleValue()) / Math.log(10.0);
            }
            if (object.equals("EXP")) {
                return Math.exp(((Number)object2).doubleValue());
            }
            if (object.equals("SQR")) {
                return ((Number)object2).doubleValue() * ((Number)object2).doubleValue();
            }
            if (object.equals("SQRT")) {
                return Math.sqrt(((Number)object2).doubleValue());
            }
            if (object.equals("COS")) {
                return Math.cos(Math.toRadians(((Number)object2).doubleValue()));
            }
            if (object.equals("SIN")) {
                return Math.sin(Math.toRadians(((Number)object2).doubleValue()));
            }
            if (object.equals("TAN")) {
                return Math.tan(Math.toRadians(((Number)object2).doubleValue()));
            }
            if (object.equals("ARCCOS")) {
                return Math.toDegrees(Math.acos(((Number)object2).doubleValue()));
            }
            if (object.equals("ARCSIN")) {
                return Math.toDegrees(Math.asin(((Number)object2).doubleValue()));
            }
            if (object.equals("ARCTAN")) {
                return Math.toDegrees(Math.atan(((Number)object2).doubleValue()));
            }
            throw new IllegalArgumentException("Not implemented");
        }

        public Object getConditionValue(Object object, Object object2, Object object3) {
            return null;
        }

        public boolean isTrue(Object object) {
            return false;
        }

        public boolean supportsRecursiveCall() {
            return false;
        }

        public Object getFunctionValue(Function function, Object[] objectArray, boolean bl) {
            return null;
        }
    }

    private static class CalculatorSyntax
    implements Syntax {
        private final DecimalFormat format;
        private final LengthUnit lengthUnit;

        private CalculatorSyntax(DecimalFormat decimalFormat, LengthUnit lengthUnit) {
            this.format = decimalFormat;
            this.lengthUnit = lengthUnit;
        }

        public Object getLiteral(String string, StringBuffer stringBuffer) {
            ParsePosition parsePosition = new ParsePosition(0);
            Number number = this.format.parse(string, parsePosition);
            if (number != null && this.lengthUnit != null) {
                number = Float.valueOf(this.lengthUnit.centimeterToUnit(number.floatValue()));
            }
            stringBuffer.append(string, 0, parsePosition.getIndex());
            return number;
        }

        public Object getConstantKey(String string) {
            return null;
        }

        public Object getUnaryOperatorKey(String string) {
            if ("-".equals(string)) {
                return string;
            }
            return null;
        }

        public Object getBinaryOperatorKey(String string) {
            if ("+".equals(string) || "-".equals(string) || "/".equals(string) || "*".equals(string) || "^".equals(string)) {
                return string;
            }
            return null;
        }

        public Object getConditionPartKey(String string) {
            return null;
        }

        public int getConditionPartCount() {
            return 0;
        }

        public Object getCommonFunctionKey(String string) {
            if ("LN".equals(string = string.toUpperCase()) || "LOG".equals(string) || "EXP".equals(string) || "SQR".equals(string) || "SQRT".equals(string) || "COS".equals(string) || "SIN".equals(string) || "TAN".equals(string) || "ARCCOS".equals(string) || "ARCSIN".equals(string) || "ARCTAN".equals(string)) {
                return string;
            }
            return null;
        }

        public Function getFunction(String string) {
            return null;
        }

        public int getBinaryOperatorPriority(Object object) {
            if ("+".equals(object) || "-".equals(object)) {
                return 1;
            }
            if ("/".equals(object) || "*".equals(object)) {
                return 2;
            }
            if ("^".equals(object)) {
                return 3;
            }
            throw new IllegalArgumentException();
        }

        public String getAssignmentOperator() {
            return null;
        }

        public String getWhiteSpaceCharacters() {
            return " \t\n\r";
        }

        public char getOpeningBracket() {
            return '(';
        }

        public char getClosingBracket() {
            return ')';
        }

        public char getParameterSeparator() {
            return '\u0000';
        }

        public String getDelimiters() {
            return " \t\n\r-+*/^().";
        }

        public boolean isCaseSensitive() {
            return false;
        }

        public boolean isShortSyntax() {
            return true;
        }

        public boolean isValidIdentifier(String string) {
            return false;
        }
    }

    private class CalculatorFormat
    extends DecimalFormat {
        private DecimalFormat numberFormat;

        private CalculatorFormat(DecimalFormat decimalFormat) {
            super(decimalFormat.toPattern());
            this.numberFormat = decimalFormat;
        }

        @Override
        public Number parse(String string, ParsePosition parsePosition) {
            JFormattedTextField jFormattedTextField;
            Color color;
            String string2 = string.substring(parsePosition.getIndex());
            Number number = this.numberFormat.parse(string, parsePosition);
            if (number == null || parsePosition.getIndex() != string.length()) {
                color = AutoCommitSpinner.this.getModel() instanceof NullableSpinner.NullableSpinnerLengthModel ? ((NullableSpinner.NullableSpinnerLengthModel)AutoCommitSpinner.this.getModel()).getLengthUnit() : null;
                jFormattedTextField = new CalculatorParser((Syntax)new CalculatorSyntax(this.numberFormat, (LengthUnit)((Object)color)));
                try {
                    number = (Number)jFormattedTextField.computeExpression(string2, new CalculatorInterpreter());
                    if (number != null && color != null) {
                        number = Float.valueOf(((LengthUnit)((Object)color)).unitToCentimeter(number.floatValue()));
                    }
                    parsePosition.setIndex(string.length());
                }
                catch (CompilationException compilationException) {
                    // empty catch block
                }
            }
            if (Color.BLACK.equals(color = UIManager.getColor("FormattedTextField.foreground")) || Color.WHITE.equals(color)) {
                jFormattedTextField = ((JSpinner.DefaultEditor)AutoCommitSpinner.this.getEditor()).getTextField();
                NumberFormatter numberFormatter = (NumberFormatter)jFormattedTextField.getFormatter();
                if (parsePosition.getIndex() != string.length() && string.substring(parsePosition.getIndex()).trim().length() > 0 || number != null && (number.doubleValue() < ((Number)((Object)numberFormatter.getMinimum())).doubleValue() || number.doubleValue() > ((Number)((Object)numberFormatter.getMaximum())).doubleValue())) {
                    jFormattedTextField.setForeground(Color.RED.darker());
                } else {
                    jFormattedTextField.setForeground(color);
                }
            }
            return number;
        }

        @Override
        public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return this.numberFormat.format(d, stringBuffer, fieldPosition);
        }
    }

    public static class SpinnerModuloNumberModel
    extends SpinnerNumberModel {
        public SpinnerModuloNumberModel(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }

        @Override
        public Object getNextValue() {
            if (this.getNumber().intValue() + this.getStepSize().intValue() < ((Number)((Object)this.getMaximum())).intValue()) {
                return ((Number)super.getNextValue()).intValue();
            }
            return this.getNumber().intValue() + this.getStepSize().intValue() - ((Number)((Object)this.getMaximum())).intValue() + ((Number)((Object)this.getMinimum())).intValue();
        }

        @Override
        public Object getPreviousValue() {
            if (this.getNumber().intValue() - this.getStepSize().intValue() >= ((Number)((Object)this.getMinimum())).intValue()) {
                return ((Number)super.getPreviousValue()).intValue();
            }
            return this.getNumber().intValue() - this.getStepSize().intValue() - ((Number)((Object)this.getMinimum())).intValue() + ((Number)((Object)this.getMaximum())).intValue();
        }
    }
}

