/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CommitMessageI;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AdditionalPageAtBottomEditorCustomization;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.ErrorStripeEditorCustomization;
import com.intellij.ui.RightMarginEditorCustomization;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.WrapWhenTypingReachesRightMarginCustomization;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.commit.CommitMessageUi;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitMessage
extends JPanel
implements Disposable,
DataProvider,
CommitMessageUi,
CommitMessageI {
    public static final Key<CommitMessage> DATA_KEY = Key.create((String)"Vcs.CommitMessage.Panel");
    private static final EditorCustomization BACKGROUND_FROM_COLOR_SCHEME_CUSTOMIZATION = editor -> editor.setBackgroundColor(null);
    @NotNull
    private final EditorTextField myEditorField;
    @Nullable
    private final TitledSeparator mySeparator;
    @NotNull
    private List<ChangeList> myChangeLists;

    public CommitMessage(@NotNull Project project) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(0);
        }
        this(project, true, true, true);
    }

    public CommitMessage(@NotNull Project project, boolean withSeparator, boolean showToolbar, boolean runInspections) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myChangeLists = Collections.emptyList();
        this.myEditorField = CommitMessage.createCommitMessageEditor(project, runInspections);
        this.myEditorField.getDocument().putUserData(DATA_KEY, (Object)this);
        this.add((Component)this.myEditorField, "Center");
        if (withSeparator) {
            this.mySeparator = SeparatorFactory.createSeparator((String)VcsBundle.message((String)"label.commit.comment", (Object[])new Object[0]), (JComponent)this.myEditorField.getComponent());
            BorderLayoutPanel separatorPanel = JBUI.Panels.simplePanel().addToBottom((Component)this.mySeparator).addToTop(Box.createVerticalGlue());
            BorderLayoutPanel labelPanel = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)separatorPanel).withBorder(BorderFactory.createEmptyBorder());
            if (showToolbar) {
                labelPanel.addToRight((Component)this.createToolbar(true));
            }
            this.add((Component)labelPanel, "North");
        } else {
            this.mySeparator = null;
            if (showToolbar) {
                this.add((Component)this.createToolbar(false), "East");
            }
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.fixEditorBackgroundOnColorSchemeChange(project);
    }

    private void fixEditorBackgroundOnColorSchemeChange(@NotNull Project project) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(2);
        }
        project.getMessageBus().connect((Disposable)this).subscribe(EditorColorsManager.TOPIC, scheme -> {
            Editor editor = this.myEditorField.getEditor();
            if (editor instanceof EditorEx) {
                BACKGROUND_FROM_COLOR_SCHEME_CUSTOMIZATION.customize((EditorEx)editor);
            }
        });
    }

    @NotNull
    private JComponent createToolbar(boolean horizontal) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CommitMessage", CommitMessage.getToolbarActions(), horizontal);
        toolbar.updateActionsImmediately();
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.getComponent().setBorder(BorderFactory.createEmptyBorder());
        toolbar.setTargetComponent((JComponent)this);
        JComponent jComponent = toolbar.getComponent();
        if (jComponent == null) {
            CommitMessage.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CommitMessage.$$$reportNull$$$0(4);
        }
        if (VcsDataKeys.COMMIT_MESSAGE_CONTROL.is(dataId)) {
            return this;
        }
        return null;
    }

    public void setSeparatorText(@NotNull String text) {
        if (text == null) {
            CommitMessage.$$$reportNull$$$0(5);
        }
        if (this.mySeparator != null) {
            this.mySeparator.setText(text);
        }
    }

    public void setCommitMessage(@Nullable String currentDescription) {
        this.setText(currentDescription);
    }

    @Deprecated
    public static EditorTextField createCommitTextEditor(@NotNull Project project, boolean forceSpellCheckOn) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(6);
        }
        return CommitMessage.createCommitMessageEditor(project, false);
    }

    @NotNull
    private static EditorTextField createCommitMessageEditor(@NotNull Project project, boolean runInspections) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(7);
        }
        HashSet<Object> features = new HashSet<Object>();
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)project);
        if (configuration != null) {
            features.add(new RightMarginEditorCustomization(configuration.USE_COMMIT_MESSAGE_MARGIN, CommitMessageInspectionProfile.getBodyRightMargin(project)));
            features.add(WrapWhenTypingReachesRightMarginCustomization.getInstance((boolean)configuration.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN));
        } else {
            features.add(new RightMarginEditorCustomization(false, -1));
        }
        features.add(SoftWrapsEditorCustomization.ENABLED);
        features.add(AdditionalPageAtBottomEditorCustomization.DISABLED);
        features.add(BACKGROUND_FROM_COLOR_SCHEME_CUSTOMIZATION);
        if (runInspections) {
            features.add(ErrorStripeEditorCustomization.ENABLED);
            features.add(new InspectionCustomization(project));
        } else {
            ContainerUtil.addIfNotNull(features, (Object)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization());
        }
        EditorTextField editorField = EditorTextFieldProvider.getInstance().getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project, features);
        editorField.setFontInheritedFromLAF(false);
        EditorTextField editorTextField = editorField;
        if (editorTextField == null) {
            CommitMessage.$$$reportNull$$$0(8);
        }
        return editorTextField;
    }

    public static boolean isCommitMessage(@NotNull PsiElement element) {
        Document document;
        if (element == null) {
            CommitMessage.$$$reportNull$$$0(9);
        }
        return (document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile())) != null && document.getUserData(DATA_KEY) != null;
    }

    @Nullable
    public static Editor getEditor(@NotNull Document document) {
        CommitMessage commitMessage2;
        if (document == null) {
            CommitMessage.$$$reportNull$$$0(10);
        }
        return (commitMessage2 = (CommitMessage)document.getUserData(DATA_KEY)) != null ? commitMessage2.getEditorField().getEditor() : null;
    }

    @NotNull
    private static ActionGroup getToolbarActions() {
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("Vcs.MessageActionGroup");
        if (actionGroup == null) {
            CommitMessage.$$$reportNull$$$0(11);
        }
        return actionGroup;
    }

    @NotNull
    public EditorTextField getEditorField() {
        EditorTextField editorTextField = this.myEditorField;
        if (editorTextField == null) {
            CommitMessage.$$$reportNull$$$0(12);
        }
        return editorTextField;
    }

    @NotNull
    public String getText() {
        String string = this.getComment();
        if (string == null) {
            CommitMessage.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void setText(@Nullable String initialMessage) {
        this.myEditorField.setText(initialMessage == null ? "" : StringUtil.convertLineSeparators((String)initialMessage));
    }

    public void focus() {
        this.requestFocusInMessage();
    }

    @NotNull
    public String getComment() {
        String string = StringUtil.trimTrailing((String)this.myEditorField.getDocument().getCharsSequence().toString());
        if (string == null) {
            CommitMessage.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void requestFocusInMessage() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditorField, true));
        this.myEditorField.selectAll();
    }

    public void dispose() {
    }

    public synchronized void setChangeList(@NotNull ChangeList value) {
        if (value == null) {
            CommitMessage.$$$reportNull$$$0(15);
        }
        this.setChangeLists(Collections.singletonList(value));
    }

    public synchronized void setChangeLists(@NotNull List<ChangeList> value) {
        if (value == null) {
            CommitMessage.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myChangeLists = ContainerUtil.newUnmodifiableList(value);
    }

    @NotNull
    public synchronized List<ChangeList> getChangeLists() {
        List<ChangeList> list = this.myChangeLists;
        if (list == null) {
            CommitMessage.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ui/CommitMessage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitMessageEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorField";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getComment";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fixEditorBackgroundOnColorSchemeChange";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSeparatorText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCommitTextEditor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCommitMessageEditor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCommitMessage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setChangeList";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setChangeLists";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConditionalTrafficLightRenderer
    extends TrafficLightRenderer {
        ConditionalTrafficLightRenderer(@NotNull Project project, @NotNull Document document, @Nullable PsiFile file) {
            if (project == null) {
                ConditionalTrafficLightRenderer.$$$reportNull$$$0(0);
            }
            if (document == null) {
                ConditionalTrafficLightRenderer.$$$reportNull$$$0(1);
            }
            super(project, document, file);
        }

        protected void refresh(@Nullable EditorMarkupModelImpl editorMarkupModel) {
            super.refresh(editorMarkupModel);
            if (editorMarkupModel != null) {
                editorMarkupModel.setTrafficLightIconVisible(this.hasHighSeverities(this.errorCount));
            }
        }

        private boolean hasHighSeverities(@NotNull int[] errorCount) {
            if (errorCount == null) {
                ConditionalTrafficLightRenderer.$$$reportNull$$$0(2);
            }
            HighlightSeverity minSeverity = ((HighlightDisplayLevel)ObjectUtils.notNull((Object)HighlightDisplayLevel.find((String)"TYPO"), (Object)HighlightDisplayLevel.DO_NOT_SHOW)).getSeverity();
            for (int i = 0; i < errorCount.length; ++i) {
                if (errorCount[i] <= 0 || this.getSeverityRegistrar().compare(this.getSeverityRegistrar().getSeverityByIndex(i), minSeverity) <= 0) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorCount";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage$ConditionalTrafficLightRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasHighSeverities";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InspectionCustomization
    implements EditorCustomization {
        @NotNull
        private final Project myProject;

        InspectionCustomization(@NotNull Project project) {
            if (project == null) {
                InspectionCustomization.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void customize(@NotNull EditorEx editor) {
            PsiFile file;
            if (editor == null) {
                InspectionCustomization.$$$reportNull$$$0(1);
            }
            if ((file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)editor.getDocument())) != null) {
                file.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, profile -> new InspectionProfileWrapper((InspectionProfileImpl)CommitMessageInspectionProfile.getInstance(this.myProject)));
            }
            editor.putUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY, (Object)false);
            ((EditorMarkupModelImpl)editor.getMarkupModel()).setErrorStripeRenderer((ErrorStripeRenderer)new ConditionalTrafficLightRenderer(this.myProject, (Document)editor.getDocument(), file));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage$InspectionCustomization";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

