/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.ide.IdeView;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

class HeavyIdeaTestFixtureImpl
extends BaseFixture
implements HeavyIdeaTestFixture {
    private Project myProject;
    private final Set<File> myFilesToDelete;
    private IdeaTestApplication myApplication;
    private final Set<ModuleFixtureBuilder> myModuleFixtureBuilders;
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    private final String myName;
    private final boolean myIsDirectoryBasedProject;
    private SdkLeakTracker myOldSdks;

    HeavyIdeaTestFixtureImpl(@NotNull String name, boolean isDirectoryBasedProject) {
        if (name == null) {
            HeavyIdeaTestFixtureImpl.$$$reportNull$$$0(0);
        }
        this.myFilesToDelete = new HashSet<File>();
        this.myModuleFixtureBuilders = new LinkedHashSet<ModuleFixtureBuilder>();
        this.myName = name;
        this.myIsDirectoryBasedProject = isDirectoryBasedProject;
    }

    void addModuleFixtureBuilder(ModuleFixtureBuilder builder) {
        this.myModuleFixtureBuilders.add(builder);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.initApplication();
        this.setUpProject();
        EncodingManager.getInstance();
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        InjectedLanguageManagerImpl.pushInjectors((Project)this.getProject());
        this.myOldSdks = new SdkLeakTracker();
    }

    @Override
    public void tearDown() throws Exception {
        RunAll runAll = new RunAll(new ThrowableRunnable[0]);
        if (this.myProject != null) {
            runAll = runAll.append(() -> LightPlatformTestCase.doTearDown(this.getProject(), this.myApplication)).append(() -> {
                for (ModuleFixtureBuilder moduleFixtureBuilder : this.myModuleFixtureBuilders) {
                    moduleFixtureBuilder.getFixture().tearDown();
                }
            }).append(() -> EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> PlatformTestCase.closeAndDisposeProjectAndCheckThatNoOpenProjects(this.getProject())))).append(() -> InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)this.getProject())).append(() -> {
                this.myProject = null;
            });
        }
        JarFileSystemImpl.cleanupForNextTest();
        for (File fileToDelete : this.myFilesToDelete) {
            runAll = runAll.append(() -> {
                List errors = Files.walk(fileToDelete.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(x -> {
                    try {
                        Files.delete(x);
                        return null;
                    }
                    catch (IOException e) {
                        return e;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
                CompoundRuntimeException.throwIfNotEmpty(errors);
            });
        }
        runAll.append(() -> super.tearDown()).append(() -> {
            if (this.myEditorListenerTracker != null) {
                this.myEditorListenerTracker.checkListenersLeak();
            }
        }).append(() -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        }).append(LightPlatformTestCase::checkEditorsReleased).append(() -> {
            if (this.myOldSdks != null) {
                this.myOldSdks.checkForJdkTableLeaks();
            }
        }).append(() -> PlatformTestCase.cleanupApplicationCaches(null)).run();
    }

    private void setUpProject() throws IOException {
        File tempDirectory = FileUtil.createTempDirectory((String)this.myName, (String)"");
        PlatformTestCase.synchronizeTempDirVfs((VirtualFile)ObjectUtils.assertNotNull((Object)LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempDirectory)));
        this.myFilesToDelete.add(tempDirectory);
        String projectPath = this.generateProjectPath(tempDirectory);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        new Throwable(projectPath).printStackTrace(new PrintStream(buffer));
        this.myProject = PlatformTestCase.createProject(projectPath, buffer.toString());
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            ProjectManagerEx.getInstanceEx().openTestProject(this.myProject);
            for (ModuleFixtureBuilder moduleFixtureBuilder : this.myModuleFixtureBuilders) {
                moduleFixtureBuilder.getFixture().setUp();
            }
            LightPlatformTestCase.clearUncommittedDocuments(this.myProject);
            ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
        }));
    }

    @NotNull
    protected String generateProjectPath(@NotNull File tempDirectory) {
        if (tempDirectory == null) {
            HeavyIdeaTestFixtureImpl.$$$reportNull$$$0(1);
        }
        String suffix = this.myIsDirectoryBasedProject ? "" : ".ipr";
        String string = FileUtil.toSystemIndependentName((String)tempDirectory.getPath()) + "/" + this.myName + suffix;
        if (string == null) {
            HeavyIdeaTestFixtureImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void initApplication() {
        this.myApplication = IdeaTestApplication.getInstance();
        this.myApplication.setDataProvider(new MyDataProvider());
    }

    @Override
    public Project getProject() {
        Assert.assertNotNull((String)"setUp() should be called first", (Object)this.myProject);
        return this.myProject;
    }

    @Override
    public Module getModule() {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        return modules.length == 0 ? null : modules[0];
    }

    @Override
    public PsiFile addFileToProject(@NotNull @NonNls String rootPath, @NotNull @NonNls String relativePath, @NotNull @NonNls String fileText) throws IOException {
        if (rootPath == null) {
            HeavyIdeaTestFixtureImpl.$$$reportNull$$$0(3);
        }
        if (relativePath == null) {
            HeavyIdeaTestFixtureImpl.$$$reportNull$$$0(4);
        }
        if (fileText == null) {
            HeavyIdeaTestFixtureImpl.$$$reportNull$$$0(5);
        }
        VirtualFile dir = VfsUtil.createDirectories((String)(rootPath + "/" + PathUtil.getParentPath((String)relativePath)));
        VirtualFile[] virtualFile = new VirtualFile[1];
        WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
            virtualFile[0] = dir.createChildData((Object)this, StringUtil.getShortName((String)relativePath, (char)'/'));
            VfsUtil.saveText((VirtualFile)virtualFile[0], (String)fileText);
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        });
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateProjectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateProjectPath";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFileToProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            VirtualFile[] contentRoots;
            if (dataId == null) {
                MyDataProvider.$$$reportNull$$$0(0);
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return HeavyIdeaTestFixtureImpl.this.myProject;
            }
            if (CommonDataKeys.EDITOR.is(dataId) || OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
                if (HeavyIdeaTestFixtureImpl.this.myProject == null) {
                    return null;
                }
                return FileEditorManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.myProject).getSelectedTextEditor();
            }
            Editor editor = (Editor)this.getData(CommonDataKeys.EDITOR.getName());
            if (editor != null) {
                FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx((Project)HeavyIdeaTestFixtureImpl.this.myProject);
                return manager.getData(dataId, editor, editor.getCaretModel().getCurrentCaret());
            }
            if (LangDataKeys.IDE_VIEW.is(dataId) && (contentRoots = ProjectRootManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.myProject).getContentRoots()).length > 0) {
                final PsiDirectory psiDirectory = PsiManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.myProject).findDirectory(contentRoots[0]);
                return new IdeView(){

                    @NotNull
                    public PsiDirectory[] getDirectories() {
                        PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{psiDirectory};
                        if (psiDirectoryArray == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return psiDirectoryArray;
                    }

                    public PsiDirectory getOrChooseDirectory() {
                        return psiDirectory;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl$MyDataProvider$1", "getDirectories"));
                    }
                };
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl$MyDataProvider", "getData"));
        }
    }
}

