/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RefactoringUIUtil {
    public static final EditorSettingsProvider SELECT_ALL_ON_FOCUS = editor -> editor.addFocusListener(new FocusChangeListener(){

        @Override
        public void focusGained(@NotNull Editor editor) {
            if (editor == null) {
                1.$$$reportNull$$$0(0);
            }
            if (LookupManager.getActiveLookup(editor) == null) {
                editor.getSelectionModel().setSelection(0, editor.getDocument().getTextLength());
            }
        }

        @Override
        public void focusLost(@NotNull Editor editor) {
            if (editor == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "editor";
            objectArray2[1] = "com/intellij/refactoring/util/RefactoringUIUtil$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "focusGained";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "focusLost";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    });

    private RefactoringUIUtil() {
    }

    public static String getDescription(@NotNull PsiElement element, boolean includeParent) {
        if (element == null) {
            RefactoringUIUtil.$$$reportNull$$$0(0);
        }
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)(includeParent ? RefactoringDescriptionLocation.WITH_PARENT : RefactoringDescriptionLocation.WITHOUT_PARENT));
    }

    public static void processIncorrectOperation(Project project, IncorrectOperationException e) {
        int index;
        String message = e.getMessage();
        int n = index = message != null ? message.indexOf("java.io.IOException") : -1;
        if (index > 0) {
            message = message.substring(index + "java.io.IOException".length());
        }
        String s = message;
        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project, (String)s, (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon()));
    }

    public static String calculatePsiElementDescriptionList(PsiElement[] elements2) {
        Function presentationFun = element -> UsageViewUtil.getType(element) + " " + DescriptiveNameUtil.getDescriptiveName((PsiElement)element);
        return StringUtil.join((Collection)ContainerUtil.map2LinkedSet(Arrays.asList(elements2), (Function)presentationFun), (String)", ");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/RefactoringUIUtil", "getDescription"));
    }
}

