/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.IdeUpdateUsageTriggerCollector;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import java.io.File;
import java.io.IOException;
import org.jdom.JDOMException;

@Service
public final class UpdateCheckerService
implements Disposable {
    private static final Logger LOG = Logger.getInstance(UpdateCheckerService.class);
    private static final long CHECK_INTERVAL = 86400000L;
    static final String SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY = "ide.self.update.started.for.build";
    private static final String ERROR_LOG_FILE_NAME = "idea_updater_error.log";
    private final Alarm myCheckForUpdatesAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final Runnable myCheckRunnable = () -> UpdateChecker.updateAndShowResult().doWhenProcessed(() -> this.queueNextCheck(86400000L));

    public static UpdateCheckerService getInstance() {
        return (UpdateCheckerService)ServiceManager.getService(UpdateCheckerService.class);
    }

    public UpdateCheckerService() {
        Disposer.register((Disposable)this, (Disposable)this.myCheckForUpdatesAlarm);
    }

    void checkForUpdates() {
        UpdateCheckerService.checkIfPreviousUpdateFailed();
        UpdateCheckerService.updateDefaultChannel();
        this.scheduleFirstCheck();
        UpdateCheckerService.cleanupPatch();
        UpdateCheckerService.snapPackageNotification();
    }

    private static void updateDefaultChannel() {
        UpdateSettings settings = UpdateSettings.getInstance();
        ChannelStatus current = settings.getSelectedChannelStatus();
        LOG.info("channel: " + current.getCode());
        boolean eap = ApplicationInfoEx.getInstanceEx().isMajorEAP();
        if (eap && current != ChannelStatus.EAP && UpdateStrategyCustomization.getInstance().forceEapUpdateChannelForEapBuilds()) {
            settings.setSelectedChannelStatus(ChannelStatus.EAP);
            LOG.info("channel forced to 'eap'");
            if (!ConfigImportHelper.isFirstSession()) {
                String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
                String message = IdeBundle.message((String)"update.channel.enforced", (Object[])new Object[]{ChannelStatus.EAP});
                UpdateChecker.NOTIFICATIONS.createNotification(title, message, NotificationType.INFORMATION, null).notify(null);
            }
        }
        if (!eap && current == ChannelStatus.EAP && ConfigImportHelper.isConfigImported()) {
            settings.setSelectedChannelStatus(ChannelStatus.RELEASE);
            LOG.info("channel set to 'release'");
        }
    }

    private void scheduleFirstCheck() {
        UpdateSettings settings = UpdateSettings.getInstance();
        if (!settings.isCheckNeeded()) {
            return;
        }
        BuildNumber currentBuild = ApplicationInfo.getInstance().getBuild();
        BuildNumber lastBuildChecked = BuildNumber.fromString((String)settings.getLastBuildChecked());
        long timeSinceLastCheck = Math.max(System.currentTimeMillis() - settings.getLastTimeChecked(), 0L);
        if (lastBuildChecked == null || currentBuild.compareTo(lastBuildChecked) > 0 || timeSinceLastCheck >= 86400000L) {
            this.myCheckRunnable.run();
        } else {
            this.queueNextCheck(86400000L - timeSinceLastCheck);
        }
    }

    private static void cleanupPatch() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> UpdateInstaller.cleanupPatch());
    }

    private void queueNextCheck(long interval) {
        this.myCheckForUpdatesAlarm.addRequest(this.myCheckRunnable, interval);
    }

    private static void checkIfPreviousUpdateFailed() {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (ApplicationInfo.getInstance().getBuild().asString().equals(properties.getValue(SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY))) {
            File updateErrorsLog = new File(PathManager.getLogPath(), ERROR_LOG_FILE_NAME);
            try {
                if (updateErrorsLog.isFile() && !StringUtil.isEmptyOrSpaces((String)FileUtil.loadFile((File)updateErrorsLog))) {
                    IdeUpdateUsageTriggerCollector.trigger("update.failed");
                    LOG.info("Previous update of the IDE failed");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        properties.setValue(SELF_UPDATE_STARTED_FOR_BUILD_PROPERTY, null);
    }

    public void dispose() {
    }

    public void queueNextCheck() {
        this.queueNextCheck(86400000L);
    }

    public void cancelChecks() {
        this.myCheckForUpdatesAlarm.cancelAllRequests();
    }

    private static void snapPackageNotification() {
        UpdateSettings settings = UpdateSettings.getInstance();
        if (!settings.isCheckNeeded() || ExternalUpdateManager.ACTUAL != ExternalUpdateManager.SNAP) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            BuildNumber currentBuild = ApplicationInfo.getInstance().getBuild();
            BuildNumber lastBuildChecked = BuildNumber.fromString((String)settings.getLastBuildChecked());
            if (lastBuildChecked == null) {
                UpdateSettings.getInstance().saveLastCheckedInfo();
                return;
            }
            if (!currentBuild.equals((Object)lastBuildChecked)) {
                Product product;
                UpdatesInfo updatesInfo = null;
                try {
                    updatesInfo = UpdateChecker.getUpdatesInfo();
                }
                catch (IOException | JDOMException e) {
                    LOG.warn(e);
                }
                String blogPost = null;
                if (updatesInfo != null && (product = updatesInfo.get(currentBuild.getProductCode())) != null) {
                    block2: for (UpdateChannel channel : product.getChannels()) {
                        for (BuildInfo build2 : channel.getBuilds()) {
                            if (!currentBuild.equals((Object)build2.getNumber())) continue;
                            blogPost = build2.getBlogPost();
                            break block2;
                        }
                    }
                }
                String message = blogPost == null ? IdeBundle.message((String)"update.snap.message", (Object[])new Object[0]) : IdeBundle.message((String)"update.snap.message.with.blog.post", (Object[])new Object[]{StringUtil.escapeXmlEntities(blogPost)});
                UpdateChecker.NOTIFICATIONS.createNotification(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]), message, NotificationType.INFORMATION, NotificationListener.URL_OPENING_LISTENER).notify(null);
                UpdateSettings.getInstance().saveLastCheckedInfo();
            }
        });
    }
}

