/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ex;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathUtilEx {
    private static final Function<Module, Sdk> MODULE_JDK = module -> ModuleRootManager.getInstance((Module)module).getSdk();
    private static final Convertor<Sdk, String> JDK_VERSION = jdk -> StringUtil.notNullize((String)jdk.getVersionString());

    @Nullable
    public static Sdk getAnyJdk(@NotNull Project project) {
        if (project == null) {
            PathUtilEx.$$$reportNull$$$0(0);
        }
        return PathUtilEx.chooseJdk(project, Arrays.asList(ModuleManager.getInstance((Project)project).getModules()));
    }

    @Nullable
    public static Sdk chooseJdk(@NotNull Project project, @NotNull Collection<? extends Module> modules) {
        Sdk projectJdk;
        if (project == null) {
            PathUtilEx.$$$reportNull$$$0(1);
        }
        if (modules == null) {
            PathUtilEx.$$$reportNull$$$0(2);
        }
        if ((projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) != null) {
            return projectJdk;
        }
        return PathUtilEx.chooseJdk(modules);
    }

    @Nullable
    public static Sdk chooseJdk(@NotNull Collection<? extends Module> modules) {
        List jdks;
        if (modules == null) {
            PathUtilEx.$$$reportNull$$$0(3);
        }
        if ((jdks = ContainerUtil.skipNulls((Collection)ContainerUtil.map((Collection)ContainerUtil.skipNulls(modules), MODULE_JDK))).isEmpty()) {
            return null;
        }
        Collections.sort(jdks, ComparatorUtil.compareBy(JDK_VERSION, (Comparator)String.CASE_INSENSITIVE_ORDER));
        return (Sdk)jdks.get(jdks.size() - 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/projectRoots/ex/PathUtilEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnyJdk";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseJdk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

