/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AsyncFileChangeListenerBase
implements AsyncFileListener {
    protected abstract boolean isRelevant(String var1);

    protected abstract void prepareFileDeletion(@NotNull VirtualFile var1);

    protected abstract void updateFile(VirtualFile var1, VFileEvent var2);

    protected abstract void reset();

    protected abstract void apply();

    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(final @NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            AsyncFileChangeListenerBase.$$$reportNull$$$0(0);
        }
        try {
            for (VFileEvent vFileEvent : events) {
                VFileMoveEvent moveEvent;
                String newPath;
                ProgressManager.checkCanceled();
                if (vFileEvent instanceof VFileDeleteEvent) {
                    this.deleteRecursively(vFileEvent.getFile());
                    continue;
                }
                if (!this.isRelevant(vFileEvent.getPath())) continue;
                if (vFileEvent instanceof VFilePropertyChangeEvent) {
                    if (!AsyncFileChangeListenerBase.isRenamed(vFileEvent)) continue;
                    this.deleteRecursively(vFileEvent.getFile());
                    continue;
                }
                if (!(vFileEvent instanceof VFileMoveEvent) || this.isRelevant(newPath = (moveEvent = (VFileMoveEvent)vFileEvent).getNewParent().getPath() + "/" + moveEvent.getFile().getName())) continue;
                this.deleteRecursively(moveEvent.getFile());
            }
        }
        catch (ProcessCanceledException e) {
            this.reset();
            throw e;
        }
        return new AsyncFileListener.ChangeApplier(){

            public void beforeVfsChange() {
                AsyncFileChangeListenerBase.this.apply();
            }

            public void afterVfsChange() {
                AsyncFileChangeListenerBase.this.after(events);
            }
        };
    }

    private void deleteRecursively(VirtualFile f) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)f, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile f) {
                if (f == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (AsyncFileChangeListenerBase.this.isRelevant(f.getPath())) {
                    AsyncFileChangeListenerBase.this.prepareFileDeletion(f);
                }
                return true;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile f) {
                if (f == null) {
                    2.$$$reportNull$$$0(1);
                }
                return f.isDirectory() && f instanceof NewVirtualFile ? ((NewVirtualFile)f).iterInDbChildren() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "f";
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/AsyncFileChangeListenerBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            AsyncFileChangeListenerBase.$$$reportNull$$$0(1);
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile newChild;
            if (!this.isRelevant(vFileEvent.getPath())) continue;
            if (vFileEvent instanceof VFileCreateEvent) {
                VFileCreateEvent createEvent = (VFileCreateEvent)vFileEvent;
                newChild = createEvent.getParent().findChild(createEvent.getChildName());
                if (newChild == null) continue;
                this.updateFile(newChild, vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent) {
                VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                newChild = copyEvent.getNewParent().findChild(copyEvent.getNewChildName());
                if (newChild == null) continue;
                this.updateFile(newChild, vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFileContentChangeEvent) {
                this.updateFile(vFileEvent.getFile(), vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFilePropertyChangeEvent) {
                if (!AsyncFileChangeListenerBase.isRenamed(vFileEvent)) continue;
                this.updateFile(vFileEvent.getFile(), vFileEvent);
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent)) continue;
            this.updateFile(vFileEvent.getFile(), vFileEvent);
        }
        this.apply();
    }

    @Contract(pure=true)
    private static boolean isRenamed(VFileEvent each) {
        return ((VFilePropertyChangeEvent)each).getPropertyName().equals("name") && !Comparing.equal((Object)((VFilePropertyChangeEvent)each).getOldValue(), (Object)((VFilePropertyChangeEvent)each).getNewValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "events";
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/AsyncFileChangeListenerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareChange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

