/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.WeakTimerListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class ToolbarUpdater
implements Activatable {
    private final ActionManagerEx myActionManager;
    private final KeymapManagerEx myKeymapManager;
    private final JComponent myComponent;
    private final KeymapManagerListener myKeymapManagerListener;
    private final TimerListener myTimerListener;
    private final WeakTimerListener myWeakTimerListener;
    private boolean myListenersArmed;

    public ToolbarUpdater(@NotNull JComponent component) {
        if (component == null) {
            ToolbarUpdater.$$$reportNull$$$0(0);
        }
        this(KeymapManagerEx.getInstanceEx(), component);
    }

    public ToolbarUpdater(@NotNull KeymapManagerEx keymapManager2, @NotNull JComponent component) {
        if (keymapManager2 == null) {
            ToolbarUpdater.$$$reportNull$$$0(1);
        }
        if (component == null) {
            ToolbarUpdater.$$$reportNull$$$0(2);
        }
        this.myKeymapManagerListener = new MyKeymapManagerListener();
        this.myTimerListener = new MyTimerListener();
        this.myActionManager = ActionManagerEx.getInstanceEx();
        this.myKeymapManager = keymapManager2;
        this.myComponent = component;
        this.myWeakTimerListener = new WeakTimerListener(this.myTimerListener);
        new UiNotifyConnector((Component)component, (Activatable)this);
    }

    public void showNotify() {
        if (this.myListenersArmed) {
            return;
        }
        this.myListenersArmed = true;
        this.myActionManager.addTimerListener(500, (TimerListener)this.myWeakTimerListener);
        this.myActionManager.addTransparentTimerListener(500, (TimerListener)this.myWeakTimerListener);
        this.myKeymapManager.addWeakListener(this.myKeymapManagerListener);
        this.updateActionTooltips();
    }

    public void hideNotify() {
        if (!this.myListenersArmed) {
            return;
        }
        this.myListenersArmed = false;
        this.myActionManager.removeTimerListener((TimerListener)this.myWeakTimerListener);
        this.myActionManager.removeTransparentTimerListener((TimerListener)this.myWeakTimerListener);
        this.myKeymapManager.removeWeakListener(this.myKeymapManagerListener);
    }

    @NotNull
    public KeymapManagerEx getKeymapManager() {
        KeymapManagerEx keymapManagerEx = this.myKeymapManager;
        if (keymapManagerEx == null) {
            ToolbarUpdater.$$$reportNull$$$0(3);
        }
        return keymapManagerEx;
    }

    @NotNull
    public ActionManagerEx getActionManager() {
        ActionManagerEx actionManagerEx = this.myActionManager;
        if (actionManagerEx == null) {
            ToolbarUpdater.$$$reportNull$$$0(4);
        }
        return actionManagerEx;
    }

    public void updateActions(boolean now, boolean forced) {
        this.updateActions(now, false, forced);
    }

    private void updateActions(boolean now, boolean transparentOnly, boolean forced) {
        MyUpdateRunnable updateRunnable = new MyUpdateRunnable(this, transparentOnly, forced);
        Application app = ApplicationManager.getApplication();
        if (now || app.isUnitTestMode() && app.isDispatchThread()) {
            updateRunnable.run();
        } else {
            IdeFocusManager fm = IdeFocusManager.getInstance(null);
            if (!app.isHeadlessEnvironment()) {
                if (app.isDispatchThread() && this.myComponent.isShowing()) {
                    fm.doWhenFocusSettlesDown((Runnable)updateRunnable);
                } else {
                    UiNotifyConnector.doWhenFirstShown((JComponent)this.myComponent, () -> fm.doWhenFocusSettlesDown(updateRunnable));
                }
            }
        }
    }

    protected abstract void updateActionsImpl(boolean var1, boolean var2);

    protected void updateActionTooltips() {
        for (ActionButton actionButton : UIUtil.uiTraverser((Component)this.myComponent).preOrderDfsTraversal().filter(ActionButton.class)) {
            actionButton.updateToolTipText();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ToolbarUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ToolbarUpdater";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeymapManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyUpdateRunnable
    implements Runnable {
        private final boolean myTransparentOnly;
        private final boolean myForced;
        @NotNull
        private final WeakReference<ToolbarUpdater> myUpdaterRef;
        private final int myHash;

        MyUpdateRunnable(@NotNull ToolbarUpdater updater, boolean transparentOnly, boolean forced) {
            if (updater == null) {
                MyUpdateRunnable.$$$reportNull$$$0(0);
            }
            this.myTransparentOnly = transparentOnly;
            this.myForced = forced;
            this.myHash = updater.hashCode();
            this.myUpdaterRef = new WeakReference<ToolbarUpdater>(updater);
        }

        @Override
        public void run() {
            ToolbarUpdater updater = (ToolbarUpdater)this.myUpdaterRef.get();
            if (updater == null) {
                return;
            }
            if (!updater.myComponent.isVisible() && !ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            updater.updateActionsImpl(this.myTransparentOnly, this.myForced);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyUpdateRunnable)) {
                return false;
            }
            MyUpdateRunnable that = (MyUpdateRunnable)obj;
            if (this.myHash != that.myHash) {
                return false;
            }
            ToolbarUpdater updater1 = (ToolbarUpdater)this.myUpdaterRef.get();
            ToolbarUpdater updater2 = (ToolbarUpdater)that.myUpdaterRef.get();
            return Comparing.equal((Object)updater1, (Object)updater2);
        }

        public int hashCode() {
            return this.myHash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/openapi/actionSystem/impl/ToolbarUpdater$MyUpdateRunnable", "<init>"));
        }
    }

    private final class MyTimerListener
    implements TimerListener {
        private MyTimerListener() {
        }

        public ModalityState getModalityState() {
            return ModalityState.stateForComponent((Component)ToolbarUpdater.this.myComponent);
        }

        public void run() {
            if (!ToolbarUpdater.this.myComponent.isShowing()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
            if (selectedPath.length > 0) {
                return;
            }
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window instanceof Dialog && ((Dialog)window).isModal() && !SwingUtilities.isDescendingFrom(ToolbarUpdater.this.myComponent, window)) {
                return;
            }
            ToolbarUpdater.this.updateActions(false, ToolbarUpdater.this.myActionManager.isTransparentOnlyActionsUpdateNow(), false);
        }
    }

    private final class MyKeymapManagerListener
    implements KeymapManagerListener {
        private MyKeymapManagerListener() {
        }

        public void activeKeymapChanged(Keymap keymap) {
            ToolbarUpdater.this.updateActionTooltips();
        }
    }
}

