/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search.searchTask;

import com.intellij.find.FindManager;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.largeFilesEditor.search.searchTask.FrameSearcher;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskCallback;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskOptions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;

public abstract class SearchTaskBase
implements Runnable {
    protected final FileDataProviderForSearch fileDataProviderForSearch;
    protected final SearchTaskCallback callback;
    protected final SearchTaskOptions options;
    protected final Project project;
    private volatile boolean shouldStop = false;
    private boolean isFinished = false;

    public SearchTaskBase(SearchTaskOptions options, Project project, FileDataProviderForSearch fileDataProviderForSearch, SearchTaskCallback callback2) {
        this.project = project;
        this.callback = callback2;
        this.options = options;
        this.fileDataProviderForSearch = fileDataProviderForSearch;
    }

    public SearchTaskOptions getOptions() {
        return this.options;
    }

    @Override
    public final void run() {
        this.doRun();
        this.isFinished = true;
    }

    public final void shouldStop() {
        this.shouldStop = true;
    }

    public final boolean isShouldStop() {
        return this.shouldStop;
    }

    public final boolean isFinished() {
        return this.isFinished;
    }

    protected abstract void doRun();

    static long getPageNumberForBeginning(long pagesAmount, SearchTaskOptions options) {
        if (options.searchForwardDirection) {
            if (options.leftBoundPageNumber == -1L) {
                return 0L;
            }
            return options.leftBoundPageNumber;
        }
        if (options.rightBoundPageNumber == -1L) {
            return pagesAmount - 1L;
        }
        return options.rightBoundPageNumber;
    }

    static boolean isTheEndOfSearchingCycle(long curPageNumber, long pagesAmount, SearchTaskOptions options) {
        return curPageNumber < 0L || curPageNumber >= pagesAmount || options.rightBoundPageNumber != -1L && curPageNumber > options.rightBoundPageNumber || options.leftBoundPageNumber != -1L && curPageNumber < options.leftBoundPageNumber;
    }

    static String getTailFromPage(String nextPageText, int tailLength) {
        return tailLength < nextPageText.length() ? nextPageText.substring(0, tailLength) : nextPageText;
    }

    static char getPostfixSymbol(String nextPageText, int tailLength) {
        return tailLength + 1 < nextPageText.length() ? nextPageText.charAt(tailLength + 1) : FrameSearcher.NOT_EXISTING_BORDERING_SYMBOL;
    }

    static char getPrefixSymbol(String prevPageText) {
        if (!StringUtil.isEmpty((String)prevPageText)) {
            return prevPageText.charAt(prevPageText.length() - 1);
        }
        return FrameSearcher.NOT_EXISTING_BORDERING_SYMBOL;
    }

    static long getPreviousPageNumber(long curPageNumber, SearchTaskOptions options) {
        if (options.searchForwardDirection) {
            return curPageNumber - 1L;
        }
        return curPageNumber + 1L;
    }

    protected FrameSearcher createFrameSearcher(SearchTaskOptions options, Project project) {
        return new FrameSearcher(options, (frameText, offset, ijFindModel) -> FindManager.getInstance((Project)project).findString((CharSequence)frameText, offset, ijFindModel));
    }
}

