/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.CompoundIconProvider;
import com.intellij.ide.projectView.impl.ShowModulesAction;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.scopeView.NamedScopeFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.impl.OpenFilesScope;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.pom.NavigatableWithText;
import com.intellij.problems.ProblemListener;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.search.scope.ProblemsScope;
import com.intellij.psi.search.scope.ProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.stripe.ErrorStripe;
import com.intellij.ui.tree.AbstractTreeWalker;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.ui.tree.project.ProjectFileTreeModel;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import javax.swing.Icon;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScopeViewTreeModel
extends BaseTreeModel<AbstractTreeNode>
implements InvokerSupplier {
    private static final Logger LOG = Logger.getInstance(ScopeViewTreeModel.class);
    private volatile Comparator<? super NodeDescriptor> comparator;
    private final ProjectFileTreeModel model;
    private final ProjectNode root;

    ScopeViewTreeModel(@NotNull Project project, @NotNull ViewSettings settings) {
        if (project == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(1);
        }
        this.model = new ProjectFileTreeModel(project);
        this.model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (type == TreeModelAdapter.EventType.StructureChanged) {
                    TreePath path = event.getTreePath();
                    if (path == null || null == path.getParentPath()) {
                        ScopeViewTreeModel.this.invalidate(null);
                    } else {
                        Object component = path.getLastPathComponent();
                        if (component instanceof ProjectFileNode) {
                            ProjectFileNode node = (ProjectFileNode)component;
                            ScopeViewTreeModel.this.notifyStructureChanged(node.getVirtualFile());
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.model);
        this.root = new ProjectNode(project, settings);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(ProblemListener.TOPIC, (Object)new ProblemListener(){

            public void problemsAppeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.problemsDisappeared(file2);
            }

            public void problemsDisappeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!ScopeViewTreeModel.this.updateScopeIf(ProblemsScope.class)) {
                    ScopeViewTreeModel.this.notifyPresentationChanged(file2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsAppeared";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsDisappeared";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager manager, @NotNull VirtualFile file2) {
                if (manager == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.fileClosed(manager, file2);
            }

            public void fileClosed(@NotNull FileEditorManager manager, @NotNull VirtualFile file2) {
                if (manager == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    3.$$$reportNull$$$0(3);
                }
                ScopeViewTreeModel.this.updateScopeIf(OpenFilesScope.class);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "manager";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        FileStatusManager.getInstance((Project)project).addFileStatusListener(new FileStatusListener(){

            public void fileStatusChanged(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                ScopeViewTreeModel.this.notifyPresentationChanged(file2);
            }

            public void fileStatusesChanged() {
                ScopeViewTreeModel.this.invalidate(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scopeView/ScopeViewTreeModel$4", "fileStatusChanged"));
            }
        }, (Disposable)this);
        CopyPasteUtil.addDefaultListener((Disposable)this, element -> {
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (file2 != null) {
                this.notifyPresentationChanged(file2);
            }
        });
    }

    void setStructureProvider(TreeStructureProvider provider) {
        this.model.onValidThread(() -> {
            if (this.root.provider == null && provider == null) {
                return;
            }
            this.root.provider = provider;
            this.treeStructureChanged(null, null, null);
        });
    }

    void setNodeDecorator(ProjectViewNodeDecorator decorator) {
        this.model.onValidThread(() -> {
            if (this.root.decorator == null && decorator == null) {
                return;
            }
            this.root.decorator = decorator;
            this.treeStructureChanged(null, null, null);
        });
    }

    public void setComparator(Comparator<? super NodeDescriptor> comparator2) {
        this.model.onValidThread(() -> {
            if (this.comparator == null && comparator2 == null) {
                return;
            }
            this.comparator = comparator2;
            this.treeStructureChanged(null, null, null);
        });
    }

    public void setFilter(@Nullable NamedScopeFilter filter) {
        this.root.filter = filter;
        LOG.debug("set filter", new Object[]{filter});
        this.model.setFilter((VirtualFileFilter)(filter != null && filter.getScope() instanceof ProjectFilesScope ? null : filter));
    }

    public NamedScopeFilter getFilter() {
        return this.root.filter;
    }

    @Nullable
    public Object getContent(Object object) {
        Node node;
        if (object instanceof GroupNode) {
            node = (GroupNode)((Object)object);
            object = ((GroupNode)node).getSingleRoot();
        }
        if (object instanceof FileNode) {
            node = (FileNode)((Object)object);
            PsiFileSystemItem element = node.findFileSystemItem(((FileNode)node).getVirtualFile());
            if (element == null || ((FileNode)node).compacted == null) {
                return element;
            }
            if (ScopeViewTreeModel.isPackage(node.getIcon()) && node.getSettings().isFlattenPackages()) {
                return element;
            }
            ArrayDeque<PsiFileSystemItem> deque = new ArrayDeque<PsiFileSystemItem>();
            ((FileNode)node).compacted.forEach(arg_0 -> ScopeViewTreeModel.lambda$getContent$4((FileNode)node, deque, arg_0));
            if (deque.isEmpty()) {
                return element;
            }
            deque.addFirst(element);
            return deque.toArray();
        }
        if (object instanceof NodeDescriptor) {
            NodeDescriptor descriptor2 = (NodeDescriptor)object;
            object = descriptor2.getElement();
        }
        if (object instanceof AbstractTreeNode) {
            node = (AbstractTreeNode)object;
            object = node.getValue();
        }
        return object;
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.model.getInvoker();
        if (invoker == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(2);
        }
        return invoker;
    }

    public void invalidate(@Nullable Runnable onDone) {
        this.model.onValidThread(() -> {
            this.root.childrenValid = false;
            LOG.debug("whole structure changed");
            ViewSettings settings = this.root.getSettings();
            boolean isShowExcludedFiles = false;
            if (settings instanceof ProjectViewSettings && ((ProjectViewSettings)settings).isShowExcludedFiles()) {
                NamedScopeFilter filter = this.getFilter();
                Class<?> type = filter == null ? null : filter.getScope().getClass();
                isShowExcludedFiles = !NamedScope.class.equals(type);
            }
            this.model.setSettings(isShowExcludedFiles, ShowModulesAction.hasModules() && settings.isShowModules());
            this.treeStructureChanged(null, null, null);
            if (onDone != null) {
                onDone.run();
            }
        });
    }

    private void update(@NotNull AbstractTreeNode node, boolean structure) {
        if (node == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(3);
        }
        this.model.onValidThread(() -> {
            boolean changed;
            boolean updated = node.update();
            boolean bl = changed = structure || !(node instanceof Node);
            if (!updated && !changed) {
                return;
            }
            TreePath path = TreePathUtil.pathToCustomNode(node, AbstractTreeNode::getParent);
            if (path == null || this.root != path.getPathComponent(0)) {
                return;
            }
            if (changed) {
                LOG.debug("structure changed: ", new Object[]{node});
                this.treeStructureChanged(path, null, null);
            } else {
                LOG.debug("node updated: ", new Object[]{node});
                this.treeNodesChanged(path, null, null);
            }
        });
    }

    private void notifyStructureChanged(@NotNull VirtualFile file2) {
        boolean flattenPackages;
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(4);
        }
        if (flattenPackages = this.root.getSettings().isFlattenPackages()) {
            VirtualFile ancestor;
            ProjectFileIndex index = ScopeViewTreeModel.getProjectFileIndex(this.root.getProject());
            VirtualFile virtualFile = ancestor = index == null ? null : index.getSourceRootForFile(file2);
            if (ancestor != null && VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)true)) {
                file2 = ancestor;
            } else {
                flattenPackages = false;
            }
        }
        boolean resolveCompactedFolder = !flattenPackages && file2.isDirectory() && this.root.getSettings().isCompactDirectories();
        this.find(file2, null, (Consumer<Object>)((Consumer)found -> {
            if (found instanceof Node) {
                AbstractTreeNode parent;
                Node node = (Node)((Object)((Object)found));
                if (resolveCompactedFolder && (parent = node.getParent()) instanceof Node) {
                    node = (Node)parent;
                }
                if (node.childrenValid) {
                    node.childrenValid = false;
                    this.update((AbstractTreeNode)node, true);
                }
            } else if (found instanceof AbstractTreeNode) {
                this.update((AbstractTreeNode)found, true);
            }
        }));
    }

    private void notifyPresentationChanged(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(5);
        }
        while (!file2.isValid()) {
            if ((file2 = file2.getParent()) != null) continue;
            return;
        }
        SmartList list2 = new SmartList();
        this.find(file2, (List<? super Node>)list2, (Consumer<Object>)((Consumer)arg_0 -> this.lambda$notifyPresentationChanged$9((List)list2, arg_0)));
    }

    private void find(@NotNull VirtualFile file2, final @Nullable List<? super Node> list2, @NotNull Consumer<Object> consumer) {
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(7);
        }
        this.model.onValidThread(() -> {
            final AreaInstance area = ProjectFileNode.findArea(file2, this.root.getProject());
            if (area != null) {
                TreeVisitor.ByComponent<VirtualFile, AbstractTreeNode> visitor = new TreeVisitor.ByComponent<VirtualFile, AbstractTreeNode>(file2, AbstractTreeNode.class){

                    protected boolean matches(@NotNull AbstractTreeNode pathComponent, @NotNull VirtualFile thisComponent) {
                        if (pathComponent == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        if (thisComponent == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        if (pathComponent.canRepresent((Object)thisComponent)) {
                            return true;
                        }
                        if (pathComponent instanceof Node) {
                            return false;
                        }
                        ProjectViewNode node = pathComponent instanceof ProjectViewNode ? (ProjectViewNode)pathComponent : null;
                        return node != null && node.contains(thisComponent);
                    }

                    protected boolean contains(@NotNull AbstractTreeNode pathComponent, @NotNull VirtualFile thisComponent) {
                        Node node;
                        if (pathComponent == null) {
                            5.$$$reportNull$$$0(2);
                        }
                        if (thisComponent == null) {
                            5.$$$reportNull$$$0(3);
                        }
                        Node node2 = node = pathComponent instanceof Node ? (Node)pathComponent : null;
                        if (node == null || !node.contains(thisComponent, area)) {
                            return false;
                        }
                        if (list2 != null) {
                            list2.add(node);
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "pathComponent";
                                break;
                            }
                            case 1: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "thisComponent";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$5";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "matches";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "contains";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                AbstractTreeWalker<AbstractTreeNode> walker = new AbstractTreeWalker<AbstractTreeNode>((TreeVisitor)visitor){

                    @Override
                    protected Collection<AbstractTreeNode> getChildren(@NotNull AbstractTreeNode pathComponent) {
                        if (pathComponent == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        Node node = pathComponent instanceof Node ? (Node)pathComponent : null;
                        return node != null && node.childrenValid ? node.children : Collections.emptyList();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathComponent", "com/intellij/ide/scopeView/ScopeViewTreeModel$6", "getChildren"));
                    }
                };
                walker.start((AbstractTreeNode)this.root);
                walker.promise().onProcessed(path -> consumer.consume(path == null ? null : path.getLastPathComponent()));
            }
        });
    }

    public Object getRoot() {
        if (!this.model.isValidThread()) {
            return null;
        }
        this.root.update();
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.root != object && super.isLeaf(object);
    }

    @Override
    public int getChildCount(Object object) {
        if (object instanceof AbstractTreeNode && this.model.isValidThread()) {
            AbstractTreeNode node = (AbstractTreeNode)object;
            return node.getChildren().size();
        }
        return 0;
    }

    @Override
    @NotNull
    public List<AbstractTreeNode> getChildren(Object object) {
        AbstractTreeNode parent;
        Collection children2;
        if (object instanceof AbstractTreeNode && this.model.isValidThread() && !(children2 = (parent = (AbstractTreeNode)object).getChildren()).isEmpty()) {
            SmartList result2 = new SmartList();
            children2.forEach(arg_0 -> ScopeViewTreeModel.lambda$getChildren$12(parent, (List)result2, arg_0));
            Comparator<? super NodeDescriptor> comparator2 = this.comparator;
            if (comparator2 != null) {
                result2.sort(comparator2);
            }
            SmartList smartList = result2;
            if (smartList == null) {
                ScopeViewTreeModel.$$$reportNull$$$0(8);
            }
            return smartList;
        }
        List<AbstractTreeNode> list2 = Collections.emptyList();
        if (list2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Nullable
    ErrorStripe getStripe(Object object, boolean expanded) {
        if (expanded && object instanceof Node) {
            return null;
        }
        if (object instanceof PresentableNodeDescriptor) {
            Color color;
            PresentableNodeDescriptor node = (PresentableNodeDescriptor)object;
            TextAttributesKey key = node.getPresentation().getTextAttributesKey();
            TextAttributes attributes = key == null ? null : EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getAttributes(key);
            Color color2 = color = attributes == null ? null : attributes.getErrorStripeColor();
            if (color != null) {
                return ErrorStripe.create(color, 1);
            }
        }
        return null;
    }

    boolean updateScopeIf(@NotNull Class<? extends NamedScope> type) {
        NamedScopeFilter filter;
        if (type == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(10);
        }
        if ((filter = this.getFilter()) == null || !type.isInstance(filter.getScope())) {
            return false;
        }
        LOG.debug("update filter", new Object[]{filter});
        this.model.setFilter(filter);
        return true;
    }

    @Nullable
    private static WolfTheProblemSolver getWolfTheProblemSolver(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : WolfTheProblemSolver.getInstance((Project)project);
    }

    @Nullable
    private static FileStatusManager getFileStatusManager(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : FileStatusManager.getInstance((Project)project);
    }

    @Nullable
    private static ModuleManager getModuleManager(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : ModuleManager.getInstance((Project)project);
    }

    @Nullable
    private static ProjectFileIndex getProjectFileIndex(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : ProjectFileIndex.getInstance((Project)project);
    }

    @Nullable
    private static ModuleRootManager getModuleRootManager(@Nullable Module module) {
        return module == null || module.isDisposed() ? null : ModuleRootManager.getInstance((Module)module);
    }

    @Nullable
    private static ProjectSettingsService getProjectSettingsService(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : ProjectSettingsService.getInstance(project);
    }

    @Nullable
    private static Module getModule(@NotNull VirtualFile file2, @Nullable Project project) {
        ProjectFileIndex index;
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(11);
        }
        return (index = ScopeViewTreeModel.getProjectFileIndex(project)) == null ? null : index.getModuleForFile(file2);
    }

    private static boolean hasModuleGroups(@Nullable Project project) {
        if (Registry.is((String)"project.qualified.module.names")) {
            return true;
        }
        ModuleManager manager = ScopeViewTreeModel.getModuleManager(project);
        return manager != null && manager.hasModuleGroups();
    }

    @NotNull
    private static List<String> getModuleNameAsList(@NotNull Module module, boolean split) {
        if (module == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(12);
        }
        String name = module.getName();
        Project project = module.isDisposed() ? null : module.getProject();
        ModuleManager manager = ScopeViewTreeModel.getModuleManager(project);
        if (manager != null) {
            if (manager.hasModuleGroups()) {
                Object[] path = manager.getModuleGroupPath(module);
                if (path != null && path.length != 0) {
                    SmartList list2 = new SmartList(path);
                    list2.add(name);
                    SmartList smartList = list2;
                    if (smartList == null) {
                        ScopeViewTreeModel.$$$reportNull$$$0(13);
                    }
                    return smartList;
                }
            } else if (split) {
                List list3 = StringUtil.split((String)name, (String)".");
                if (list3 == null) {
                    ScopeViewTreeModel.$$$reportNull$$$0(14);
                }
                return list3;
            }
        }
        SmartList smartList = new SmartList((Object)name);
        if (smartList == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(15);
        }
        return smartList;
    }

    @Nullable
    private static List<VirtualFile> getCompactedFolders(@Nullable VirtualFile ancestor, @NotNull VirtualFile file2) {
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(16);
        }
        if (ancestor == null || !VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)true)) {
            return null;
        }
        ArrayDeque<VirtualFile> deque = new ArrayDeque<VirtualFile>();
        while ((file2 = file2.getParent()) != null && VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)true)) {
            deque.addFirst(file2);
        }
        return deque.isEmpty() ? null : new SmartList(deque);
    }

    private static boolean isFolder(@Nullable Icon icon) {
        return ScopeViewTreeModel.is(icon, AllIcons.Nodes.Folder);
    }

    private static boolean isPackage(@Nullable Icon icon) {
        return ScopeViewTreeModel.is(icon, AllIcons.Nodes.Package);
    }

    private static boolean is(@Nullable Icon icon, @NotNull Icon expected) {
        if (expected == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(17);
        }
        if (expected.equals(icon)) {
            return true;
        }
        if (icon instanceof RowIcon) {
            RowIcon rowIcon = (RowIcon)icon;
            return expected.equals(rowIcon.getIcon(0));
        }
        return false;
    }

    private static /* synthetic */ void lambda$getChildren$12(AbstractTreeNode parent, List result2, Object child2) {
        if (child2 instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)child2;
            node.setParent(parent);
            node.update();
            result2.add(node);
        }
    }

    private /* synthetic */ void lambda$notifyPresentationChanged$9(List list2, Object found) {
        list2.forEach(node -> this.update((AbstractTreeNode)node, false));
        if (found instanceof AbstractTreeNode) {
            this.update((AbstractTreeNode)found, false);
        }
    }

    private static /* synthetic */ void lambda$getContent$4(FileNode node, ArrayDeque deque, VirtualFile file2) {
        PsiFileSystemItem item = node.findFileSystemItem(file2);
        if (item != null) {
            deque.addFirst(item);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNameAsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notifyStructureChanged";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyPresentationChanged";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateScopeIf";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameAsList";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCompactedFolders";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Mapper<N extends Node, V> {
        private final Map<Object, N> map;
        private final BiFunction<? super Node, ? super V, ? extends N> creator;

        Mapper(@NotNull BiFunction<? super Node, ? super V, ? extends N> creator, @NotNull Map<Object, N> map2) {
            if (creator == null) {
                Mapper.$$$reportNull$$$0(0);
            }
            if (map2 == null) {
                Mapper.$$$reportNull$$$0(1);
            }
            this.creator = creator;
            this.map = map2;
        }

        Mapper(@NotNull BiFunction<? super Node, ? super V, ? extends N> creator, @NotNull Class<? extends N> type, @NotNull Collection<? extends AbstractTreeNode> list2) {
            if (creator == null) {
                Mapper.$$$reportNull$$$0(2);
            }
            if (type == null) {
                Mapper.$$$reportNull$$$0(3);
            }
            if (list2 == null) {
                Mapper.$$$reportNull$$$0(4);
            }
            this(creator, new HashMap());
            list2.forEach(node -> {
                Object id = node.getValue();
                if (id != null && type.isInstance(node)) {
                    this.map.put(id, type.cast(node));
                }
            });
        }

        @NotNull
        N apply(@NotNull Node parent, @NotNull V value) {
            if (parent == null) {
                Mapper.$$$reportNull$$$0(5);
            }
            if (value == null) {
                Mapper.$$$reportNull$$$0(6);
            }
            N n = this.apply(parent, value, null);
            if (n == null) {
                Mapper.$$$reportNull$$$0(7);
            }
            return n;
        }

        @NotNull
        N apply(@NotNull Node parent, @NotNull V value, @Nullable Icon icon) {
            Node node;
            if (parent == null) {
                Mapper.$$$reportNull$$$0(8);
            }
            if (value == null) {
                Mapper.$$$reportNull$$$0(9);
            }
            Node node2 = node = this.map.isEmpty() ? null : (Node)((Object)this.map.get(value));
            if (node == null) {
                node = (Node)((Object)this.creator.apply(parent, value));
            }
            node.setIcon(icon);
            node.childrenValid = false;
            Node node3 = node;
            if (node3 == null) {
                Mapper.$$$reportNull$$$0(10);
            }
            return (N)((Object)node3);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "creator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Mapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Mapper";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 7: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Group {
        private final Object id;
        private final HashMap<Object, Group> groups;
        private final List<RootNode> roots;

        private Group(@NotNull String name) {
            if (name == null) {
                Group.$$$reportNull$$$0(0);
            }
            this.groups = new HashMap();
            this.roots = new SmartList();
            this.id = name;
        }

        private Group(@NotNull Module module) {
            if (module == null) {
                Group.$$$reportNull$$$0(1);
            }
            this.groups = new HashMap();
            this.roots = new SmartList();
            this.id = module;
        }

        Group(@NotNull Collection<RootNode> nodes, boolean flatten) {
            if (nodes == null) {
                Group.$$$reportNull$$$0(2);
            }
            this.groups = new HashMap();
            this.roots = new SmartList();
            this.id = null;
            if (!nodes.isEmpty()) {
                HashMap<Module, Group> map2 = new HashMap<Module, Group>();
                nodes.forEach(node -> {
                    Object id = node.node.getRootID();
                    if (id instanceof Module) {
                        Module module = (Module)id;
                        Group group = (Group)map2.get(module);
                        if (group == null) {
                            group = new Group(module);
                            map2.put(module, group);
                        }
                        group.roots.add((RootNode)((Object)node));
                    } else {
                        this.roots.add((RootNode)((Object)node));
                    }
                });
                if (flatten) {
                    this.groups.putAll(map2);
                } else {
                    map2.forEach((module, group) -> {
                        List path = ScopeViewTreeModel.getModuleNameAsList(module, Registry.is((String)"project.qualified.module.names"));
                        group.roots.forEach(node -> this.add((RootNode)((Object)((Object)node)), path, 0));
                    });
                }
            }
        }

        private void add(RootNode node, List<String> path, int index) {
            if (index < path.size()) {
                String name = path.get(index);
                Group group = this.groups.get(name);
                if (group == null) {
                    group = new Group(name);
                    this.groups.put(name, group);
                }
                group.add(node, path, index + 1);
            } else {
                this.roots.add(node);
            }
        }

        @NotNull
        Icon getIcon() {
            if (!this.groups.isEmpty() || this.roots.isEmpty()) {
                Icon icon = AllIcons.Nodes.ModuleGroup;
                if (icon == null) {
                    Group.$$$reportNull$$$0(3);
                }
                return icon;
            }
            Object id = this.roots.get((int)0).node.getRootID();
            if (this.roots.stream().anyMatch(root -> !root.node.getRootID().equals(id))) {
                Icon icon = AllIcons.Nodes.ModuleGroup;
                if (icon == null) {
                    Group.$$$reportNull$$$0(4);
                }
                return icon;
            }
            if (id instanceof Module) {
                ModuleType type = ModuleType.get((Module)((Module)id));
                Icon icon = type.getIcon();
                if (icon != null) {
                    Icon icon2 = icon;
                    if (icon2 == null) {
                        Group.$$$reportNull$$$0(5);
                    }
                    return icon2;
                }
                LOG.warn(type.getName() + " type have no icon for " + id);
            }
            Icon icon = AllIcons.Nodes.Module;
            if (icon == null) {
                Group.$$$reportNull$$$0(6);
            }
            return icon;
        }

        @Nullable
        RootNode getFirstRoot() {
            if (!this.roots.isEmpty()) {
                return this.roots.get(0);
            }
            for (Group group : this.groups.values()) {
                RootNode root = group.getFirstRoot();
                if (root == null) continue;
                return root;
            }
            return null;
        }

        @Nullable
        RootNode getSingleRoot() {
            if (!this.groups.isEmpty() || this.roots.size() != 1) {
                return null;
            }
            RootNode node = this.roots.get(0);
            ModuleRootManager manager = ScopeViewTreeModel.getModuleRootManager(ScopeViewTreeModel.getModule(node.getVirtualFile(), node.getProject()));
            if (manager == null) {
                return null;
            }
            for (VirtualFile file2 : manager.getSourceRoots()) {
                if (VfsUtilCore.isAncestor((VirtualFile)node.getVirtualFile(), (VirtualFile)file2, (boolean)true)) continue;
                return null;
            }
            return node;
        }

        @Nullable
        private Group getSingleGroup() {
            if (!this.roots.isEmpty() || this.groups.size() != 1) {
                return null;
            }
            return this.groups.values().stream().findFirst().orElse(null);
        }

        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Node parent, @NotNull Collection<? extends AbstractTreeNode> old) {
            if (parent == null) {
                Group.$$$reportNull$$$0(7);
            }
            if (old == null) {
                Group.$$$reportNull$$$0(8);
            }
            Mapper<GroupNode, Object> mapper = new Mapper<GroupNode, Object>(GroupNode::new, GroupNode.class, old);
            ModuleManager manager = ScopeViewTreeModel.getModuleManager(parent.getProject());
            char separator = manager != null && manager.hasModuleGroups() ? (char)'/' : '.';
            boolean compactDirectories = parent.getSettings().isCompactDirectories();
            SmartList children2 = new SmartList();
            for (Group group : this.groups.values()) {
                Group single;
                Object id = group.id;
                Group group2 = single = !compactDirectories ? null : group.getSingleGroup();
                if (single != null) {
                    StringBuilder sb = new StringBuilder(id.toString());
                    do {
                        group = single;
                        sb.append(separator).append(group.id);
                    } while ((single = single.getSingleGroup()) != null);
                    id = sb.toString();
                }
                GroupNode node = mapper.apply(parent, id);
                node.setGroup(group);
                children2.add(node);
            }
            children2.addAll(this.roots);
            SmartList smartList = children2;
            if (smartList == null) {
                Group.$$$reportNull$$$0(9);
            }
            return smartList;
        }

        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            if (file2 == null) {
                Group.$$$reportNull$$$0(10);
            }
            if (area == null) {
                Group.$$$reportNull$$$0(11);
            }
            return this.roots.stream().anyMatch(root -> root.canRepresentOrContain(file2, area)) || this.groups.values().stream().anyMatch(group -> group.contains(file2, area));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Group";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Group";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildren";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class GroupNode
    extends Node
    implements NavigatableWithText {
        private final String prefix;
        private final String name;
        private Group group;

        GroupNode(@NotNull Node parent, @NotNull Object value) {
            if (parent == null) {
                GroupNode.$$$reportNull$$$0(0);
            }
            if (value == null) {
                GroupNode.$$$reportNull$$$0(1);
            }
            super(parent, value);
            if (value instanceof Module) {
                List list2 = ScopeViewTreeModel.getModuleNameAsList((Module)value, false);
                int index = list2.size() - 1;
                if (index > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < index; ++i) {
                        sb.append((String)list2.get(i)).append('/');
                    }
                    this.prefix = sb.toString();
                    this.name = (String)list2.get(index);
                } else {
                    this.prefix = null;
                    this.name = index < 0 ? "UNEXPECTED" : (String)list2.get(index);
                }
            } else {
                this.prefix = null;
                this.name = value.toString();
            }
        }

        void setGroup(@NotNull Group group) {
            if (group == null) {
                GroupNode.$$$reportNull$$$0(2);
            }
            this.group = group;
            this.childrenValid = false;
            this.setIcon(group.getIcon());
        }

        @Nullable
        RootNode getSingleRoot() {
            Group group = this.group;
            return group == null ? null : group.getSingleRoot();
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            RootNode node = this.getSingleRoot();
            return node == null ? null : node.getVirtualFile();
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                GroupNode.$$$reportNull$$$0(3);
            }
            presentation.setIcon(this.getIcon());
            if (this.prefix != null) {
                presentation.addText(this.prefix, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            presentation.addText(this.name, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.decorate(presentation);
        }

        @Override
        @Nullable
        String getLocation() {
            RootNode node = this.getSingleRoot();
            return node == null ? null : node.getTitle();
        }

        @Override
        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Collection<? extends AbstractTreeNode> old) {
            Group group;
            if (old == null) {
                GroupNode.$$$reportNull$$$0(4);
            }
            if ((group = this.group) == null) {
                List<AbstractTreeNode> list2 = Collections.emptyList();
                if (list2 == null) {
                    GroupNode.$$$reportNull$$$0(5);
                }
                return list2;
            }
            RootNode node = group.getSingleRoot();
            if (node == null) {
                Collection<AbstractTreeNode> collection = group.createChildren(this, old);
                if (collection == null) {
                    GroupNode.$$$reportNull$$$0(6);
                }
                return collection;
            }
            node.setParent((AbstractTreeNode)this);
            Collection<AbstractTreeNode> collection = node.getChildren();
            if (collection == null) {
                GroupNode.$$$reportNull$$$0(7);
            }
            return collection;
        }

        @Override
        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            Group group;
            if (file2 == null) {
                GroupNode.$$$reportNull$$$0(8);
            }
            if (area == null) {
                GroupNode.$$$reportNull$$$0(9);
            }
            return (group = this.group) != null && group.contains(file2, area);
        }

        public boolean canNavigate() {
            Group group = this.group;
            RootNode node = group == null ? null : group.getFirstRoot();
            return node != null && node.canNavigate();
        }

        public void navigate(boolean requestFocus) {
            RootNode node;
            Group group = this.group;
            RootNode rootNode = node = group == null ? null : group.getFirstRoot();
            if (node != null) {
                node.navigate(requestFocus);
            }
        }

        public String getNavigateActionText(boolean focusEditor) {
            return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
        }

        public int getTypeSortWeight(boolean sortByType) {
            return 2;
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        @NotNull
        public String toString() {
            String string = this.prefix != null ? this.prefix + this.name : this.name;
            if (string == null) {
                GroupNode.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$GroupNode";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$GroupNode";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChildren";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setGroup";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildren";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 10: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class RootNode
    extends FileNode
    implements NavigatableWithText {
        RootNode(@NotNull Node parent, @NotNull ProjectFileNode node) {
            if (parent == null) {
                RootNode.$$$reportNull$$$0(0);
            }
            if (node == null) {
                RootNode.$$$reportNull$$$0(1);
            }
            super(parent, node);
        }

        boolean canRepresentOrContain(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            if (file2 == null) {
                RootNode.$$$reportNull$$$0(2);
            }
            if (area == null) {
                RootNode.$$$reportNull$$$0(3);
            }
            return this.node.contains(file2, area, false);
        }

        @Override
        public int getWeight() {
            return this.node.getRootID() instanceof Project ? 0 : super.getWeight();
        }

        @Override
        public int getTypeSortWeight(boolean sortByType) {
            return this.node.getRootID() instanceof Project ? 1 : super.getTypeSortWeight(sortByType);
        }

        @NotNull
        public String getTitle() {
            String string = this.getLocation(false);
            if (string == null) {
                RootNode.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getNodeName() {
            String string = this.getLocation(true);
            if (string == null) {
                RootNode.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        private String getLocation(boolean allowEmpty) {
            String location;
            VirtualFile dir = ProjectFileNode.findBaseDir(this.getProject());
            String string = location = dir == null ? null : VfsUtilCore.getRelativePath((VirtualFile)this.getVirtualFile(), (VirtualFile)dir);
            if (location != null && (allowEmpty || !location.isEmpty())) {
                String string2 = location;
                if (string2 == null) {
                    RootNode.$$$reportNull$$$0(6);
                }
                return string2;
            }
            String string3 = FileUtil.getLocationRelativeToUserHome((String)this.getVirtualFile().getPresentableUrl());
            if (string3 == null) {
                RootNode.$$$reportNull$$$0(7);
            }
            return string3;
        }

        public boolean canNavigate() {
            return null != ScopeViewTreeModel.getProjectSettingsService(this.getProject());
        }

        public void navigate(boolean requestFocus) {
            ProjectSettingsService service = ScopeViewTreeModel.getProjectSettingsService(this.getProject());
            if (service != null) {
                Module module = ScopeViewTreeModel.getModule(this.getVirtualFile(), this.getProject());
                if (module != null && service.canOpenModuleSettings()) {
                    service.openModuleSettings(module);
                } else {
                    service.openProjectSettings();
                }
            }
        }

        public String getNavigateActionText(boolean focusEditor) {
            return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$RootNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$RootNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeName";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canRepresentOrContain";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FileNode
    extends Node {
        final List<VirtualFile> compacted;
        final ProjectFileNode node;

        FileNode(@NotNull Node parent, @NotNull ProjectFileNode node) {
            if (parent == null) {
                FileNode.$$$reportNull$$$0(0);
            }
            if (node == null) {
                FileNode.$$$reportNull$$$0(1);
            }
            super(parent, node);
            this.node = node;
            this.compacted = ScopeViewTreeModel.getCompactedFolders(parent.getVirtualFile(), node.getVirtualFile());
            this.myName = node.getVirtualFile().getName();
        }

        protected void update(@NotNull PresentationData presentation) {
            ProjectFileIndex index;
            if (presentation == null) {
                FileNode.$$$reportNull$$$0(2);
            }
            this.myName = this.getNodeName();
            VirtualFile file2 = this.getVirtualFile();
            String title = this.getTitle();
            SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (this.node.getRootID() instanceof VirtualFile && (index = ScopeViewTreeModel.getProjectFileIndex(this.getProject())) != null && file2.equals(index.getContentRootForFile(file2))) {
                attributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            String text2 = title != null ? title : this.toString();
            presentation.setPresentableText(text2);
            presentation.addText(text2, attributes);
            Icon icon = this.getIcon();
            if (icon == null && file2.isValid()) {
                icon = file2.isDirectory() ? FileNode.getFolderIcon((PsiElement)this.findFileSystemItem(file2)) : file2.getFileType().getIcon();
            }
            presentation.setIcon(icon);
            this.decorate(presentation);
        }

        protected boolean valueIsCut() {
            return CopyPasteManager.getInstance().isCutElement((Object)this.findFileSystemItem(this.getVirtualFile()));
        }

        @Override
        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Collection<? extends AbstractTreeNode> old) {
            ProjectNode parent;
            if (old == null) {
                FileNode.$$$reportNull$$$0(3);
            }
            if ((parent = this.findParent(ProjectNode.class)) == null) {
                List<AbstractTreeNode> list2 = Collections.emptyList();
                if (list2 == null) {
                    FileNode.$$$reportNull$$$0(4);
                }
                return list2;
            }
            Collection<AbstractTreeNode> collection = parent.createChildren(this, old);
            if (collection == null) {
                FileNode.$$$reportNull$$$0(5);
            }
            return collection;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean canRepresent(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FileNode.$$$reportNull$$$0(6);
            }
            if (super.canRepresent(file2)) return true;
            if (this.compacted == null) return false;
            if (!this.compacted.stream().anyMatch(file2::equals)) return false;
            return true;
        }

        @Override
        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            if (file2 == null) {
                FileNode.$$$reportNull$$$0(7);
            }
            if (area == null) {
                FileNode.$$$reportNull$$$0(8);
            }
            return this.node.contains(file2, area, true);
        }

        public FileStatus getFileStatus() {
            FileStatusManager manager = ScopeViewTreeModel.getFileStatusManager(this.getProject());
            return manager == null ? FileStatus.NOT_CHANGED : manager.getRecursiveStatus(this.getVirtualFile());
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.node.getVirtualFile();
            if (virtualFile == null) {
                FileNode.$$$reportNull$$$0(9);
            }
            return virtualFile;
        }

        @Override
        public int getWeight() {
            ViewSettings settings;
            if (this.getVirtualFile().isDirectory() && ((settings = this.getSettings()) == null || settings.isFoldersAlwaysOnTop())) {
                return 0;
            }
            return 20;
        }

        public int getTypeSortWeight(boolean sortByType) {
            return this.getVirtualFile().isDirectory() ? 3 : 5;
        }

        @NotNull
        protected String getNodeName() {
            String string = this.getNodeName(this.getPackageName());
            if (string == null) {
                FileNode.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        private String getNodeName(@Nullable String name) {
            if (name != null) {
                String prefix;
                AbstractTreeNode parent = this.getParent();
                FileNode node = parent instanceof FileNode ? (FileNode)parent : null;
                String string = prefix = node == null ? null : node.getPackageName();
                if (prefix == null) {
                    String string2 = name;
                    if (string2 == null) {
                        FileNode.$$$reportNull$$$0(11);
                    }
                    return string2;
                }
                int length = prefix.length();
                if (length > 0 && name.startsWith(prefix)) {
                    if (length < name.length() && '.' == name.charAt(length)) {
                        ++length;
                    }
                    if (length < name.length()) {
                        String string3 = name.substring(length);
                        if (string3 == null) {
                            FileNode.$$$reportNull$$$0(12);
                        }
                        return string3;
                    }
                }
                LOG.info("unexpected prefix: " + prefix + " for package: " + name);
            }
            if (this.compacted != null) {
                StringBuilder sb = new StringBuilder();
                char separator = ScopeViewTreeModel.isPackage(this.getIcon()) ? (char)'.' : '/';
                this.compacted.forEach(file2 -> sb.append(file2.getName()).append(separator));
                String string = sb.append(this.getVirtualFile().getName()).toString();
                if (string == null) {
                    FileNode.$$$reportNull$$$0(13);
                }
                return string;
            }
            String string = this.getVirtualFile().getName();
            if (string == null) {
                FileNode.$$$reportNull$$$0(14);
            }
            return string;
        }

        @Nullable
        private String getPackageName() {
            String name;
            PsiDirectoryFactory factory;
            PsiFileSystemItem element;
            PsiFileSystemItem psiFileSystemItem = element = !ScopeViewTreeModel.isPackage(this.getIcon()) ? null : this.findFileSystemItem(this.getVirtualFile());
            if (element instanceof PsiDirectory && element.isValid() && (factory = PsiDirectoryFactory.getInstance(element.getProject())) != null && factory.isPackage((PsiDirectory)element) && factory.isValidPackageName(name = factory.getQualifiedName((PsiDirectory)element, false))) {
                return name;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$FileNode";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$FileNode";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChildren";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildren";
                    break;
                }
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "canRepresent";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class ProjectNode
    extends Node {
        private volatile HashMap<Object, RootNode> roots;
        volatile TreeStructureProvider provider;
        volatile ProjectViewNodeDecorator decorator;

        ProjectNode(@NotNull Project project, ViewSettings settings) {
            if (project == null) {
                ProjectNode.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                ProjectNode.$$$reportNull$$$0(1);
            }
            super(project, project, settings);
            this.roots = new HashMap();
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                ProjectNode.$$$reportNull$$$0(2);
            }
            presentation.setIcon(AllIcons.Nodes.Project);
            presentation.setPresentableText(this.toString());
            this.decorate(presentation);
        }

        @Override
        @Nullable
        String getLocation() {
            Project project = this.getProject();
            return project == null || project.isDisposed() ? null : FileUtil.getLocationRelativeToUserHome((String)project.getPresentableUrl());
        }

        @Override
        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Collection<? extends AbstractTreeNode> old) {
            if (old == null) {
                ProjectNode.$$$reportNull$$$0(3);
            }
            HashMap<Object, RootNode> oldRoots = this.roots;
            HashMap newRoots = new HashMap();
            Mapper<RootNode, ProjectFileNode> mapper = new Mapper<RootNode, ProjectFileNode>(RootNode::new, oldRoots);
            ScopeViewTreeModel.this.model.getChildren(ScopeViewTreeModel.this.model.getRoot()).forEach(child2 -> {
                RootNode cfr_ignored_0 = (RootNode)((Object)((Object)newRoots.put(child2, mapper.apply(this, (ProjectFileNode)child2))));
            });
            this.roots = newRoots;
            if (newRoots.isEmpty()) {
                List<AbstractTreeNode> list2 = Collections.emptyList();
                if (list2 == null) {
                    ProjectNode.$$$reportNull$$$0(4);
                }
                return list2;
            }
            Collection<AbstractTreeNode> collection = new Group(newRoots.values(), this.getSettings().isFlattenModules() || !ScopeViewTreeModel.hasModuleGroups(this.getProject())).createChildren(this, old);
            if (collection == null) {
                ProjectNode.$$$reportNull$$$0(5);
            }
            return collection;
        }

        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Node parent, @NotNull Collection<? extends AbstractTreeNode> old) {
            if (parent == null) {
                ProjectNode.$$$reportNull$$$0(6);
            }
            if (old == null) {
                ProjectNode.$$$reportNull$$$0(7);
            }
            boolean flattenPackages = this.getSettings().isFlattenPackages();
            boolean hideEmptyMiddlePackages = this.getSettings().isHideEmptyMiddlePackages();
            boolean compactDirectories = this.getSettings().isCompactDirectories();
            Mapper<FileNode, ProjectFileNode> mapper = new Mapper<FileNode, ProjectFileNode>(FileNode::new, FileNode.class, old);
            SmartList children2 = new SmartList();
            SmartList files2 = new SmartList();
            TreeStructureProvider provider = this.provider;
            ScopeViewTreeModel.this.model.getChildren(parent.getValue()).forEach(arg_0 -> this.lambda$createChildren$2(flattenPackages, compactDirectories, (List)children2, mapper, parent, hideEmptyMiddlePackages, provider, (List)files2, arg_0));
            if (provider == null) {
                SmartList smartList = children2;
                if (smartList == null) {
                    ProjectNode.$$$reportNull$$$0(8);
                }
                return smartList;
            }
            List nodes = ContainerUtil.map((Collection)files2, file2 -> new PsiFileNode(this.getProject(), (PsiFile)file2, this.getSettings()));
            children2.addAll(provider.modify((AbstractTreeNode)parent, (Collection)nodes, this.getSettings()));
            SmartList smartList = children2;
            if (smartList == null) {
                ProjectNode.$$$reportNull$$$0(9);
            }
            return smartList;
        }

        private void visitPackages(@NotNull ProjectFileNode parent, boolean hideEmptyMiddle, @NotNull Consumer<? super ProjectFileNode> consumer) {
            if (parent == null) {
                ProjectNode.$$$reportNull$$$0(10);
            }
            if (consumer == null) {
                ProjectNode.$$$reportNull$$$0(11);
            }
            AtomicBoolean empty = new AtomicBoolean(hideEmptyMiddle);
            AtomicBoolean middle = new AtomicBoolean();
            ScopeViewTreeModel.this.model.getChildren(parent).forEach(child2 -> {
                PsiFileSystemItem element = this.findFileSystemItem(child2.getVirtualFile());
                if (element instanceof PsiDirectory) {
                    Icon icon = ProjectNode.getFolderIcon((PsiElement)element);
                    if (ScopeViewTreeModel.isPackage(icon)) {
                        if (hideEmptyMiddle) {
                            middle.set(true);
                        }
                        this.visitPackages((ProjectFileNode)child2, hideEmptyMiddle, consumer);
                    } else if (hideEmptyMiddle) {
                        empty.set(false);
                    }
                } else if (element instanceof PsiFile && hideEmptyMiddle) {
                    empty.set(false);
                }
            });
            if (!empty.get() || !middle.get()) {
                consumer.consume((Object)parent);
            }
        }

        @Nullable
        private ProjectFileNode getSingleDirectory(ProjectFileNode parent) {
            List<ProjectFileNode> children2 = ScopeViewTreeModel.this.model.getChildren(parent);
            ProjectFileNode child2 = children2.size() != 1 ? null : children2.get(0);
            return child2 != null && child2.getVirtualFile().isDirectory() ? child2 : null;
        }

        @Override
        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            if (file2 == null) {
                ProjectNode.$$$reportNull$$$0(12);
            }
            if (area == null) {
                ProjectNode.$$$reportNull$$$0(13);
            }
            return this.roots.values().stream().anyMatch(root -> root.canRepresentOrContain(file2, area));
        }

        public int getTypeSortWeight(boolean sortByType) {
            return 1;
        }

        @NotNull
        public String toString() {
            Project project = this.getProject();
            String string = project == null || project.isDisposed() ? "DISPOSED PROJECT" : project.getName();
            if (string == null) {
                ProjectNode.$$$reportNull$$$0(14);
            }
            return string;
        }

        private /* synthetic */ void lambda$createChildren$2(boolean flattenPackages, boolean compactDirectories, List children2, Mapper mapper, Node parent, boolean hideEmptyMiddlePackages, TreeStructureProvider provider, List files2, ProjectFileNode child2) {
            PsiFileSystemItem element = this.findFileSystemItem(child2.getVirtualFile());
            if (element instanceof PsiDirectory) {
                Icon icon = ProjectNode.getFolderIcon((PsiElement)element);
                if (!ScopeViewTreeModel.isPackage(icon) || !flattenPackages) {
                    ProjectFileNode childNext2;
                    ProjectFileNode projectFileNode = childNext2 = !compactDirectories ? null : this.getSingleDirectory(child2);
                    while (childNext2 != null) {
                        Icon iconNext = ProjectNode.getFolderIcon((PsiElement)this.findFileSystemItem(childNext2.getVirtualFile()));
                        if (icon.equals(iconNext)) {
                            child2 = childNext2;
                            childNext2 = this.getSingleDirectory(child2);
                            continue;
                        }
                        if (ScopeViewTreeModel.isFolder(icon) && !ScopeViewTreeModel.isPackage(iconNext)) {
                            icon = iconNext;
                            child2 = childNext2;
                            childNext2 = null;
                            continue;
                        }
                        childNext2 = null;
                    }
                    children2.add(mapper.apply(parent, child2, icon));
                } else if (!ScopeViewTreeModel.isPackage(parent.getIcon())) {
                    this.visitPackages(child2, hideEmptyMiddlePackages, (Consumer<? super ProjectFileNode>)((Consumer)childNext -> children2.add(mapper.apply(parent, childNext, AllIcons.Nodes.Package))));
                }
            } else if (element instanceof PsiFile) {
                if (provider == null) {
                    children2.add(mapper.apply(parent, child2));
                } else {
                    files2.add((PsiFile)element);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$ProjectNode";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$ProjectNode";
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChildren";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildren";
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 14: {
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPackages";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class Node
    extends ProjectViewNode<Object> {
        volatile NamedScopeFilter filter;
        volatile Collection<AbstractTreeNode> children;
        volatile boolean childrenValid;

        Node(@NotNull Project project, @NotNull Object value, @NotNull ViewSettings settings) {
            if (project == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (value == null) {
                Node.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                Node.$$$reportNull$$$0(2);
            }
            super(project, value, settings);
            this.children = Collections.emptyList();
        }

        Node(@NotNull Node parent, @NotNull Object value) {
            if (parent == null) {
                Node.$$$reportNull$$$0(3);
            }
            if (value == null) {
                Node.$$$reportNull$$$0(4);
            }
            super(parent.getProject(), value, parent.getSettings());
            this.children = Collections.emptyList();
            this.setParent((AbstractTreeNode)parent);
        }

        public int getWeight() {
            return 0;
        }

        public final boolean canRepresent(Object element) {
            if (element instanceof PsiFileSystemItem) {
                PsiFileSystemItem item = (PsiFileSystemItem)element;
                element = item.getVirtualFile();
            }
            return element instanceof VirtualFile && this.canRepresent((VirtualFile)element);
        }

        boolean canRepresent(@NotNull VirtualFile file2) {
            if (file2 == null) {
                Node.$$$reportNull$$$0(5);
            }
            return file2.equals(this.getVirtualFile());
        }

        public final boolean contains(@NotNull VirtualFile file2) {
            AreaInstance area;
            if (file2 == null) {
                Node.$$$reportNull$$$0(6);
            }
            return (area = ProjectFileNode.findArea(file2, this.getProject())) != null && this.contains(file2, area);
        }

        protected boolean hasProblemFileBeneath() {
            WolfTheProblemSolver solver = ScopeViewTreeModel.getWolfTheProblemSolver(this.getProject());
            return solver == null || solver.hasProblemFilesBeneath(this::contains);
        }

        abstract boolean contains(@NotNull VirtualFile var1, @NotNull AreaInstance var2);

        public Color getFileStatusColor(@NotNull FileStatus status) {
            if (status == null) {
                Node.$$$reportNull$$$0(7);
            }
            return status.getColor();
        }

        @NotNull
        abstract Collection<AbstractTreeNode> createChildren(@NotNull Collection<? extends AbstractTreeNode> var1);

        @NotNull
        public final Collection<AbstractTreeNode> getChildren() {
            if (this.childrenValid) {
                Collection<AbstractTreeNode> collection = this.children;
                if (collection == null) {
                    Node.$$$reportNull$$$0(8);
                }
                return collection;
            }
            Collection<AbstractTreeNode> oldChildren = this.children;
            Collection<AbstractTreeNode> newChildren = this.createChildren(oldChildren);
            oldChildren.forEach(node -> node.setParent(null));
            newChildren.forEach(node -> node.setParent((AbstractTreeNode)this));
            this.children = newChildren;
            this.childrenValid = true;
            Collection<AbstractTreeNode> collection = newChildren;
            if (collection == null) {
                Node.$$$reportNull$$$0(9);
            }
            return collection;
        }

        @Nullable
        String getLocation() {
            return null;
        }

        final void decorate(@NotNull PresentationData presentation) {
            ProjectNode parent;
            ProjectViewNodeDecorator decorator;
            String location;
            if (presentation == null) {
                Node.$$$reportNull$$$0(10);
            }
            if ((location = this.getLocation()) != null) {
                if (this.getSettings().isShowURL()) {
                    presentation.setLocationString(location);
                } else {
                    presentation.setTooltip(location);
                }
            }
            ProjectViewNodeDecorator projectViewNodeDecorator = decorator = (parent = this.findParent(ProjectNode.class)) == null ? null : parent.decorator;
            if (decorator != null) {
                decorator.decorate(this, presentation);
            }
        }

        @NotNull
        static Icon getFolderIcon(@Nullable PsiElement element) {
            Icon icon = CompoundIconProvider.findIcon(element, 0);
            Icon icon2 = icon != null ? icon : AllIcons.Nodes.Folder;
            if (icon2 == null) {
                Node.$$$reportNull$$$0(11);
            }
            return icon2;
        }

        @Nullable
        final PsiFileSystemItem findFileSystemItem(@NotNull VirtualFile file2) {
            if (file2 == null) {
                Node.$$$reportNull$$$0(12);
            }
            return PsiUtilCore.findFileSystemItem((Project)this.getProject(), (VirtualFile)file2);
        }

        final <N> N findParent(Class<N> type) {
            for (Node node = this; node != null; node = node.getParent()) {
                if (!type.isInstance((Object)node)) continue;
                return type.cast((Object)node);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: 
                case 6: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Node";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Node";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFolderIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "canRepresent";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileStatusColor";
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "decorate";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findFileSystemItem";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

